/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.iot.onenet.edp;

import android.text.TextUtils;
import com.chinamobile.iot.onenet.edp.Common;
import com.chinamobile.iot.onenet.edp.EdpMsg;
import com.chinamobile.iot.onenet.edp.toolbox.AESUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SaveDataMsg
extends EdpMsg {
    private boolean hasAddress;
    private String srcDeviceId;
    private List<byte[]> dataList = new ArrayList<byte[]>();
    private List<Byte> dataTypeList = new ArrayList<Byte>();
    private Map<Integer, byte[]> binTokenMap = new HashMap<Integer, byte[]>();
    private final int DATA_BUFFER_SIZE = 1024;
    private ByteBuffer dataBuffer = ByteBuffer.allocate(1024).order(ByteOrder.BIG_ENDIAN);
    private static SimpleDateFormat DATAPOINT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static String saveData5MsgSeparator = ",";
    private static String savaData5MsgNewLine = ";";

    public SaveDataMsg() {
        super((byte)-128);
    }

    public static void packSaveData1Msg(JSONObject msg, String token, String dsId, Date dpTime, Object value) throws JSONException {
        if (token != null) {
            msg.put("token", (Object)token);
        }
        JSONObject dp = new JSONObject();
        if (dpTime != null) {
            dp.put("at", (Object)DATAPOINT_DATE_FORMAT.format(dpTime));
        }
        dp.put("value", value);
        if (msg.has("datastreams")) {
            int index;
            JSONArray datastreams = msg.getJSONArray("datastreams");
            for (index = 0; index < datastreams.length(); ++index) {
                JSONObject datastream = datastreams.getJSONObject(index);
                String tempDsId = datastream.getString("id");
                if (dsId.compareTo(tempDsId) != 0) continue;
                JSONArray datapoints = datastream.getJSONArray("datapoints");
                datapoints.put((Object)dp);
                break;
            }
            if (index == datastreams.length()) {
                JSONObject tempDatastream = new JSONObject();
                tempDatastream.put("id", (Object)dsId);
                JSONArray datapoints = new JSONArray();
                datapoints.put((Object)dp);
                tempDatastream.put("datapoints", (Object)datapoints);
                datastreams.put((Object)tempDatastream);
            }
        } else {
            JSONObject tempDatastream = new JSONObject();
            tempDatastream.put("id", (Object)dsId);
            JSONArray datapoints = new JSONArray();
            datapoints.put((Object)dp);
            tempDatastream.put("datapoints", (Object)datapoints);
            JSONArray datastreams = new JSONArray();
            datastreams.put((Object)tempDatastream);
            msg.put("datastreams", (Object)datastreams);
        }
    }

    public static void packSaveData2Token(JSONObject token, String tokenStr, String dsId, Date dpTime, String desc) throws JSONException {
        token.put("ds_id", (Object)dsId);
        if (tokenStr != null) {
            token.put("token", (Object)tokenStr);
        }
        if (dpTime != null) {
            token.put("at", (Object)DATAPOINT_DATE_FORMAT.format(dpTime));
        }
        if (desc != null) {
            token.put("desc", (Object)desc);
        }
    }

    public static void packSaveData3Msg(JSONObject msg, String dsId, Object value) throws JSONException {
        msg.put(dsId, value);
    }

    public static void packSaveData4Msg(JSONObject msg, String dsId, Date dpTime, Object value) throws JSONException {
        String dpTimeStr = DATAPOINT_DATE_FORMAT.format(dpTime);
        if (msg.has(dsId)) {
            msg.getJSONObject(dsId).put(dpTimeStr, value);
        } else {
            JSONObject datastream = new JSONObject();
            datastream.put(dpTimeStr, value);
            msg.put(dsId, (Object)datastream);
        }
    }

    public static void setSaveData5MsgSeparator(String separator, String newLine) {
        saveData5MsgSeparator = separator;
        savaData5MsgNewLine = newLine;
    }

    public static void packetSaveData5Msg(StringBuilder msg, Object value, String dsId, Date dpTime) {
        if (msg.length() < 2) {
            msg.append(saveData5MsgSeparator).append(savaData5MsgNewLine);
        } else {
            msg.append(savaData5MsgNewLine);
        }
        msg.append(dsId).append(saveData5MsgSeparator);
        msg.append(DATAPOINT_DATE_FORMAT.format(dpTime)).append(saveData5MsgSeparator);
        msg.append(value);
    }

    public static void packetSaveData5Msg(StringBuilder msg, Object value, String dsId) {
        if (msg.length() < 2) {
            msg.append(saveData5MsgSeparator).append(savaData5MsgNewLine);
        } else {
            msg.append(savaData5MsgNewLine);
        }
        msg.append(dsId).append(saveData5MsgSeparator);
        msg.append(value);
    }

    public static void packetSaveData5Msg(StringBuilder msg, Object value) {
        if (msg.length() < 2) {
            msg.append(saveData5MsgSeparator).append(savaData5MsgNewLine);
        } else {
            msg.append(savaData5MsgNewLine);
        }
        msg.append(value);
    }

    @Override
    public void unpackMsg(byte[] msgData) throws IOException {
        if (!TextUtils.isEmpty((CharSequence)this.getSecretKey())) {
            switch (this.getAlgorithm()) {
                case 1: {
                    try {
                        msgData = AESUtils.decrypt(msgData, this.getSecretKey().getBytes());
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        int dataLen = msgData.length;
        int dataRemain = dataLen - 1;
        int position = 1;
        this.hasAddress = msgData[0] == -128;
        if (this.hasAddress) {
            if (dataLen < 8) {
                throw new IOException("save data length too short. dataLen=" + dataLen);
            }
            int addressLen = Common.twoByteToLen(msgData[1], msgData[2]);
            position += 2;
            if (!this.checkAddressLen(addressLen) || addressLen > dataLen - 3) {
                throw new IOException("address length exception. addressLen=" + addressLen);
            }
            this.srcDeviceId = new String(msgData, 3, addressLen);
            position += addressLen;
            dataRemain = dataRemain - 2 - addressLen;
        }
        int index = 0;
        while (dataRemain > 0) {
            if (dataRemain < 3) {
                throw new IOException("data remain length too short.");
            }
            byte dataType = msgData[position];
            int datapointLen = Common.twoByteToLen(msgData[++position], msgData[position + 1]);
            position += 2;
            if (datapointLen > (dataRemain -= 3)) {
                throw new IOException("datapoint_length too long. datapointLen=" + datapointLen + " dataRemain=" + dataRemain);
            }
            byte[] datapoint = new byte[datapointLen];
            System.arraycopy(msgData, position, datapoint, 0, datapointLen);
            position += datapointLen;
            dataRemain -= datapointLen;
            if (dataType < 1 || dataType > 5) {
                throw new IOException("not supported data_type:" + dataType);
            }
            if (dataType != 2) {
                this.dataTypeList.add(dataType);
                this.dataList.add(datapoint);
            } else {
                if (dataRemain < 4) {
                    throw new IOException("[save_data] bin_data no enouth length bytes.");
                }
                int binDataLen = Common.fourByteToLen(msgData[position], msgData[position + 1], msgData[position + 2], msgData[position + 3]);
                position += 4;
                if (binDataLen > (dataRemain -= 4)) {
                    throw new IOException("[sava_data] bin_data too long.length=" + binDataLen + " dataRemain=" + dataRemain);
                }
                byte[] binData = new byte[binDataLen];
                System.arraycopy(msgData, position, binData, 0, binDataLen);
                this.dataTypeList.add(dataType);
                this.binTokenMap.put(index, datapoint);
                this.dataList.add(binData);
                position += binDataLen;
                dataRemain -= binDataLen;
            }
            ++index;
        }
    }

    public boolean packMsg(String desDeviceId, int dataType, String tokenStr, byte[] _data) {
        this.dataBuffer.clear();
        boolean hasDeviceId = true;
        if (TextUtils.isEmpty((CharSequence)desDeviceId)) {
            hasDeviceId = false;
        }
        if (hasDeviceId) {
            this.dataBuffer.put((byte)-128);
            short idLen = (short)desDeviceId.length();
            this.dataBuffer.putShort(idLen);
            this.dataBuffer.put(desDeviceId.getBytes());
        } else {
            this.dataBuffer.put((byte)0);
        }
        return this.addDatapoint(dataType, tokenStr, _data);
    }

    public boolean packMsg(int dataType, String tokenStr, byte[] _data) {
        return this.packMsg("0", dataType, tokenStr, _data);
    }

    public boolean addDatapoint(int dataType, String tokenStr, byte[] _data) {
        if (dataType == 1 || dataType > 2 && dataType <= 5) {
            int needBufferSize = 3 + _data.length;
            if (needBufferSize > this.dataBuffer.remaining()) {
                int newBufferSize = needBufferSize + this.dataBuffer.position();
                ByteBuffer newBuffer = ByteBuffer.allocate(newBufferSize).order(ByteOrder.BIG_ENDIAN);
                byte[] oldData = new byte[this.dataBuffer.position()];
                this.dataBuffer.flip();
                this.dataBuffer.get(oldData);
                newBuffer.put(oldData);
                this.dataBuffer = newBuffer;
            }
            this.dataBuffer.put((byte)dataType);
            short dataLen = (short)_data.length;
            this.dataBuffer.putShort(dataLen);
            this.dataBuffer.put(_data);
            return true;
        }
        if (dataType == 2) {
            short tokenLen = 0;
            tokenLen = tokenStr == null ? (short)0 : (short)tokenStr.length();
            int needBufferSize = 3 + tokenLen + 4 + _data.length;
            if (needBufferSize > this.dataBuffer.remaining()) {
                int newBufferSize = needBufferSize + this.dataBuffer.position();
                ByteBuffer newBuffer = ByteBuffer.allocate(newBufferSize).order(ByteOrder.BIG_ENDIAN);
                byte[] oldData = new byte[this.dataBuffer.position()];
                this.dataBuffer.flip();
                this.dataBuffer.get(oldData);
                newBuffer.put(oldData);
                this.dataBuffer = newBuffer;
            }
            this.dataBuffer.put((byte)2);
            this.dataBuffer.putShort(tokenLen);
            if (tokenLen > 0) {
                this.dataBuffer.put(tokenStr.getBytes());
            }
            int dataLen = _data.length;
            this.dataBuffer.putInt(dataLen);
            this.dataBuffer.put(_data);
            return true;
        }
        System.err.println("[save_data] packMsg dataType exception. dataType=" + dataType);
        return false;
    }

    public boolean addDatapoint(int dataType, String tokenStr, String data) {
        return this.addDatapoint(dataType, tokenStr, data.getBytes());
    }

    public byte[] commit() {
        int dataSize = this.dataBuffer.position();
        byte[] msgData = new byte[dataSize];
        this.dataBuffer.flip();
        this.dataBuffer.get(msgData);
        byte[] edpPkg = this.packPkg(msgData);
        return edpPkg;
    }

    public boolean getHasAddress() {
        return this.hasAddress;
    }

    public String getSrcDeviceId() {
        return this.srcDeviceId;
    }

    public List<Byte> getDataTypeList() {
        return this.dataTypeList;
    }

    public List<byte[]> getDataList() {
        return this.dataList;
    }
}

