/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.iot.onenet.edp;

import android.text.TextUtils;
import com.chinamobile.iot.onenet.edp.Common;
import com.chinamobile.iot.onenet.edp.EdpMsg;
import com.chinamobile.iot.onenet.edp.toolbox.AESUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class PushDataMsg
extends EdpMsg {
    private String srcDeviceId;
    private int dataLen;
    private byte[] data;

    public PushDataMsg() {
        super((byte)48);
    }

    @Override
    public void unpackMsg(byte[] msgData) throws IOException {
        int dataLen;
        if (!TextUtils.isEmpty((CharSequence)this.getSecretKey())) {
            switch (this.getAlgorithm()) {
                case 1: {
                    try {
                        msgData = AESUtils.decrypt(msgData, this.getSecretKey().getBytes());
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if ((dataLen = msgData.length) < 7) {
            throw new IOException("packet size too short. size:" + dataLen);
        }
        int addressLen = Common.twoByteToLen(msgData[0], msgData[1]);
        int dataRemain = dataLen - 2;
        if (!this.checkAddressLen(addressLen) || addressLen > dataLen - 2) {
            throw new IOException("address size too long.");
        }
        this.srcDeviceId = new String(msgData, 2, addressLen);
        if ((dataRemain -= addressLen) <= 0) {
            throw new IOException("data is null");
        }
        this.data = new byte[dataRemain];
        System.arraycopy(msgData, addressLen + 2, this.data, 0, dataRemain);
    }

    public byte[] packMsg(long desDeviceId, byte[] _data) throws IOException {
        if (desDeviceId <= 0L) {
            throw new IOException("desDeviceId invalid. desDeviceid=" + desDeviceId);
        }
        if (_data == null) {
            throw new IOException("send data is null.");
        }
        String desDeviceIdStr = "" + desDeviceId;
        short addressLen = (short)desDeviceIdStr.length();
        int dataLen = 2 + addressLen + _data.length;
        ByteBuffer buffer = ByteBuffer.allocate(dataLen).order(ByteOrder.BIG_ENDIAN);
        buffer.putShort(addressLen);
        buffer.put(desDeviceIdStr.getBytes());
        buffer.put(_data);
        byte[] edpPkg = this.packPkg(buffer.array());
        return edpPkg;
    }

    public byte[] packMsg(long desDeviceId, String data) throws IOException {
        return this.packMsg(desDeviceId, data.getBytes());
    }

    public String getSrcDeviceId() {
        return this.srcDeviceId;
    }

    public int getDataLen() {
        return this.dataLen;
    }

    public byte[] getData() {
        return this.data;
    }
}

