/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.iot.onenet.edp;

import com.chinamobile.iot.onenet.edp.Common;
import com.chinamobile.iot.onenet.edp.EdpMsg;
import com.chinamobile.iot.onenet.edp.toolbox.RSAUtils;
import java.io.IOException;

public class EncryptRespMsg
extends EdpMsg {
    private String encryptSecretKey;

    public EncryptRespMsg() {
        super((byte)-16);
    }

    @Override
    public void unpackMsg(byte[] msgData) throws IOException {
        int dataLen = msgData.length;
        if (dataLen < 2) {
            throw new IOException("packet size too short. size:" + dataLen);
        }
        int keyLen = Common.twoByteToLen(msgData[0], msgData[1]);
        if (dataLen >= keyLen + 2) {
            byte[] bytes = new byte[keyLen];
            System.arraycopy(msgData, 2, bytes, 0, keyLen);
            this.encryptSecretKey = RSAUtils.bcd2Str(bytes);
        }
    }

    public String getEncryptSecretKey() {
        return this.encryptSecretKey;
    }
}

