/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.iot.onenet.edp;

import android.text.TextUtils;
import com.chinamobile.iot.onenet.edp.toolbox.AESUtils;
import java.io.IOException;
import java.nio.ByteBuffer;

public class EdpMsg {
    private byte type;
    private int algorithm;
    private String secretKey;

    public byte getMsgType() {
        return this.type;
    }

    public EdpMsg(byte msgType) {
        this.type = msgType;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setAlgorithm(int algorithm) {
        this.algorithm = algorithm;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public void unpackMsg(byte[] msgData) throws IOException {
    }

    public byte[] packPkg(byte[] _msgData) {
        int len;
        byte[] pkgDataLength;
        if (!TextUtils.isEmpty((CharSequence)this.secretKey)) {
            switch (this.algorithm) {
                case 1: {
                    try {
                        _msgData = AESUtils.encrypt(_msgData, this.secretKey.getBytes());
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if ((pkgDataLength = this.packLength(len = _msgData.length)) == null) {
            System.err.println("[packPkg] packet data length exception. data_len=" + len);
            return null;
        }
        int pkgDataLengthSize = pkgDataLength.length;
        int pkgLength = 1 + pkgDataLengthSize + len;
        ByteBuffer packet = ByteBuffer.allocate(pkgLength);
        packet.put(this.type);
        packet.put(pkgDataLength);
        packet.put(_msgData);
        return packet.array();
    }

    public byte[] packLength(int size) {
        int twoByteMin = 128;
        int threeByteMin = 16384;
        int fourByteMin = 0x200000;
        int maxSize = 0xFFFFFFF;
        ByteBuffer sizeBuffer = ByteBuffer.allocate(4);
        int cnt = 0;
        if (size > maxSize) {
            return null;
        }
        cnt = size >= fourByteMin ? 4 : (size >= threeByteMin ? 3 : (size >= twoByteMin ? 2 : 1));
        byte bSize = 0;
        for (int i = 0; i < cnt; ++i) {
            if (i == cnt - 1) {
                bSize = (byte)size;
            } else {
                bSize = (byte)(size & 0x7F | 0x80);
                size >>= 7;
            }
            sizeBuffer.put(bSize);
        }
        int bufferSize = sizeBuffer.position();
        byte[] sizeArray = new byte[bufferSize];
        sizeBuffer.flip();
        sizeBuffer.get(sizeArray);
        return sizeArray;
    }

    public boolean checkAddressLen(int _len) {
        return _len >= 5 && _len <= 10;
    }
}

