/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.iot.onenet.edp;

import com.chinamobile.iot.onenet.edp.CmdMsg;
import com.chinamobile.iot.onenet.edp.ConnectCloseMsg;
import com.chinamobile.iot.onenet.edp.ConnectRespMsg;
import com.chinamobile.iot.onenet.edp.EdpMsg;
import com.chinamobile.iot.onenet.edp.EdpPacket;
import com.chinamobile.iot.onenet.edp.EncryptRespMsg;
import com.chinamobile.iot.onenet.edp.PingRespMsg;
import com.chinamobile.iot.onenet.edp.PushDataMsg;
import com.chinamobile.iot.onenet.edp.SaveDataMsg;
import com.chinamobile.iot.onenet.edp.SaveRespMsg;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class EdpKit {
    private final int BUFFER_LEN = 1024;
    public static final String EDP_PROTOCOL = "EDP";
    private ByteBuffer cache = ByteBuffer.allocate(1024).order(ByteOrder.BIG_ENDIAN);

    private boolean checkCacheCapacity(int packetSize) {
        if (packetSize > this.cache.remaining()) {
            int srcDataLen = this.cache.position();
            int newCacheLen = srcDataLen + packetSize;
            ByteBuffer newBuffer = ByteBuffer.allocate(newCacheLen);
            byte[] srcData = new byte[srcDataLen];
            this.cache.flip();
            this.cache.get(srcData);
            newBuffer.put(srcData);
            this.cache = newBuffer;
            return false;
        }
        return true;
    }

    private EdpPacket popPacket() {
        if (this.cache.remaining() <= 1) {
            this.cache.compact();
            return null;
        }
        EdpPacket packet = new EdpPacket();
        int startPos = this.cache.position();
        packet.type = this.cache.get();
        int packetValidLen = this.cache.limit() - startPos;
        int packetRemainLen = 0;
        int remainLen = 0;
        int firstLen = this.cache.get() & 0xFF;
        if (firstLen > 127) {
            if (packetValidLen <= startPos + 5) {
                return null;
            }
            int secondLen = this.cache.get() & 0xFF;
            if (secondLen <= 127) {
                packetRemainLen = packetValidLen - 3;
                remainLen = (secondLen << 7) + (firstLen & 0x7F);
            } else {
                int thirdLen = this.cache.get() & 0xFF;
                if (thirdLen <= 127) {
                    packetRemainLen = packetValidLen - 4;
                    remainLen = (thirdLen << 14) + ((secondLen & 0x7F) << 7) + (firstLen & 0x7F);
                } else {
                    int fourthLen = this.cache.get() & 0xFF;
                    packetRemainLen = packetValidLen - 5;
                    remainLen = ((fourthLen & 0x7F) << 21) + ((thirdLen & 0x7F) << 14) + ((secondLen & 0x7F) << 7) + (firstLen & 0x7F);
                }
            }
        } else {
            remainLen = firstLen;
            packetRemainLen = packetValidLen - 2;
        }
        if (packetRemainLen < remainLen) {
            this.cache.position(startPos);
            this.cache.compact();
            return null;
        }
        packet.dataLength = remainLen;
        packet.data = new byte[remainLen];
        this.cache.get(packet.data);
        return packet;
    }

    private EdpMsg resolvePacket(EdpPacket packet, int algorithm, String secretKey) throws IOException {
        if (packet == null) {
            throw new IOException("packet is null");
        }
        switch (packet.type) {
            case 32: {
                ConnectRespMsg connRespMsg = new ConnectRespMsg();
                connRespMsg.setAlgorithm(algorithm);
                connRespMsg.setSecretKey(secretKey);
                ((EdpMsg)connRespMsg).unpackMsg(packet.data);
                return connRespMsg;
            }
            case 48: {
                PushDataMsg pushDataMsg = new PushDataMsg();
                pushDataMsg.setAlgorithm(algorithm);
                pushDataMsg.setSecretKey(secretKey);
                ((EdpMsg)pushDataMsg).unpackMsg(packet.data);
                return pushDataMsg;
            }
            case 64: {
                ConnectCloseMsg connectCloseMsg = new ConnectCloseMsg();
                connectCloseMsg.setAlgorithm(algorithm);
                connectCloseMsg.setSecretKey(secretKey);
                ((EdpMsg)connectCloseMsg).unpackMsg(packet.data);
                return connectCloseMsg;
            }
            case -128: {
                SaveDataMsg saveDataMsg = new SaveDataMsg();
                saveDataMsg.setAlgorithm(algorithm);
                saveDataMsg.setSecretKey(secretKey);
                ((EdpMsg)saveDataMsg).unpackMsg(packet.data);
                return saveDataMsg;
            }
            case -112: {
                SaveRespMsg saveRespMsg = new SaveRespMsg();
                saveRespMsg.setAlgorithm(algorithm);
                saveRespMsg.setSecretKey(secretKey);
                ((EdpMsg)saveRespMsg).unpackMsg(packet.data);
                return saveRespMsg;
            }
            case -48: {
                PingRespMsg pingRespMsg = new PingRespMsg();
                pingRespMsg.setAlgorithm(algorithm);
                pingRespMsg.setSecretKey(secretKey);
                pingRespMsg.unpackMsg(packet.data);
                return pingRespMsg;
            }
            case -96: {
                CmdMsg cmdMsg = new CmdMsg();
                cmdMsg.setAlgorithm(algorithm);
                cmdMsg.setSecretKey(secretKey);
                ((EdpMsg)cmdMsg).unpackMsg(packet.data);
                return cmdMsg;
            }
            case -16: {
                EncryptRespMsg encryptRespMsg = new EncryptRespMsg();
                ((EdpMsg)encryptRespMsg).unpackMsg(packet.data);
                return encryptRespMsg;
            }
        }
        return null;
    }

    public List<EdpMsg> unpack(byte[] packet, int algorithm, String secretKey) {
        ArrayList<EdpMsg> msgList = new ArrayList<EdpMsg>();
        if (packet == null || packet.length <= 0) {
            return null;
        }
        int packetLen = packet.length;
        this.checkCacheCapacity(packetLen);
        this.cache.put(packet);
        EdpPacket recvPacket = null;
        this.cache.flip();
        while ((recvPacket = this.popPacket()) != null) {
            try {
                EdpMsg msg = this.resolvePacket(recvPacket, algorithm, secretKey);
                if (msg == null) continue;
                msgList.add(msg);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (msgList.size() == 0) {
            return null;
        }
        return msgList;
    }

    public List<EdpMsg> unpack(byte[] packet) {
        return this.unpack(packet, -1, null);
    }
}

