/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.iot.onenet.edp;

import android.text.TextUtils;
import com.chinamobile.iot.onenet.edp.Common;
import com.chinamobile.iot.onenet.edp.EdpMsg;
import com.chinamobile.iot.onenet.edp.toolbox.AESUtils;
import java.io.IOException;

public class ConnectRespMsg
extends EdpMsg {
    private boolean hasLicenseCode = false;
    private byte resCode;
    private int licenseCodeLen;
    private String licenseCode;

    ConnectRespMsg() {
        super((byte)32);
    }

    @Override
    public void unpackMsg(byte[] msgData) throws IOException {
        int dataLen;
        if (!TextUtils.isEmpty((CharSequence)this.getSecretKey())) {
            switch (this.getAlgorithm()) {
                case 1: {
                    try {
                        msgData = AESUtils.decrypt(msgData, this.getSecretKey().getBytes());
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if ((dataLen = msgData.length) < 2) {
            throw new IOException("packet size too short. size:" + dataLen);
        }
        this.resCode = msgData[1];
        if (msgData[0] == 1) {
            this.hasLicenseCode = true;
            if (dataLen < 4) {
                throw new IOException("packet has license code but size too short. size:" + dataLen);
            }
            int dataRemain = dataLen - 4;
            int licenseCodeLen = Common.twoByteToLen(msgData[2], msgData[3]);
            if (dataRemain < licenseCodeLen) {
                throw new IOException("packet remain size shorter than license code size");
            }
            this.licenseCode = new String(msgData, 4, licenseCodeLen);
        } else {
            this.hasLicenseCode = false;
        }
    }

    public byte getResCode() {
        return this.resCode;
    }

    public boolean getHasLicenseCode() {
        return this.hasLicenseCode;
    }

    public int getLicenseCodeLen() {
        return this.licenseCodeLen;
    }

    public String getLicenseCode() {
        return this.licenseCode;
    }
}

