/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.iot.onenet.edp;

import android.text.TextUtils;
import com.chinamobile.iot.onenet.edp.EdpMsg;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ConnectMsg
extends EdpMsg {
    public ConnectMsg() {
        super((byte)16);
    }

    public byte[] packMsg(String deviceId, String userId, String authInfo, short connectTimeout) {
        short strLen;
        if (authInfo == null) {
            return null;
        }
        ByteBuffer data = ByteBuffer.allocate(256).order(ByteOrder.BIG_ENDIAN);
        data.putShort((short)"EDP".length());
        data.put("EDP".getBytes());
        data.put((byte)1);
        if (!"0".equals(userId)) {
            data.put((byte)-64);
        } else {
            data.put((byte)64);
        }
        data.putShort(connectTimeout);
        if (!TextUtils.isEmpty((CharSequence)deviceId)) {
            strLen = (short)deviceId.length();
            data.putShort(strLen);
            data.put(deviceId.getBytes());
        } else {
            data.putShort((short)0);
        }
        if (!TextUtils.isEmpty((CharSequence)userId) && !"0".equals(userId)) {
            strLen = (short)userId.length();
            data.putShort(strLen);
            data.put(userId.getBytes());
        }
        short infoLen = (byte)authInfo.length();
        data.putShort(infoLen);
        data.put(authInfo.getBytes());
        int packetSize = data.position();
        byte[] packet = new byte[packetSize];
        data.flip();
        data.get(packet);
        byte[] edpPkg = this.packPkg(packet);
        return edpPkg;
    }

    public byte[] packMsg(String deviceId, String userId, String authInfo) {
        return this.packMsg(deviceId, userId, authInfo, (short)240);
    }

    public byte[] packMsg(String deviceId, String authInfo) {
        return this.packMsg(deviceId, "0", authInfo, (short)240);
    }
}

