/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.iot.onenet.edp;

import android.text.TextUtils;
import com.chinamobile.iot.onenet.edp.Common;
import com.chinamobile.iot.onenet.edp.EdpMsg;
import com.chinamobile.iot.onenet.edp.toolbox.AESUtils;
import java.io.IOException;

public class CmdMsg
extends EdpMsg {
    private String cmdId;
    private byte[] data;

    public CmdMsg() {
        super((byte)-96);
    }

    public byte[] packMsg() {
        return null;
    }

    @Override
    public void unpackMsg(byte[] msgData) throws IOException {
        int dataLen;
        if (!TextUtils.isEmpty((CharSequence)this.getSecretKey())) {
            switch (this.getAlgorithm()) {
                case 1: {
                    try {
                        msgData = AESUtils.decrypt(msgData, this.getSecretKey().getBytes());
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if ((dataLen = msgData.length) < 8) {
            throw new IOException("packet size too short. size:" + dataLen);
        }
        int cmdIdLen = Common.twoByteToLen(msgData[0], msgData[1]);
        int respDataLen = Common.fourByteToLen(msgData[cmdIdLen + 2], msgData[cmdIdLen + 3], msgData[cmdIdLen + 4], msgData[cmdIdLen + 5]);
        int dataRemain = dataLen - cmdIdLen - 6;
        this.cmdId = new String(msgData, 2, cmdIdLen);
        if (respDataLen > 0 && dataRemain > 0) {
            respDataLen = Math.min(dataRemain, respDataLen);
            this.data = new byte[respDataLen];
            System.arraycopy(msgData, cmdIdLen + 6, this.data, 0, respDataLen);
        }
    }

    public String getCmdId() {
        return this.cmdId;
    }

    public byte[] getData() {
        return this.data;
    }
}

