/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.tools;

import es.rickyepoderi.wbxml.definition.WbXmlDefinition;
import es.rickyepoderi.wbxml.definition.WbXmlInitialization;
import es.rickyepoderi.wbxml.document.WbXmlEncoder;
import es.rickyepoderi.wbxml.document.WbXmlVersion;
import es.rickyepoderi.wbxml.stream.WbXmlOutputFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Xml2WbXml {
    private InputStream in = null;
    private OutputStream out = null;
    private boolean useDom = true;
    private WbXmlDefinition def = null;
    private WbXmlEncoder.StrtblType type = WbXmlEncoder.StrtblType.IF_NEEDED;
    private boolean skipSpaces = true;
    private boolean event = false;
    private WbXmlVersion version = WbXmlVersion.VERSION_1_3;
    private Charset charset = Charset.forName("UTF-8");

    private void usage(String message) {
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        sb.append(System.getProperty("line.separator"));
        sb.append(System.getProperty("line.separator"));
        sb.append("java -cp wbxml-jaxb-X.X.X.jar ");
        sb.append(this.getClass().getName());
        sb.append(" [-j --jaxb] [-t --type <TYPE>] [-k --keep] [-d --definition <NAME>] {infile} {outfile}");
        sb.append(System.getProperty("line.separator"));
        sb.append("       -j --jaxb: Use JAXB instead instead default DOM");
        sb.append(System.getProperty("line.separator"));
        sb.append("      -e --event: Use XMLEventWriter instead of the default XMLStreamWriter");
        sb.append(System.getProperty("line.separator"));
        sb.append("                  In order to use JAXB the classes should be generated from the DTD (xjc)");
        sb.append(System.getProperty("line.separator"));
        sb.append("       -t --type: Type of STR table use. Values: IF_NEEDED (default), ALWAYS, NO");
        sb.append(System.getProperty("line.separator"));
        sb.append("       -k --keep: Keep spaces from the XML (default no)");
        sb.append(System.getProperty("line.separator"));
        sb.append("    -v --version: WBXML version to use: 1.0, 1.1, 1.2, 1.3 (default)");
        sb.append(System.getProperty("line.separator"));
        sb.append("    -c --charset: Java charset to encode the WbXML document (default: UTF-8)");
        sb.append(System.getProperty("line.separator"));
        sb.append(" -d --definition: Force definition instead deriving from XML. Current definitions:");
        sb.append(System.getProperty("line.separator"));
        for (WbXmlDefinition d : WbXmlInitialization.getDefinitions()) {
            sb.append(String.format("                  %s", d.getName()));
            sb.append(System.getProperty("line.separator"));
        }
        sb.append("          infile: input XML file (\"-\" means standard input)");
        sb.append(System.getProperty("line.separator"));
        sb.append("         outfile: output WBXML file (\"-\" means standard output)");
        sb.append(System.getProperty("line.separator"));
        throw new IllegalArgumentException(sb.toString());
    }

    private String getNext(String[] args, int i) {
        if (args.length > i) {
            return args[i];
        }
        this.usage("Invalid invocation.");
        return null;
    }

    private Xml2WbXml(String[] args) throws Exception {
        File f;
        String infile = null;
        String outfile = null;
        int i = 0;
        if (args.length < 2) {
            this.usage("Invalid invocation.");
        }
        while (i < args.length) {
            String name;
            if ("-d".equals(args[i]) || "--definition".equals(args[i])) {
                String defName = this.getNext(args, ++i);
                this.def = WbXmlInitialization.getDefinitionByName(defName);
                if (this.def == null) {
                    this.usage(String.format("Invalid definition specified '%s'.", defName));
                }
            } else if ("-j".equals(args[i]) || "--jaxb".equals(args[i])) {
                this.useDom = false;
            } else if ("-e".equals(args[i]) || "--event".equals(args[i])) {
                this.event = true;
            } else if ("-t".equals(args[i]) || "--type".equals(args[i])) {
                name = this.getNext(args, ++i);
                try {
                    this.type = WbXmlEncoder.StrtblType.valueOf(name);
                }
                catch (Exception e) {
                    this.usage(String.format("Invalid STR type '%s'.", name));
                }
            } else if ("-k".equals(args[i]) || "--keep".equals(args[i])) {
                this.skipSpaces = false;
            } else if ("-v".equals(args[i]) || "--version".equals(args[i])) {
                String v = this.getNext(args, ++i);
                this.version = WbXmlVersion.locateVersion(v);
                if (this.version == null) {
                    this.usage(String.format("Invalid version '%s'. Version should be 1.0, 1.1, 1.2 or 1.3.", v));
                }
            } else if ("-c".equals(args[i]) || "--charset".equals(args[i])) {
                name = this.getNext(args, ++i);
                try {
                    this.charset = Charset.forName(name);
                }
                catch (UnsupportedCharsetException e) {
                    this.usage(String.format("Unsupported charset '%s'.", name));
                }
            } else {
                if (args.length - i != 2) {
                    this.usage("Invalid invocation.");
                }
                infile = this.getNext(args, i);
                outfile = this.getNext(args, ++i);
            }
            ++i;
        }
        if ("-".equals(infile)) {
            this.in = System.in;
        } else {
            f = new File(infile);
            if (!f.exists() || !f.canRead()) {
                this.usage(String.format("Input XML file '%s' is not readable.", infile));
            }
            this.in = new FileInputStream(f);
        }
        if ("-".equals(outfile)) {
            this.out = System.out;
        } else {
            f = new File(outfile);
            f.createNewFile();
            if (!f.canWrite()) {
                this.usage(String.format("Output WBXML file '%s' is not writable.", outfile));
            }
            this.out = new FileOutputStream(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws Exception {
        XMLStreamWriter xmlStreamWriter = null;
        XMLEventWriter xmlEventWriter = null;
        try {
            DocumentBuilderFactory domFact = DocumentBuilderFactory.newInstance();
            domFact.setNamespaceAware(true);
            domFact.setIgnoringElementContentWhitespace(true);
            domFact.setIgnoringComments(true);
            domFact.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder domBuilder = domFact.newDocumentBuilder();
            Document doc = domBuilder.parse(this.in);
            Element element = doc.getDocumentElement();
            element.normalize();
            if (this.def == null) {
                if (doc.getDoctype() != null && doc.getDoctype().getPublicId() != null) {
                    this.def = WbXmlInitialization.getDefinitionByFPI(doc.getDoctype().getPublicId());
                }
                if (this.def == null) {
                    this.def = WbXmlInitialization.getDefinitionByRoot(element.getLocalName(), element.getNamespaceURI());
                    if (this.def == null) {
                        this.usage(String.format("Definition not found for name=%s and namespace=%s. Use -d argument to force it.", element.getLocalName(), element.getNamespaceURI()));
                    }
                }
            }
            WbXmlOutputFactory fact = new WbXmlOutputFactory();
            ((XMLOutputFactory)fact).setProperty(WbXmlOutputFactory.DEFINITION_PROPERTY, this.def);
            ((XMLOutputFactory)fact).setProperty(WbXmlOutputFactory.ENCODING_TYPE_PROPERTY, (Object)this.type);
            ((XMLOutputFactory)fact).setProperty(WbXmlOutputFactory.SKIP_SPACES_PROPERTY, this.skipSpaces);
            ((XMLOutputFactory)fact).setProperty(WbXmlOutputFactory.VERSION_PROPERTY, (Object)this.version);
            if (!this.useDom) {
                String clazz = this.def.getClazz();
                if (clazz == null || clazz.isEmpty()) {
                    this.usage(String.format("The definition '%s' does not contain a main class.", this.def.getName()));
                }
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Class.forName(clazz)});
                Unmarshaller unmarshaller = jc.createUnmarshaller();
                Object obj = unmarshaller.unmarshal((Node)doc);
                Marshaller marshaller = jc.createMarshaller();
                if (this.event) {
                    xmlEventWriter = ((XMLOutputFactory)fact).createXMLEventWriter(this.out, this.charset.name());
                    marshaller.marshal(obj, xmlEventWriter);
                } else {
                    xmlStreamWriter = ((XMLOutputFactory)fact).createXMLStreamWriter(this.out, this.charset.name());
                    marshaller.marshal(obj, xmlStreamWriter);
                }
            } else {
                StAXResult staxResult;
                Transformer xformer = TransformerFactory.newInstance().newTransformer();
                xformer.setOutputProperty("encoding", this.charset.name());
                DOMSource domSource = new DOMSource(doc);
                if (this.event) {
                    xmlEventWriter = ((XMLOutputFactory)fact).createXMLEventWriter(this.out, this.charset.name());
                    staxResult = new StAXResult(xmlEventWriter);
                } else {
                    xmlStreamWriter = ((XMLOutputFactory)fact).createXMLStreamWriter(this.out, this.charset.name());
                    staxResult = new StAXResult(xmlStreamWriter);
                }
                xformer.transform(domSource, staxResult);
            }
        }
        finally {
            if (xmlStreamWriter != null) {
                try {
                    xmlStreamWriter.close();
                }
                catch (Exception exception) {}
            }
            if (xmlEventWriter != null) {
                try {
                    xmlEventWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void close() {
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        Xml2WbXml command = null;
        try {
            command = new Xml2WbXml(args);
            command.process();
        }
        finally {
            if (command != null) {
                command.close();
            }
        }
    }
}

