/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.tools;

import es.rickyepoderi.wbxml.definition.WbXmlDefinition;
import es.rickyepoderi.wbxml.definition.WbXmlInitialization;
import es.rickyepoderi.wbxml.document.WbXmlParser;
import es.rickyepoderi.wbxml.stream.WbXmlEventReader;
import es.rickyepoderi.wbxml.stream.WbXmlInputFactory;
import es.rickyepoderi.wbxml.stream.WbXmlStreamReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;

public final class WbXml2Xml {
    private InputStream in = null;
    private OutputStream out = null;
    private boolean useDom = true;
    private WbXmlDefinition def = null;
    private boolean event = false;

    private void usage(String message) {
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        sb.append(System.getProperty("line.separator"));
        sb.append(System.getProperty("line.separator"));
        sb.append("java -cp wbxml-jaxb-X.X.X.jar ");
        sb.append(this.getClass().getName());
        sb.append(" [-j --jaxb] [-d --definition <NAME>] {infile} {outfile}");
        sb.append(System.getProperty("line.separator"));
        sb.append("       -j --jaxb: Use JAXB instead instead default DOM");
        sb.append(System.getProperty("line.separator"));
        sb.append("      -e --event: Use XMLEventWriter instead of the default XMLStreamWriter");
        sb.append(System.getProperty("line.separator"));
        sb.append("                  In order to use JAXB the classes should be generated from the DTD (xjc)");
        sb.append(System.getProperty("line.separator"));
        sb.append(" -d --definition: Force definition instead deriving from WBXML. Current definitions:");
        sb.append(System.getProperty("line.separator"));
        for (WbXmlDefinition d : WbXmlInitialization.getDefinitions()) {
            sb.append(String.format("                  %s", d.getName()));
            sb.append(System.getProperty("line.separator"));
        }
        sb.append("          infile: input WBXML file (\"-\" means standard input)");
        sb.append(System.getProperty("line.separator"));
        sb.append("         outfile: output XML file (\"-\" means standard output)");
        sb.append(System.getProperty("line.separator"));
        throw new IllegalArgumentException(sb.toString());
    }

    private String getNext(String[] args, int i) {
        if (args.length > i) {
            return args[i];
        }
        this.usage("Invalid invocation.");
        return null;
    }

    private WbXml2Xml(String[] args) throws Exception {
        File f;
        String infile = null;
        String outfile = null;
        int i = 0;
        if (args.length < 2) {
            this.usage("Invalid invocation.");
        }
        while (i < args.length) {
            if ("-d".equals(args[i]) || "--definition".equals(args[i])) {
                String defName = this.getNext(args, ++i);
                this.def = WbXmlInitialization.getDefinitionByName(defName);
                if (this.def == null) {
                    this.usage(String.format("Invalid definition specified '%s'.", defName));
                }
            } else if ("-e".equals(args[i]) || "--event".equals(args[i])) {
                this.event = true;
            } else if ("-j".equals(args[i]) || "--jaxb".equals(args[i])) {
                this.useDom = false;
            } else {
                if (args.length - i != 2) {
                    this.usage("Invalid invocation.");
                }
                infile = this.getNext(args, i);
                outfile = this.getNext(args, ++i);
            }
            ++i;
        }
        if ("-".equals(infile)) {
            this.in = System.in;
        } else {
            f = new File(infile);
            if (!f.exists() || !f.canRead()) {
                this.usage(String.format("Input WBXML file '%s' is not readable.", infile));
            }
            this.in = new FileInputStream(f);
        }
        if ("-".equals(outfile)) {
            this.out = System.out;
        } else {
            f = new File(outfile);
            f.createNewFile();
            if (!f.canWrite()) {
                this.usage(String.format("Output XML file '%s' is not writable.", outfile));
            }
            this.out = new FileOutputStream(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws Exception {
        XMLStreamReader xmlStreamReader = null;
        XMLEventReader xmlEventReader = null;
        WbXmlInputFactory fact = new WbXmlInputFactory();
        ((XMLInputFactory)fact).setProperty(WbXmlInputFactory.DEFINITION_PROPERTY, this.def);
        try {
            WbXmlParser parser;
            if (this.event) {
                xmlEventReader = ((XMLInputFactory)fact).createXMLEventReader(this.in);
                parser = ((WbXmlEventReader)xmlEventReader).getParser();
            } else {
                xmlStreamReader = ((XMLInputFactory)fact).createXMLStreamReader(this.in);
                parser = ((WbXmlStreamReader)xmlStreamReader).getParser();
            }
            if (!this.useDom) {
                String clazz = parser.getDefinition().getClazz();
                if (clazz == null || clazz.isEmpty()) {
                    this.usage(String.format("The definition '%s' does not contain a main class.", parser.getDefinition().getName()));
                }
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Class.forName(clazz)});
                Unmarshaller unmarshaller = jc.createUnmarshaller();
                Object obj = this.event ? unmarshaller.unmarshal(xmlEventReader) : unmarshaller.unmarshal(xmlStreamReader);
                Marshaller marshaller = jc.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                if (parser.getDefinition().getXmlPublicId() != null && parser.getDefinition().getXmlUriRef() != null) {
                    marshaller.setProperty("com.sun.xml.internal.bind.xmlHeaders", (Object)String.format("\n<!DOCTYPE %s PUBLIC \"%s\" \"%s\">", jc.createJAXBIntrospector().getElementName(obj), parser.getDefinition().getXmlPublicId(), parser.getDefinition().getXmlUriRef()));
                }
                marshaller.marshal(obj, this.out);
            } else {
                Transformer xformer = TransformerFactory.newInstance().newTransformer();
                if (parser.getDefinition().getXmlPublicId() != null && parser.getDefinition().getXmlUriRef() != null) {
                    xformer.setOutputProperty("doctype-public", parser.getDefinition().getXmlPublicId());
                    xformer.setOutputProperty("doctype-system", parser.getDefinition().getXmlUriRef());
                }
                xformer.setOutputProperty("indent", "yes");
                xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                StAXSource staxSource = this.event ? new StAXSource(xmlEventReader) : new StAXSource(xmlStreamReader);
                DOMResult domResult = new DOMResult();
                xformer.transform(staxSource, domResult);
                DOMSource domSource = new DOMSource(domResult.getNode(), domResult.getSystemId());
                StreamResult result = new StreamResult(this.out);
                xformer.transform(domSource, result);
            }
        }
        finally {
            if (xmlStreamReader != null) {
                try {
                    xmlStreamReader.close();
                }
                catch (Exception exception) {}
            }
            if (xmlEventReader != null) {
                try {
                    xmlEventReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void close() {
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        WbXml2Xml command = null;
        try {
            command = new WbXml2Xml(args);
            command.process();
        }
        finally {
            if (command != null) {
                command.close();
            }
        }
    }
}

