/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.stream.events;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.stream.util.XMLEventConsumer;

public class WbXmlEventAllocator
implements XMLEventAllocator {
    private XMLEventFactory factory;

    public WbXmlEventAllocator(XMLEventFactory factory) {
        this.factory = factory;
    }

    @Override
    public XMLEventAllocator newInstance() {
        return new WbXmlEventAllocator(this.factory);
    }

    @Override
    public XMLEvent allocate(XMLStreamReader streamReader) throws XMLStreamException {
        return this.getXMLEvent(streamReader);
    }

    @Override
    public void allocate(XMLStreamReader streamReader, XMLEventConsumer consumer) throws XMLStreamException {
        consumer.add(this.getXMLEvent(streamReader));
    }

    protected XMLEvent getXMLEvent(XMLStreamReader reader) {
        XMLEvent event = null;
        int eventType = reader.getEventType();
        this.factory.setLocation(reader.getLocation());
        switch (eventType) {
            case 1: {
                StartElement startElement = this.factory.createStartElement(new QName(reader.getNamespaceURI(), reader.getLocalName(), reader.getPrefix()), this.getAttributes(reader), this.getNamespaces(reader));
                event = startElement;
                break;
            }
            case 2: {
                EndElement endElement = this.factory.createEndElement(new QName(reader.getNamespaceURI(), reader.getLocalName(), reader.getPrefix()), this.getNamespaces(reader));
                event = endElement;
                break;
            }
            case 3: {
                event = this.factory.createProcessingInstruction(reader.getPITarget(), reader.getPIData());
                break;
            }
            case 4: {
                if (reader.isWhiteSpace()) {
                    event = this.factory.createSpace(reader.getText());
                    break;
                }
                event = this.factory.createCharacters(reader.getText());
                break;
            }
            case 5: {
                event = this.factory.createComment(reader.getText());
                break;
            }
            case 7: {
                StartDocument docEvent = this.factory.createStartDocument(reader.getEncoding(), reader.getVersion(), reader.isStandalone());
                event = docEvent;
                break;
            }
            case 8: {
                EndDocument endDocumentEvent = this.factory.createEndDocument();
                event = endDocumentEvent;
                break;
            }
            case 11: {
                event = this.factory.createDTD(reader.getText());
                break;
            }
            case 12: {
                event = this.factory.createCData(reader.getText());
                break;
            }
            case 6: {
                event = this.factory.createSpace(reader.getText());
            }
        }
        return event;
    }

    protected Iterator<Attribute> getAttributes(XMLStreamReader streamReader) {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(streamReader.getAttributeCount());
        for (int i = 0; i < streamReader.getAttributeCount(); ++i) {
            Attribute attr = this.factory.createAttribute(streamReader.getAttributeName(i), streamReader.getAttributeValue(i));
            attrs.add(attr);
        }
        return attrs.iterator();
    }

    protected Iterator<Namespace> getNamespaces(XMLStreamReader streamReader) {
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>(streamReader.getNamespaceCount());
        for (int i = 0; i < streamReader.getNamespaceCount(); ++i) {
            Namespace namespace = this.factory.createNamespace(streamReader.getNamespacePrefix(i), streamReader.getNamespaceURI(i));
            namespaces.add(namespace);
        }
        return namespaces.iterator();
    }
}

