/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.stream;

import com.sun.org.apache.xerces.internal.util.XMLChar;
import es.rickyepoderi.wbxml.definition.WbXmlDefinition;
import es.rickyepoderi.wbxml.definition.WbXmlNamespaceDef;
import es.rickyepoderi.wbxml.document.WbXmlAttribute;
import es.rickyepoderi.wbxml.document.WbXmlContent;
import es.rickyepoderi.wbxml.document.WbXmlElement;
import es.rickyepoderi.wbxml.document.WbXmlParser;
import es.rickyepoderi.wbxml.stream.StreamRestorePoint;
import es.rickyepoderi.wbxml.stream.WbXmlNamespaceContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class WbXmlStreamReader
implements XMLStreamReader {
    protected static final Logger log = Logger.getLogger(WbXmlStreamReader.class.getName());
    private WbXmlNamespaceContext nsctx;
    private int event;
    private WbXmlParser parser;
    private Deque<ElementIndex> parents;
    private ElementIndex elementIndex;
    private InputStream is;

    public WbXmlStreamReader(WbXmlParser parser) {
        this.is = null;
        this.elementIndex = new ElementIndex();
        this.parents = new ArrayDeque<ElementIndex>();
        this.parser = parser;
        this.nsctx = new WbXmlNamespaceContext();
        for (WbXmlNamespaceDef nsDef : parser.getDefinition().getNamespaces()) {
            this.nsctx.addPrefix(nsDef.getPrefix(), nsDef.getNamespace());
        }
        for (WbXmlDefinition def : parser.getDefinition().getLinkedDefs()) {
            for (WbXmlNamespaceDef nsDef : def.getNamespaces()) {
                this.nsctx.addPrefix(nsDef.getPrefix(), nsDef.getNamespace());
            }
        }
        this.event = 7;
    }

    public WbXmlStreamReader(InputStream is, WbXmlDefinition definition) throws IOException {
        this.is = is;
        this.elementIndex = new ElementIndex();
        this.parents = new ArrayDeque<ElementIndex>();
        this.parser = new WbXmlParser(this.is);
        this.parser.parse(definition);
        this.nsctx = new WbXmlNamespaceContext();
        for (WbXmlNamespaceDef nsDef : this.parser.getDefinition().getNamespaces()) {
            this.nsctx.addPrefix(nsDef.getPrefix(), nsDef.getNamespace());
        }
        for (WbXmlDefinition def : this.parser.getDefinition().getLinkedDefs()) {
            for (WbXmlNamespaceDef nsDef : def.getNamespaces()) {
                this.nsctx.addPrefix(nsDef.getPrefix(), nsDef.getNamespace());
            }
        }
        this.event = 7;
    }

    public WbXmlStreamReader(InputStream is) throws IOException {
        this(is, null);
    }

    public WbXmlParser getParser() {
        return this.parser;
    }

    public WbXmlElement getCurrentElement() {
        return this.elementIndex.currentElement;
    }

    public WbXmlNamespaceContext getContext() {
        return this.nsctx;
    }

    public StreamRestorePoint backup() {
        return new StreamRestorePoint(this.event, this.parents, this.elementIndex);
    }

    public void restore(StreamRestorePoint backup) {
        this.event = backup.getEvent();
        this.parents = backup.getParents();
        this.elementIndex = backup.getElementIndex();
    }

    @Override
    public boolean isCharacters() {
        log.log(Level.FINE, "isCharacters(): {0}", this.event == 4);
        return this.event == 4;
    }

    @Override
    public boolean isStartElement() {
        log.log(Level.FINE, "isStartElement(): {0}", this.event == 1);
        return this.event == 1;
    }

    @Override
    public boolean isEndElement() {
        log.log(Level.FINE, "isEndElement(): {0}", this.event == 2);
        return this.event == 2;
    }

    @Override
    public boolean isWhiteSpace() {
        log.log(Level.FINE, "isWhiteSpace():");
        if (this.event == 4) {
            char[] ch = this.getTextCharacters();
            int start = this.getTextStart();
            int end = start + this.getTextLength();
            for (int i = start; i < end; ++i) {
                if (XMLChar.isSpace(ch[i])) continue;
                log.log(Level.FINE, "isWhiteSpace(): {0}", false);
                return false;
            }
            log.log(Level.FINE, "isWhiteSpace(): {0}", true);
            return true;
        }
        throw new IllegalStateException("Not in CHARACTERS state");
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        log.log(Level.FINE, "isAttributeSpecified({0})", index);
        if (this.event != 10 && this.event != 1) {
            throw new IllegalStateException("isAttributeSpecified called in another state!");
        }
        return this.elementIndex.currentElement.attributesSize() > index;
    }

    private int nextInElement() {
        if (this.elementIndex.index != null && this.elementIndex.currentElement.contentsSize() > this.elementIndex.index) {
            WbXmlContent content = this.elementIndex.currentElement.getContent(this.elementIndex.index);
            if (content.isString()) {
                this.event = 4;
            } else if (content.isPi()) {
                this.event = 3;
            } else {
                this.parents.push(this.elementIndex);
                this.elementIndex = new ElementIndex();
                this.elementIndex.currentElement = content.getElement();
                this.elementIndex.index = null;
                this.event = 1;
            }
        } else {
            this.event = 2;
        }
        return this.event;
    }

    @Override
    public int next() throws XMLStreamException {
        log.fine("next()");
        if (this.event == 7) {
            this.event = 1;
            this.elementIndex.currentElement = this.parser.getDocument().getBody().getElement();
        } else if (this.event == 1) {
            this.elementIndex.index = 0;
            this.event = this.nextInElement();
        } else if (this.event == 4) {
            ElementIndex elementIndex = this.elementIndex;
            Integer n = elementIndex.index;
            Integer n2 = elementIndex.index = Integer.valueOf(elementIndex.index + 1);
            this.event = this.nextInElement();
        } else if (this.event == 6) {
            ElementIndex elementIndex = this.elementIndex;
            Integer n = elementIndex.index;
            Integer n3 = elementIndex.index = Integer.valueOf(elementIndex.index + 1);
            this.event = this.nextInElement();
        } else if (this.event == 9) {
            ElementIndex elementIndex = this.elementIndex;
            Integer n = elementIndex.index;
            Integer n4 = elementIndex.index = Integer.valueOf(elementIndex.index + 1);
            this.event = this.nextInElement();
        } else if (this.event == 3) {
            ElementIndex elementIndex = this.elementIndex;
            Integer n = elementIndex.index;
            Integer n5 = elementIndex.index = Integer.valueOf(elementIndex.index + 1);
            this.event = this.nextInElement();
        } else if (this.event == 2) {
            if (this.parents.isEmpty()) {
                this.event = 8;
            } else {
                ElementIndex elementIndex = this.elementIndex = this.parents.pop();
                Integer n = elementIndex.index;
                Integer n6 = elementIndex.index = Integer.valueOf(elementIndex.index + 1);
                this.event = this.nextInElement();
            }
        } else {
            if (this.event == 8) {
                throw new XMLStreamException("End of document reached!");
            }
            throw new XMLStreamException("Invalid event state!");
        }
        log.log(Level.FINE, "next(): {0}", this.event);
        return this.event;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        log.log(Level.FINE, "getProperty({0})", name);
        if ("javax.xml.stream.isNamespaceAware".equals(name)) {
            return this.parser.getDefinition().getNamespaces().size() > 0;
        }
        return null;
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getElementText() throws XMLStreamException {
        log.log(Level.FINE, "getElementText()");
        if (this.getEventType() != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text");
        }
        int eventType = this.next();
        StringBuilder buf = new StringBuilder();
        while (eventType != 2) {
            if (eventType == 4 || eventType == 12 || eventType == 6 || eventType == 9) {
                buf.append(this.getText());
            } else if (eventType != 3 && eventType != 5 && eventType != 10) {
                if (eventType == 8) {
                    throw new XMLStreamException("unexpected end of document when reading element text content");
                }
                if (eventType == 1) {
                    throw new XMLStreamException("element text content may not contain START_ELEMENT");
                }
                throw new XMLStreamException("Unexpected event type " + eventType);
            }
            eventType = this.next();
        }
        log.log(Level.FINE, "getElementText(): {0}", buf.toString());
        return buf.toString();
    }

    @Override
    public int nextTag() throws XMLStreamException {
        log.log(Level.FINE, "nextTag()");
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException(String.format("expected start or end tag and found %d", eventType));
        }
        log.log(Level.FINE, "nextTag(): {0}", eventType);
        return eventType;
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        log.log(Level.FINE, "hasNext(): {0}", this.event != 8);
        return this.event != 8;
    }

    @Override
    public void close() throws XMLStreamException {
        this.parser = null;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        String namespaceURI = this.nsctx.getNamespaceURI(prefix);
        log.log(Level.FINE, "getNamespaceURI(): {0}", namespaceURI);
        return namespaceURI;
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        log.log(Level.FINE, "getAttributeValue({0}, {1})", new Object[]{namespaceURI, localName});
        if (this.event != 1 && this.event != 10) {
            throw new IllegalStateException("Not in START_ELEMENT or ATTRIBUTE");
        }
        if (namespaceURI != null && !namespaceURI.isEmpty()) {
            String prefix = this.parser.getDefinition().getPrefixWithLinked(namespaceURI);
            localName = prefix + ":" + localName;
        }
        WbXmlAttribute attr = this.elementIndex.currentElement.getAttribute(localName);
        String result = null;
        if (attr != null) {
            result = attr.getValue();
        }
        log.log(Level.FINE, "getAttributeValue(): {0}", result);
        return result;
    }

    @Override
    public int getAttributeCount() {
        log.log(Level.FINE, "getAttributeCount()");
        if (this.event != 1 && this.event != 10) {
            throw new IllegalStateException("Not in START_ELEMENT or ATTRIBUTE");
        }
        log.log(Level.FINE, "getAttributeCount(): {0}", this.elementIndex.currentElement.attributesSize());
        return this.elementIndex.currentElement.attributesSize();
    }

    @Override
    public QName getAttributeName(int i) {
        log.log(Level.FINE, "getAttributeName({0})", i);
        if (this.event != 1 && this.event != 10) {
            throw new IllegalStateException("Not in START_ELEMENT or ATTRIBUTE");
        }
        WbXmlAttribute attr = this.elementIndex.currentElement.getAttribute(i);
        QName result = null;
        if (attr != null) {
            if (attr.isPrefixed()) {
                String prefix = attr.getNamePrefix();
                String namespaceURI = this.parser.getDefinition().getNamespaceURIWithLinked(prefix);
                result = new QName(namespaceURI, attr.getNameWithoutPrefix(), prefix);
            } else {
                result = new QName(attr.getName());
            }
        }
        log.log(Level.FINE, "getAttributeName(): {0}", result);
        return result;
    }

    @Override
    public String getAttributeNamespace(int i) {
        log.log(Level.FINE, "getAttributeNamespace({0})", i);
        if (this.event != 1 && this.event != 10) {
            throw new IllegalStateException("Not in START_ELEMENT or ATTRIBUTE");
        }
        WbXmlAttribute attr = this.elementIndex.currentElement.getAttribute(i);
        String result = null;
        if (attr != null) {
            result = attr.isPrefixed() ? this.parser.getDefinition().getNamespaceURIWithLinked(attr.getNamePrefix()) : "";
        }
        log.log(Level.FINE, "getAttributeNamespace(): {0}", result);
        return result;
    }

    @Override
    public String getAttributeLocalName(int i) {
        log.log(Level.FINE, "getAttributeLocalName({0})", i);
        if (this.event != 1 && this.event != 10) {
            throw new IllegalStateException("Not in START_ELEMENT or ATTRIBUTE");
        }
        WbXmlAttribute attr = this.elementIndex.currentElement.getAttribute(i);
        String result = null;
        if (attr != null) {
            result = attr.getNameWithoutPrefix();
        }
        log.log(Level.FINE, "getAttributeLocalName(): {0}", result);
        return result;
    }

    @Override
    public String getAttributePrefix(int i) {
        log.log(Level.FINE, "getAttributePrefix({0})", i);
        if (this.event != 1 && this.event != 10) {
            throw new IllegalStateException("Not in START_ELEMENT or ATTRIBUTE");
        }
        WbXmlAttribute attr = this.elementIndex.currentElement.getAttribute(i);
        String result = null;
        if (attr != null) {
            result = attr.isPrefixed() ? attr.getNamePrefix() : "";
        }
        log.log(Level.FINE, "getAttributePrefix(): {0}", result);
        return result;
    }

    @Override
    public String getAttributeType(int i) {
        log.log(Level.FINE, "getAttributeType({0}): ", i);
        return "";
    }

    @Override
    public String getAttributeValue(int i) {
        log.log(Level.FINE, "getAttributeValue({0})", i);
        if (this.event != 1 && this.event != 10) {
            throw new IllegalStateException("Not in START_ELEMENT or ATTRIBUTE");
        }
        WbXmlAttribute attr = this.elementIndex.currentElement.getAttribute(i);
        String result = null;
        if (attr != null) {
            result = attr.getValue();
        }
        log.log(Level.FINE, "getAttributeValue(): {0}", result);
        return result;
    }

    @Override
    public int getNamespaceCount() {
        log.fine("getNamespaceCount()");
        int result = 0;
        log.log(Level.FINE, "getNamespaceCount(): {0}", result);
        return result;
    }

    @Override
    public String getNamespacePrefix(int i) {
        log.log(Level.FINE, "getNamespacePrefix({0})", i);
        String result = null;
        log.log(Level.FINE, "getNamespaceCount(): {0}", result);
        return result;
    }

    @Override
    public String getNamespaceURI(int i) {
        log.log(Level.FINE, "getNamespaceURI({0})", i);
        String result = null;
        log.log(Level.FINE, "getNamespaceCount(): {0}", result);
        return result;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        log.fine("getNamespaceContext()");
        return this.nsctx;
    }

    @Override
    public int getEventType() {
        return this.event;
    }

    @Override
    public String getText() {
        log.log(Level.FINE, "getText()");
        if (this.event != 4 && this.event != 6 && this.event != 9) {
            throw new IllegalStateException("Not in text event");
        }
        log.log(Level.FINE, "getText(): {0}", this.elementIndex.currentElement.getContent(this.elementIndex.index).getString());
        return this.elementIndex.currentElement.getContent(this.elementIndex.index).getString();
    }

    @Override
    public char[] getTextCharacters() {
        String result = this.getText();
        return result != null ? result.toCharArray() : new char[]{};
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        this.getText().getChars(sourceStart, sourceStart + length, target, targetStart);
        return length;
    }

    @Override
    public int getTextStart() {
        return 0;
    }

    @Override
    public int getTextLength() {
        return this.getText().length();
    }

    @Override
    public String getEncoding() {
        log.log(Level.FINE, "getEncoding()");
        return this.parser.getCharset().name();
    }

    @Override
    public boolean hasText() {
        log.log(Level.FINE, "hasText()");
        return this.event == 4 || this.event == 9;
    }

    @Override
    public Location getLocation() {
        log.log(Level.FINE, "getLocation()");
        return new Location(){

            @Override
            public int getCharacterOffset() {
                return 0;
            }

            @Override
            public int getColumnNumber() {
                return 0;
            }

            @Override
            public int getLineNumber() {
                return -1;
            }

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public String getSystemId() {
                return null;
            }
        };
    }

    @Override
    public QName getName() {
        QName qname;
        log.log(Level.FINE, "getName()");
        if (this.event == 1 || this.event == 2) {
            log.log(Level.FINE, "tag={0}", this.elementIndex.currentElement.getTag());
            if (this.elementIndex.currentElement.isPrefixed()) {
                String prefix = this.elementIndex.currentElement.getTagPrefix();
                String namespaceURI = this.parser.getDefinition().getNamespaceURIWithLinked(prefix);
                qname = new QName(namespaceURI, this.elementIndex.currentElement.getTagWithoutPrefix(), prefix);
            } else {
                qname = new QName(this.elementIndex.currentElement.getTag());
            }
        } else {
            throw new IllegalStateException("Not in START_ELEMENT, END_ELEMENT");
        }
        log.log(Level.FINE, "getName(): {0}", qname);
        return qname;
    }

    @Override
    public String getLocalName() {
        String localName;
        log.log(Level.FINE, "getLocalName()");
        if (this.event == 1 || this.event == 2) {
            localName = this.elementIndex.currentElement.getTagWithoutPrefix();
        } else if (this.event == 9) {
            localName = this.elementIndex.currentElement.getContent(this.elementIndex.index).getString();
        } else {
            throw new IllegalStateException("Not in START_ELEMENT, END_ELEMENT or ENTITY_REFERENCE");
        }
        log.log(Level.FINE, "getLocalName(): {0}", localName);
        return localName;
    }

    @Override
    public boolean hasName() {
        log.log(Level.FINE, "hasName(): {0}", this.event == 1 || this.event == 2);
        return this.event == 1 || this.event == 2;
    }

    @Override
    public String getNamespaceURI() {
        log.log(Level.FINE, "getNamespaceURI()");
        String namespace = "";
        if (this.event == 1 || this.event == 2) {
            if (this.elementIndex.currentElement.isPrefixed()) {
                String prefix = this.elementIndex.currentElement.getTagPrefix();
                namespace = this.parser.getDefinition().getNamespaceURIWithLinked(prefix);
            } else {
                namespace = "";
            }
        }
        log.log(Level.FINE, "getNamespaceURI(): {0}", namespace);
        return namespace;
    }

    @Override
    public String getPrefix() {
        log.log(Level.FINE, "getPrefix()");
        String prefix = null;
        if (this.event == 1 || this.event == 2) {
            prefix = this.elementIndex.currentElement.isPrefixed() ? this.elementIndex.currentElement.getTagPrefix() : "";
        }
        log.log(Level.FINE, "getPrefix(): {0}", prefix);
        return prefix;
    }

    @Override
    public String getVersion() {
        log.log(Level.FINE, "getVersion(): 1.0");
        return "1.0";
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public boolean standaloneSet() {
        return false;
    }

    @Override
    public String getCharacterEncodingScheme() {
        log.fine("getCharacterEncodingScheme()");
        return this.parser.getCharset().name();
    }

    @Override
    public String getPITarget() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getPIData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected static class ElementIndex {
        WbXmlElement currentElement;
        Integer index;

        public ElementIndex() {
        }

        public ElementIndex(ElementIndex el) {
            this.currentElement = el.currentElement;
            this.index = el.index;
        }

        public String toString() {
            return (this.currentElement == null ? "null" : this.currentElement.getTag()) + " " + this.index;
        }
    }
}

