/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.stream;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;

public class WbXmlNamespaceContext
implements NamespaceContext {
    protected static final Logger log = Logger.getLogger(WbXmlNamespaceContext.class.getName());
    private Map<String, String> prefixToNamespace = new HashMap<String, String>();
    private Map<String, Set<String>> namespaceToPrefix = new HashMap<String, Set<String>>();
    private String defaultNamespace = null;

    public WbXmlNamespaceContext() {
        this(null);
    }

    public WbXmlNamespaceContext(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public boolean isDefaultNamespaceDefined() {
        return this.defaultNamespace != null;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void addPrefix(String prefix, String namespaceURI) {
        log.log(Level.FINE, "addPrefix({0}, {1})", new Object[]{prefix, namespaceURI});
        if (prefix == null || namespaceURI == null) {
            throw new IllegalArgumentException("Prefix or namespaceURI cannot be null!");
        }
        this.prefixToNamespace.put(prefix, namespaceURI);
        Set<String> prefixes = this.namespaceToPrefix.get(namespaceURI);
        if (prefixes == null) {
            prefixes = new HashSet<String>();
        }
        prefixes.add(prefix);
        this.namespaceToPrefix.put(namespaceURI, prefixes);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        log.log(Level.FINE, "getNamespaceURI({0})", prefix);
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix cannot be null!");
        }
        if (prefix.equals("")) {
            if (this.defaultNamespace == null) {
                return "";
            }
            return this.defaultNamespace;
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        String namespace = this.prefixToNamespace.get(prefix);
        if (namespace != null) {
            return this.prefixToNamespace.get(prefix);
        }
        return "";
    }

    @Override
    public String getPrefix(String namespaceURI) {
        log.log(Level.FINE, "getPrefix({0})", namespaceURI);
        Iterator<String> i = this.getPrefixes(namespaceURI);
        if (i.hasNext()) {
            return i.next();
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        log.log(Level.FINE, "getPrefix({0})", namespaceURI);
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI cannot be null!");
        }
        if (namespaceURI.equals(this.defaultNamespace)) {
            return Arrays.asList("").iterator();
        }
        if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return Arrays.asList("xml").iterator();
        }
        if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            return Arrays.asList("xmlns").iterator();
        }
        Set<String> prefixes = this.namespaceToPrefix.get(namespaceURI);
        if (prefixes != null && !prefixes.isEmpty()) {
            return prefixes.iterator();
        }
        return new ArrayList().iterator();
    }

    public WbXmlNamespaceContext clone() {
        WbXmlNamespaceContext nsctx = new WbXmlNamespaceContext();
        nsctx.defaultNamespace = this.defaultNamespace;
        nsctx.namespaceToPrefix.putAll(this.namespaceToPrefix);
        nsctx.prefixToNamespace.putAll(this.prefixToNamespace);
        return nsctx;
    }
}

