/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.stream;

import es.rickyepoderi.wbxml.stream.StreamRestorePoint;
import es.rickyepoderi.wbxml.stream.WbXmlStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class WbXmlFilterStreamReader
implements XMLStreamReader {
    protected static final Logger log = Logger.getLogger(WbXmlStreamReader.class.getName());
    private WbXmlStreamReader reader;
    private StreamRestorePoint nextPosition;
    private StreamFilter filter;

    public WbXmlFilterStreamReader(WbXmlStreamReader reader, StreamFilter filter) throws XMLStreamException {
        this.reader = reader;
        this.filter = filter;
        this.calculateNextPosition();
    }

    private void calculateNextPosition() throws XMLStreamException {
        StreamRestorePoint currentPosition = this.reader.backup();
        log.log(Level.FINER, "current position: {0}", currentPosition);
        if (this.reader.hasNext()) {
            this.reader.next();
            while (this.reader.hasNext() && !this.filter.accept(this.reader)) {
                this.reader.next();
            }
            this.nextPosition = this.filter.accept(this.reader) ? this.reader.backup() : null;
        } else {
            this.nextPosition = null;
        }
        log.log(Level.FINER, "next position: {0}", this.nextPosition);
        this.reader.restore(currentPosition);
    }

    @Override
    public int next() throws XMLStreamException {
        if (this.nextPosition == null) {
            throw new XMLStreamException("End of document reached!");
        }
        this.reader.restore(this.nextPosition);
        this.calculateNextPosition();
        return this.reader.getEventType();
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.nextPosition != null;
    }

    @Override
    public String getElementText() throws XMLStreamException {
        String result = this.reader.getElementText();
        this.calculateNextPosition();
        return result;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int result = this.reader.nextTag();
        this.calculateNextPosition();
        return result;
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        return this.reader.getProperty(string);
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        this.reader.require(type, namespaceURI, localName);
    }

    @Override
    public void close() throws XMLStreamException {
        this.reader.close();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.reader.getNamespaceURI(prefix);
    }

    @Override
    public boolean isStartElement() {
        return this.reader.isStartElement();
    }

    @Override
    public boolean isEndElement() {
        return this.reader.isEndElement();
    }

    @Override
    public boolean isCharacters() {
        return this.reader.isCharacters();
    }

    @Override
    public boolean isWhiteSpace() {
        return this.reader.isWhiteSpace();
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        return this.reader.getAttributeValue(namespaceURI, localName);
    }

    @Override
    public int getAttributeCount() {
        return this.reader.getAttributeCount();
    }

    @Override
    public QName getAttributeName(int i) {
        return this.reader.getAttributeName(i);
    }

    @Override
    public String getAttributeNamespace(int i) {
        return this.reader.getAttributeNamespace(i);
    }

    @Override
    public String getAttributeLocalName(int i) {
        return this.reader.getAttributeLocalName(i);
    }

    @Override
    public String getAttributePrefix(int i) {
        return this.reader.getAttributePrefix(i);
    }

    @Override
    public String getAttributeType(int i) {
        return this.reader.getAttributeType(i);
    }

    @Override
    public String getAttributeValue(int i) {
        return this.reader.getAttributeValue(i);
    }

    @Override
    public boolean isAttributeSpecified(int i) {
        return this.reader.isAttributeSpecified(i);
    }

    @Override
    public int getNamespaceCount() {
        return this.reader.getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int i) {
        return this.reader.getNamespacePrefix(i);
    }

    @Override
    public String getNamespaceURI(int i) {
        return this.reader.getNamespaceURI(i);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.reader.getNamespaceContext();
    }

    @Override
    public int getEventType() {
        return this.reader.getEventType();
    }

    @Override
    public String getText() {
        return this.reader.getText();
    }

    @Override
    public char[] getTextCharacters() {
        return this.reader.getTextCharacters();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        return this.reader.getTextCharacters(sourceStart, target, targetStart, length);
    }

    @Override
    public int getTextStart() {
        return this.reader.getTextStart();
    }

    @Override
    public int getTextLength() {
        return this.reader.getTextLength();
    }

    @Override
    public String getEncoding() {
        return this.reader.getEncoding();
    }

    @Override
    public boolean hasText() {
        return this.reader.hasText();
    }

    @Override
    public Location getLocation() {
        return this.reader.getLocation();
    }

    @Override
    public QName getName() {
        return this.reader.getName();
    }

    @Override
    public String getLocalName() {
        return this.reader.getLocalName();
    }

    @Override
    public boolean hasName() {
        return this.reader.hasName();
    }

    @Override
    public String getNamespaceURI() {
        return this.reader.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.reader.getPrefix();
    }

    @Override
    public String getVersion() {
        return this.reader.getVersion();
    }

    @Override
    public boolean isStandalone() {
        return this.reader.isStandalone();
    }

    @Override
    public boolean standaloneSet() {
        return this.reader.standaloneSet();
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.reader.getCharacterEncodingScheme();
    }

    @Override
    public String getPITarget() {
        return this.reader.getPITarget();
    }

    @Override
    public String getPIData() {
        return this.reader.getPIData();
    }
}

