/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.stream;

import es.rickyepoderi.wbxml.definition.WbXmlDefinition;
import es.rickyepoderi.wbxml.document.WbXmlParser;
import es.rickyepoderi.wbxml.stream.StreamRestorePoint;
import es.rickyepoderi.wbxml.stream.WbXmlStreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;

public class WbXmlEventReader
implements XMLEventReader {
    protected static final Logger log = Logger.getLogger(WbXmlEventReader.class.getName());
    private WbXmlStreamReader stream = null;
    private XMLEvent currentEvent = null;
    private StreamRestorePoint backup;
    private XMLEvent nextEvent = null;
    private EventFilter filter = null;
    private XMLEventAllocator allocator = null;

    public WbXmlEventReader(WbXmlStreamReader stream, XMLEventAllocator allocator) throws XMLStreamException {
        this.stream = stream;
        this.allocator = allocator;
        this.currentEvent = null;
        this.nextEvent = this.constructEvent(stream);
        this.advanceNextEvent();
    }

    public WbXmlEventReader(WbXmlParser parser, XMLEventAllocator allocator) throws XMLStreamException {
        this.stream = new WbXmlStreamReader(parser);
        this.allocator = allocator;
        this.currentEvent = null;
        this.nextEvent = this.constructEvent(this.stream);
        this.advanceNextEvent();
    }

    public WbXmlEventReader(InputStream is, XMLEventAllocator allocator) throws IOException, XMLStreamException {
        this(is, null, allocator);
    }

    public WbXmlEventReader(InputStream is, WbXmlDefinition definition, XMLEventAllocator allocator) throws IOException, XMLStreamException {
        this(new WbXmlStreamReader(is, definition), allocator);
    }

    public void assignFilter(EventFilter filter) throws XMLStreamException {
        this.filter = filter;
        this.advanceNextEvent();
    }

    public WbXmlParser getParser() {
        return this.stream.getParser();
    }

    private XMLEvent constructEvent(WbXmlStreamReader stream) throws XMLStreamException {
        log.log(Level.FINE, "constructEvent()");
        XMLEvent event = this.allocator.allocate(stream);
        log.log(Level.FINE, "constructEvent(): {0} {1}", new Object[]{event.getEventType(), event});
        return event;
    }

    private void advanceNextEvent() throws XMLStreamException {
        if (this.filter != null) {
            this.backup = this.stream.backup();
            XMLEvent curr = this.currentEvent;
            while (this.nextEvent != null && !this.filter.accept(this.nextEvent)) {
                this.internalNextEvent();
            }
            this.currentEvent = curr;
        }
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        log.log(Level.FINE, "nextEvent()");
        this.internalNextEvent();
        this.advanceNextEvent();
        log.log(Level.FINE, "nextEvent(): {0}", this.currentEvent);
        return this.currentEvent;
    }

    protected XMLEvent internalNextEvent() throws XMLStreamException {
        log.log(Level.FINE, "internalNextEvent()");
        if (this.nextEvent == null) {
            throw new NoSuchElementException();
        }
        this.currentEvent = this.nextEvent;
        if (this.currentEvent.getEventType() != 8) {
            this.stream.next();
            this.nextEvent = this.constructEvent(this.stream);
        } else {
            this.nextEvent = null;
        }
        log.log(Level.FINE, "internalNextEvent(): {0}", this.currentEvent);
        return this.currentEvent;
    }

    @Override
    public boolean hasNext() {
        log.log(Level.FINE, "hasNext()");
        boolean result = this.nextEvent != null;
        log.log(Level.FINE, "hasNext(): {0}", result);
        return result;
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        log.log(Level.FINE, "peek(): {0}", this.nextEvent);
        return this.nextEvent;
    }

    @Override
    public String getElementText() throws XMLStreamException {
        log.log(Level.FINE, "getElementText()");
        if (!(this.currentEvent instanceof StartElement)) {
            throw new XMLStreamException("Not in a START_ELEMENT!");
        }
        if (this.filter != null && this.backup != null) {
            this.stream.restore(this.backup);
            this.nextEvent = this.constructEvent(this.stream);
        }
        StringBuilder sb = new StringBuilder();
        XMLEvent event = this.internalNextEvent();
        while (!(event instanceof EndElement)) {
            if (event instanceof Characters) {
                Characters chars = (Characters)event;
                sb.append(chars.getData());
            } else if (event instanceof StartElement) {
                throw new XMLStreamException("Another START_ELEMENT found while iterating!");
            }
            event = this.internalNextEvent();
        }
        this.advanceNextEvent();
        log.log(Level.FINE, "getElementText(): {0}", sb.toString());
        return sb.toString();
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        log.log(Level.FINE, "nextTag()");
        if (this.filter != null && this.backup != null) {
            this.stream.restore(this.backup);
            this.nextEvent = this.constructEvent(this.stream);
        }
        XMLEvent event = this.internalNextEvent();
        while (!(event instanceof EndElement) && !(event instanceof StartElement)) {
            Characters chars;
            if (event instanceof Characters && !(chars = (Characters)event).isIgnorableWhiteSpace()) {
                throw new XMLStreamException("Non-ignorable CHARACTERS found!");
            }
            event = this.internalNextEvent();
        }
        this.advanceNextEvent();
        log.log(Level.FINE, "nextTag(): {0}", event);
        return event;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        log.log(Level.FINE, "getProperty()");
        return this.stream.getProperty(name);
    }

    @Override
    public void close() throws XMLStreamException {
        log.log(Level.FINE, "close()");
        this.stream.close();
    }

    @Override
    public Object next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("The WbXmlEventReader is not modifiable!");
    }
}

