/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.document.opaque;

import es.rickyepoderi.wbxml.document.OpaqueContentPlugin;
import es.rickyepoderi.wbxml.document.WbXmlContent;
import es.rickyepoderi.wbxml.document.WbXmlElement;
import es.rickyepoderi.wbxml.document.WbXmlEncoder;
import es.rickyepoderi.wbxml.document.WbXmlParser;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WMLVariableContentOpaque
implements OpaqueContentPlugin {
    private static Pattern varPattern = Pattern.compile("(\\$[\\(]?)([_a-zA-Z][_a-zA-Z0-9]*)(:(([eE][sS][cC][aA][pP][eE]|[eE]|[nN][oO][eE][sS][cC]|[nN]|[uU][nN][eE][sS][cC]|[uU])))?([\\)]?)");

    public static void writeToken(WbXmlEncoder encoder, Matcher matcher) throws IOException {
        String var = matcher.group(2);
        String type = matcher.group(3);
        if (":e".equalsIgnoreCase(type) || ":escape".equalsIgnoreCase(type)) {
            encoder.writeExtension((byte)0, var);
        } else if (":u".equalsIgnoreCase(type) || ":unesc".equalsIgnoreCase(type)) {
            encoder.writeExtension((byte)1, var);
        } else {
            encoder.writeExtension((byte)2, var);
        }
    }

    public static void encode(WbXmlEncoder encoder, String value) throws IOException {
        Matcher matcher = varPattern.matcher(value);
        int pos = 0;
        while (matcher.find()) {
            if (matcher.start() > pos) {
                encoder.writeString(value.substring(pos, matcher.start()));
            }
            WMLVariableContentOpaque.writeToken(encoder, matcher);
            pos = matcher.end();
        }
        if (pos < value.length()) {
            encoder.writeString(value.substring(pos));
        }
    }

    @Override
    public void encode(WbXmlEncoder encoder, WbXmlElement element, WbXmlContent content) throws IOException {
        if (content.isString()) {
            WMLVariableContentOpaque.encode(encoder, content.getString());
        } else {
            encoder.encode(content);
        }
    }

    @Override
    public WbXmlContent parse(WbXmlParser parser, byte[] data) throws IOException {
        throw new IllegalStateException("It should not be called.");
    }
}

