/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.document;

import es.rickyepoderi.wbxml.document.WbXmlLiterals;

public enum WbXmlVersion {
    VERSION_1_0(1, 0),
    VERSION_1_1(1, 1),
    VERSION_1_2(1, 2),
    VERSION_1_3(1, 3);

    private byte major;
    private byte minor;

    private WbXmlVersion(byte major, byte minor) {
        this.major = major;
        this.minor = minor;
    }

    public byte getMajor() {
        return this.major;
    }

    public byte getMinor() {
        return this.minor;
    }

    public boolean lessThan(WbXmlVersion other) {
        return this.compareTo(other) < 0;
    }

    public boolean greaterThan(WbXmlVersion other) {
        return this.compareTo(other) > 0;
    }

    public String getVersion() {
        return "" + this.major + '.' + this.minor;
    }

    public static WbXmlVersion locateVersion(String version) {
        for (WbXmlVersion v : WbXmlVersion.values()) {
            if (!v.getVersion().equals(version)) continue;
            return v;
        }
        return null;
    }

    public static WbXmlVersion locateVersion(byte major, byte minor) {
        for (WbXmlVersion v : WbXmlVersion.values()) {
            if (v.getMajor() != major || v.getMinor() != minor) continue;
            return v;
        }
        return null;
    }

    public String toString(int ident) {
        return WbXmlLiterals.identString(ident) + "version: " + this.major + "." + this.minor;
    }

    public String toString() {
        return this.toString(0);
    }
}

