/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.document;

import com.sun.org.apache.xerces.internal.util.XMLChar;
import es.rickyepoderi.wbxml.definition.IanaCharset;
import es.rickyepoderi.wbxml.definition.WbXmlAttributeDef;
import es.rickyepoderi.wbxml.definition.WbXmlAttributeValueDef;
import es.rickyepoderi.wbxml.definition.WbXmlDefinition;
import es.rickyepoderi.wbxml.definition.WbXmlInitialization;
import es.rickyepoderi.wbxml.definition.WbXmlTagDef;
import es.rickyepoderi.wbxml.definition.WbXmlToken;
import es.rickyepoderi.wbxml.document.ExtensionIPlugin;
import es.rickyepoderi.wbxml.document.ExtensionPlugin;
import es.rickyepoderi.wbxml.document.ExtensionTPlugin;
import es.rickyepoderi.wbxml.document.OpaqueAttributePlugin;
import es.rickyepoderi.wbxml.document.OpaqueContentPlugin;
import es.rickyepoderi.wbxml.document.WbXmlAttribute;
import es.rickyepoderi.wbxml.document.WbXmlBody;
import es.rickyepoderi.wbxml.document.WbXmlContent;
import es.rickyepoderi.wbxml.document.WbXmlDocument;
import es.rickyepoderi.wbxml.document.WbXmlElement;
import es.rickyepoderi.wbxml.document.WbXmlStrtbl;
import es.rickyepoderi.wbxml.document.WbXmlVersion;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class WbXmlParser {
    private InputStream is;
    private WbXmlDocument doc;
    private byte pageAttrState;
    private byte pageTagState;
    private Byte currentByte;
    private Byte nextByte;

    public WbXmlParser(InputStream is) {
        this.is = is;
        this.pageAttrState = 0;
        this.pageTagState = 0;
        this.doc = null;
        this.currentByte = null;
        this.nextByte = null;
    }

    public boolean read() throws IOException {
        if (this.nextByte != null) {
            this.currentByte = this.nextByte;
            this.nextByte = null;
        } else {
            int i = this.is.read();
            this.currentByte = i < 0 ? null : Byte.valueOf((byte)i);
        }
        return this.currentByte != null;
    }

    public void readBackwards() throws IOException {
        if (this.currentByte == null) {
            throw new IOException("Only one readBackwards is permitted!");
        }
        this.nextByte = this.currentByte;
        this.currentByte = null;
    }

    public byte[] read(byte[] b) throws IOException {
        int i;
        if (b.length == 0) {
            return b;
        }
        int offset = 0;
        if (this.nextByte != null) {
            b[0] = this.nextByte;
            this.nextByte = null;
            offset = 1;
        }
        if ((i = this.is.read(b, offset, b.length - offset)) + offset < b.length) {
            throw new IOException(String.format("End of file reading a byte[] of size %d", b.length));
        }
        this.currentByte = b[b.length - 1];
        return b;
    }

    public long readUnsignedInteger() throws IOException {
        long res = 0L;
        this.read();
        int times = 1;
        res = res << 7 | (long)(this.currentByte & 0x7F);
        while ((this.currentByte & 0x80) != 0) {
            if (times > 5) {
                throw new IOException("An unsigned integer should not be longer than 5 bytes!");
            }
            this.read();
            ++times;
            res = res << 7 | (long)(this.currentByte & 0x7F);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readInlineString() throws IOException {
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            this.read();
            while (this.currentByte != 0) {
                bos.write(this.currentByte.byteValue());
                this.read();
            }
            String string = new String(bos.toByteArray(), this.doc.getCharset().getCharset());
            return string;
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void readSwitchPageAttribute() throws IOException {
        if (0 == this.currentByte) {
            if (this.doc.getVersion().lessThan(WbXmlVersion.VERSION_1_2)) {
                throw new IOException(String.format("Version %s cannot manage switch page (attribute)", this.doc.getVersion().getVersion()));
            }
            this.read();
            this.pageAttrState = this.currentByte;
            this.read();
        }
    }

    public void readSwitchPageTag() throws IOException {
        if (0 == this.currentByte) {
            if (this.doc.getVersion().lessThan(WbXmlVersion.VERSION_1_2)) {
                throw new IOException(String.format("Version %s cannot manage switch page (tag)", this.doc.getVersion().getVersion()));
            }
            this.read();
            this.pageTagState = this.currentByte;
            this.read();
        }
    }

    public WbXmlVersion parseVersion() throws IOException {
        this.read();
        byte major = (byte)((this.currentByte >> 4) + 1);
        byte minor = (byte)(this.currentByte & 0xF);
        WbXmlVersion v = WbXmlVersion.locateVersion(major, minor);
        if (v == null) {
            throw new IOException(String.format("Invalid version (%d,%d)", major, minor));
        }
        return v;
    }

    public long parsePublicId() throws IOException {
        long publicId = this.readUnsignedInteger();
        if (publicId == 0L) {
            publicId = this.readUnsignedInteger();
        } else if (publicId != 1L) {
            this.doc.setDefinition(WbXmlInitialization.getDefinitionByPublicId(publicId));
            if (this.doc.getDefinition() == null) {
                throw new IOException(String.format("Unknown definition public id (%d)", publicId));
            }
        } else {
            publicId = -1L;
        }
        return publicId;
    }

    public IanaCharset parseCharset() throws IOException {
        long mib = IanaCharset.UNKNOWN.getMibEnum();
        if (this.doc.getVersion().greaterThan(WbXmlVersion.VERSION_1_0)) {
            mib = this.readUnsignedInteger();
        }
        IanaCharset iana = IanaCharset.getIanaCharset(mib);
        if (mib != 0L && iana.equals((Object)IanaCharset.UNKNOWN)) {
            throw new IOException(String.format("Unknown character encoding '%d'", mib));
        }
        this.doc.setCharset(iana);
        return iana;
    }

    public WbXmlStrtbl parseStrtbl() throws IOException {
        WbXmlStrtbl strtbl = new WbXmlStrtbl();
        long length = this.readUnsignedInteger();
        strtbl.setSize(length);
        byte[] b = new byte[(int)length];
        this.read(b);
        int idx = 0;
        for (int i = 0; i < b.length; ++i) {
            if (b[i] != 0) continue;
            String s = new String(b, idx, i - idx, this.doc.getCharset().getCharset());
            strtbl.internalAddString(idx, s);
            idx = i + 1;
        }
        this.doc.setStrtbl(strtbl);
        return strtbl;
    }

    public WbXmlContent parseOpaqueTag(String tagName) throws IOException {
        if (this.doc.getVersion().lessThan(WbXmlVersion.VERSION_1_1)) {
            throw new IOException(String.format("Version %s cannot manage opaques for content", this.doc.getVersion().getVersion()));
        }
        OpaqueContentPlugin plugin = this.doc.getDefinition().locateTagPlugin(tagName);
        if (plugin == null) {
            throw new IOException(String.format("No plugin defined for tag (%s)", tagName));
        }
        this.read();
        if (-61 != this.currentByte) {
            throw new IOException("Opaque must start with OPAQUE tag!");
        }
        long length = this.readUnsignedInteger();
        byte[] b = new byte[(int)length];
        this.read(b);
        return plugin.parse(this, b);
    }

    public String parseOpaqueAttr(String attrName) throws IOException {
        if (this.doc.getVersion().lessThan(WbXmlVersion.VERSION_1_2)) {
            throw new IOException(String.format("Version %s cannot manage opaques for content", this.doc.getVersion().getVersion()));
        }
        OpaqueAttributePlugin plugin = this.doc.getDefinition().locateAttrPlugin(attrName);
        if (plugin == null) {
            throw new IOException(String.format("No plugin defined for attr (%s)", attrName));
        }
        this.read();
        if (-61 != this.currentByte) {
            throw new IOException("Opaque must start with OPAQUE tag!");
        }
        long length = this.readUnsignedInteger();
        byte[] b = new byte[(int)length];
        this.read(b);
        return plugin.parse(this, b);
    }

    public String parseEntity() throws IOException {
        this.read();
        if (2 != this.currentByte) {
            throw new IOException("Entity must start with the ENTITY tag!");
        }
        int entity = (int)this.readUnsignedInteger();
        StringBuilder buf = new StringBuilder();
        if (!XMLChar.isSupplemental(entity)) {
            buf.append((char)entity);
        } else {
            buf.append(XMLChar.highSurrogate(entity));
            buf.append(XMLChar.lowSurrogate(entity));
        }
        return buf.toString();
    }

    public String parseAttributeExtension(String attrName, byte ext) throws IOException {
        ExtensionPlugin plugin = this.doc.getDefinition().getExtension();
        if (plugin == null) {
            throw new IOException("EXT_X token found and no plugin associated");
        }
        return plugin.parseAttribute(this, attrName, ext);
    }

    public String parseAttributeIExtension(String attrName, byte ext, String value) throws IOException {
        ExtensionIPlugin plugin = this.doc.getDefinition().getExtensionI();
        if (plugin == null) {
            throw new IOException("EXT_I_X token found and no plugin associated");
        }
        return plugin.parseAttribute(this, attrName, ext, value);
    }

    public String parseAttributeTExtension(String attrName, byte ext, long value) throws IOException {
        ExtensionTPlugin plugin = this.doc.getDefinition().getExtensionT();
        if (plugin == null) {
            throw new IOException("EXT_T_X token found and no plugin associated");
        }
        return plugin.parseAttribute(this, attrName, ext, value);
    }

    public List<String> parseAttributeValues(String attrName) throws IOException {
        ArrayList<String> values = new ArrayList<String>();
        this.read();
        boolean cont = true;
        while (cont) {
            this.readSwitchPageAttribute();
            if (3 == this.currentByte) {
                values.add(this.readInlineString());
            } else if (-125 == this.currentByte) {
                long idx = this.readUnsignedInteger();
                values.add(this.doc.getStrtbl().getString(idx));
            } else if (64 == this.currentByte || 65 == this.currentByte || 66 == this.currentByte) {
                byte ext = this.currentByte;
                values.add(this.parseAttributeIExtension(attrName, ext, this.readInlineString()));
            } else if (-128 == this.currentByte || -127 == this.currentByte || -126 == this.currentByte) {
                byte ext = this.currentByte;
                long idx = this.readUnsignedInteger();
                values.add(this.parseAttributeTExtension(attrName, ext, idx));
            } else if (-64 == this.currentByte || -63 == this.currentByte || -62 == this.currentByte) {
                values.add(this.parseAttributeExtension(attrName, this.currentByte));
            } else if (2 == this.currentByte) {
                this.readBackwards();
                values.add(this.parseEntity());
            } else if (-61 == this.currentByte) {
                this.readBackwards();
                String v = this.parseOpaqueAttr(attrName);
                if (v != null && !v.isEmpty()) {
                    values.add(v);
                }
            } else if ((this.currentByte & 0x80) != 0) {
                WbXmlAttributeValueDef attrValDef = this.doc.getDefinition().locateAttributeValue(this.pageAttrState, this.currentByte);
                if (attrValDef == null) {
                    throw new IOException(String.format("Unknown ATTRVALUE in the definition (%s)", new WbXmlToken(this.pageAttrState, this.currentByte)));
                }
                values.add(attrValDef.getValue());
            } else {
                cont = false;
            }
            if (!cont) continue;
            this.read();
        }
        return values;
    }

    public WbXmlAttribute parseAttribute() throws IOException {
        WbXmlAttribute attr = new WbXmlAttribute();
        this.read();
        this.readSwitchPageAttribute();
        if (4 == this.currentByte) {
            long idx = this.readUnsignedInteger();
            attr.setName(this.doc.getStrtbl().getString(idx));
        } else {
            WbXmlAttributeDef attrDef = this.doc.getDefinition().locateAttribute(this.pageAttrState, this.currentByte);
            if (attrDef == null) {
                throw new IOException(String.format("Unknown ATTRSTART in the definition (%s)", new WbXmlToken(this.pageAttrState, this.currentByte)));
            }
            attr.setName(attrDef.getNameWithPrefix());
            if (attrDef.getValue() != null) {
                attr.addValue(attrDef.getValue());
            }
        }
        attr.addValues(this.parseAttributeValues(attr.getName()));
        attr.normalize();
        return attr;
    }

    public WbXmlContent parseContentExtension(String tagName, byte ext) throws IOException {
        ExtensionPlugin plugin = this.doc.getDefinition().getExtension();
        if (plugin == null) {
            throw new IOException("EXT_X token found and no plugin associated");
        }
        return plugin.parseContent(this, tagName, ext);
    }

    public WbXmlContent parseContentIExtension(String tagName, byte ext, String value) throws IOException {
        ExtensionIPlugin plugin = this.doc.getDefinition().getExtensionI();
        if (plugin == null) {
            throw new IOException("EXT_I_X token found and no plugin associated");
        }
        return plugin.parseContent(this, tagName, ext, value);
    }

    public WbXmlContent parseContentTExtension(String tagName, byte ext, long value) throws IOException {
        ExtensionTPlugin plugin = this.doc.getDefinition().getExtensionT();
        if (plugin == null) {
            throw new IOException("EXT_T_X token found and no plugin associated");
        }
        return plugin.parseContent(this, tagName, ext, value);
    }

    public WbXmlContent parseContent(String tagName) throws IOException {
        WbXmlContent content = new WbXmlContent();
        this.read();
        this.readSwitchPageTag();
        if (3 == this.currentByte) {
            content.setString(this.readInlineString());
        } else if (-125 == this.currentByte) {
            long idx = this.readUnsignedInteger();
            content.setString(this.doc.getStrtbl().getString(idx));
        } else if (64 == this.currentByte || 65 == this.currentByte || 66 == this.currentByte) {
            byte ext = this.currentByte;
            content = this.parseContentIExtension(tagName, ext, this.readInlineString());
        } else if (-128 == this.currentByte || -127 == this.currentByte || -126 == this.currentByte) {
            byte ext = this.currentByte;
            long idx = this.readUnsignedInteger();
            content = this.parseContentTExtension(tagName, ext, idx);
        } else if (-64 == this.currentByte || -63 == this.currentByte || -62 == this.currentByte) {
            content = this.parseContentExtension(tagName, this.currentByte);
        } else if (2 == this.currentByte) {
            this.readBackwards();
            content.setString(this.parseEntity());
        } else if (-61 == this.currentByte) {
            this.readBackwards();
            content = this.parseOpaqueTag(tagName);
        } else if (67 == this.currentByte) {
            this.readBackwards();
            content.setPi(this.parsePi());
        } else if (1 != this.currentByte) {
            this.readBackwards();
            content.setElement(this.parseElement());
        }
        this.read();
        if (content.isEmpty()) {
            content = null;
        }
        return content;
    }

    public WbXmlElement parseElement() throws IOException {
        boolean hasContent;
        boolean hasAttributes;
        WbXmlElement element = new WbXmlElement();
        this.read();
        this.readSwitchPageTag();
        if (4 == this.currentByte || -124 == this.currentByte || 68 == this.currentByte || -60 == this.currentByte) {
            hasAttributes = -124 == this.currentByte || -60 == this.currentByte;
            hasContent = 68 == this.currentByte || -60 == this.currentByte;
            long idx = this.readUnsignedInteger();
            String name = this.doc.getStrtbl().getString(idx);
            element.setTag(name);
        } else {
            WbXmlTagDef tagDef = this.doc.getDefinition().locateTag(this.pageTagState, (byte)(this.currentByte & 0x3F));
            if (tagDef == null) {
                throw new IOException(String.format("Unknown TAG in the definition (%s)", new WbXmlToken(this.pageTagState, this.currentByte)));
            }
            element.setTag(tagDef.getNameWithPrefix());
            hasAttributes = (this.currentByte & 0x80) != 0;
            boolean bl = hasContent = (this.currentByte & 0x40) != 0;
        }
        if (hasAttributes) {
            boolean cont = true;
            while (cont) {
                element.addAttribute(this.parseAttribute());
                if (1 == this.currentByte) {
                    cont = false;
                    continue;
                }
                this.readBackwards();
            }
        }
        if (hasContent) {
            boolean cont = true;
            while (cont) {
                WbXmlContent content = this.parseContent(element.getTag());
                if (content != null) {
                    element.addContent(content);
                }
                if (this.currentByte == null || 1 == this.currentByte) {
                    cont = false;
                    continue;
                }
                this.readBackwards();
            }
        }
        element.normalize();
        return element;
    }

    public WbXmlAttribute parsePi() throws IOException {
        this.read();
        if (67 != this.currentByte) {
            throw new IOException("PI must start with PI tag!");
        }
        WbXmlAttribute attr = this.parseAttribute();
        this.read();
        if (1 != this.currentByte) {
            throw new IOException("PI must end with END tag!");
        }
        return attr;
    }

    public WbXmlBody parseBody() throws IOException {
        WbXmlBody body = new WbXmlBody();
        this.read();
        while (67 == this.currentByte) {
            this.readBackwards();
            body.addPrePi(this.parsePi());
            this.read();
        }
        this.readBackwards();
        body.setElement(this.parseElement());
        this.read();
        while (this.currentByte != null && 67 == this.currentByte) {
            this.readBackwards();
            body.addPostPi(this.parsePi());
            this.read();
        }
        return body;
    }

    public WbXmlDocument parse(WbXmlDefinition def) throws IOException {
        this.doc = new WbXmlDocument();
        this.doc.setVersion(this.parseVersion());
        long publicId = this.parsePublicId();
        if (def != null) {
            this.doc.setDefinition(def);
        }
        this.parseCharset();
        this.parseStrtbl();
        if (this.doc.getDefinition() == null && publicId != -1L) {
            String fpi = this.doc.getStrtbl().getString(publicId);
            this.doc.setDefinition(WbXmlInitialization.getDefinitionByFPI(fpi));
            if (this.doc.getDefinition() == null) {
                throw new IOException(String.format("Unknown definition formal public id (%s)", fpi));
            }
        } else if (this.doc.getDefinition() == null) {
            throw new IOException("Unknown definition and no one specified");
        }
        this.doc.setBody(this.parseBody());
        return this.doc;
    }

    public WbXmlDocument parse() throws IOException {
        return this.parse(null);
    }

    public WbXmlDocument getDocument() {
        return this.doc;
    }

    public Charset getCharset() {
        return this.doc.getCharset().getCharset();
    }

    public WbXmlDefinition getDefinition() {
        return this.doc.getDefinition();
    }
}

