/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.document;

import es.rickyepoderi.wbxml.definition.IanaCharset;
import es.rickyepoderi.wbxml.definition.WbXmlAttributeDef;
import es.rickyepoderi.wbxml.definition.WbXmlAttributeValueDef;
import es.rickyepoderi.wbxml.definition.WbXmlDefinition;
import es.rickyepoderi.wbxml.definition.WbXmlExtensionDef;
import es.rickyepoderi.wbxml.definition.WbXmlTagDef;
import es.rickyepoderi.wbxml.document.OpaqueAttributePlugin;
import es.rickyepoderi.wbxml.document.OpaqueContentPlugin;
import es.rickyepoderi.wbxml.document.WbXmlAttribute;
import es.rickyepoderi.wbxml.document.WbXmlBody;
import es.rickyepoderi.wbxml.document.WbXmlContent;
import es.rickyepoderi.wbxml.document.WbXmlDocument;
import es.rickyepoderi.wbxml.document.WbXmlElement;
import es.rickyepoderi.wbxml.document.WbXmlLiterals;
import es.rickyepoderi.wbxml.document.WbXmlStrtbl;
import es.rickyepoderi.wbxml.document.WbXmlVersion;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WbXmlEncoder {
    private static final Logger log = Logger.getLogger(WbXmlEncoder.class.getName());
    private static final int BYTE_ARRAY_INITIAL_LENGTH = 1024;
    private static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    private OutputStream os;
    private OutputStream realOs;
    private byte pageAttrState = 0;
    private byte pageTagState = 0;
    private WbXmlDocument doc;
    private StrtblType type;
    private boolean strtblUsed;

    public WbXmlEncoder(OutputStream os, WbXmlDocument doc) {
        this(os, doc, StrtblType.IF_NEEDED);
    }

    public WbXmlEncoder(OutputStream os, WbXmlDocument doc, StrtblType type) {
        this.type = type;
        this.strtblUsed = false;
        this.realOs = os;
        this.os = os;
        this.doc = doc;
    }

    protected Charset getCharset() {
        return this.doc.getCharset().getCharset();
    }

    public StrtblType getType() {
        return this.type;
    }

    public IanaCharset getIanaCharset() {
        return this.doc.getCharset();
    }

    public WbXmlStrtbl getStrtbl() {
        return this.doc.getStrtbl();
    }

    public WbXmlDefinition getDefinition() {
        return this.doc.getDefinition();
    }

    protected boolean isStrtblUsed() {
        return this.strtblUsed;
    }

    protected void setStrtblUsed() {
        this.strtblUsed = true;
    }

    public void reset() {
        this.pageAttrState = 0;
        this.pageTagState = 0;
        this.strtblUsed = false;
    }

    public void write(byte b) throws IOException {
        this.write(new byte[]{b});
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int start, int length) throws IOException {
        this.os.write(b, start, length);
    }

    public void writeUnsignedInteger(long value) throws IOException {
        int i;
        if (value > 0xFFFFFFFFL) {
            throw new IOException("Maximun unsigned integer value reached");
        }
        byte[] octets = new byte[5];
        octets[4] = (byte)(value & 0x7FL);
        value >>= 7;
        for (i = 3; value > 0L && i >= 0; value >>= 7, --i) {
            octets[i] = (byte)(0x80L | value & 0x7FL);
        }
        int start = i + 1;
        this.write(octets, start, 5 - start);
    }

    public void writeSwitchPageAttribute(byte page) throws IOException {
        if (this.pageAttrState != page) {
            if (this.doc.getVersion().lessThan(WbXmlVersion.VERSION_1_2)) {
                throw new IOException(String.format("Version %s cannot manage switch page (attribute)", this.doc.getVersion().getVersion()));
            }
            this.pageAttrState = page;
            this.write((byte)0);
            this.write(this.pageAttrState);
        }
    }

    public void writeSwitchPageTag(byte page) throws IOException {
        if (this.pageTagState != page) {
            if (this.doc.getVersion().lessThan(WbXmlVersion.VERSION_1_2)) {
                throw new IOException(String.format("Version %s cannot manage switch page (tag)", this.doc.getVersion().getVersion()));
            }
            this.pageTagState = page;
            this.write((byte)0);
            this.write(this.pageTagState);
        }
    }

    public void writeString(String s) throws IOException {
        if (StrtblType.ALWAYS.equals((Object)this.type)) {
            this.writeReferenceString(s);
        } else {
            this.writeInlineString(s);
        }
    }

    public void writeExtension(byte ext, String s) throws IOException {
        if (ext != 0 && ext != 1 && ext != 2) {
            throw new IllegalArgumentException("Invalid extension to write, should be 0, 1 or 2.");
        }
        if (StrtblType.ALWAYS.equals((Object)this.type)) {
            long idx = this.doc.getStrtbl().addString(this, s);
            this.write((byte)(0xFFFFFF80 | ext));
            this.writeUnsignedInteger(idx);
        } else {
            this.write((byte)(0x40 | ext));
            this.writeTableString(s);
        }
    }

    public void writeInlineString(String s) throws IOException {
        this.write((byte)3);
        this.writeTableString(s);
    }

    public void writeReferenceString(String s) throws IOException {
        long idx = this.doc.getStrtbl().addString(this, s);
        this.write((byte)-125);
        this.writeUnsignedInteger(idx);
    }

    public void writeTableString(String s) throws IOException {
        this.write(s.getBytes(this.getCharset()));
        this.write((byte)0);
    }

    public void writeOpaque(byte[] data) throws IOException {
        this.write((byte)-61);
        this.writeUnsignedInteger(data.length);
        this.write(data);
    }

    public static byte processTag(byte tag, boolean hasAttributes, boolean hasContent) {
        if (hasAttributes) {
            tag = (byte)(tag | 0xFFFFFF80);
        }
        if (hasContent) {
            tag = (byte)(tag | 0x40);
        }
        return tag;
    }

    public static byte processLiteralTag(boolean hasAttributes, boolean hasContent) {
        if (hasAttributes && hasContent) {
            return -60;
        }
        if (hasContent) {
            return 68;
        }
        if (hasAttributes) {
            return -124;
        }
        return 4;
    }

    public void encode() throws IOException {
        if (StrtblType.NO.equals((Object)this.type)) {
            this.os = this.realOs;
            this.encode(this.doc);
        } else {
            ByteArrayOutputStream bos = null;
            try {
                log.log(Level.FINE, "Performing first pass using a byte array");
                bos = new ByteArrayOutputStream(1024);
                this.os = bos;
                this.encode(this.doc);
                if (this.strtblUsed) {
                    this.reset();
                    log.log(Level.FINE, "Performing second pass into real stream cos strtbl used");
                    this.os = this.realOs;
                    this.encode(this.doc);
                } else {
                    log.log(Level.FINE, "Dumping byte arrays cos strtbl not used");
                    this.realOs.write(((ByteArrayOutputStream)this.os).toByteArray());
                }
            }
            finally {
                if (bos != null) {
                    bos.close();
                }
                this.os = null;
            }
        }
    }

    public void encode(WbXmlVersion version) throws IOException {
        byte v = (byte)(version.getMajor() - 1 << 4 | version.getMinor());
        this.write(v);
    }

    public void encode(WbXmlStrtbl strtbl) throws IOException {
        this.writeUnsignedInteger(strtbl.getSize());
        if (strtbl.getSize() > 0L) {
            for (long idx : strtbl.getIndexes()) {
                this.writeTableString(strtbl.getString(idx));
            }
        }
    }

    public void encode(IanaCharset charset) throws IOException {
        if (this.doc.getVersion().greaterThan(WbXmlVersion.VERSION_1_0)) {
            if (this.doc.getCharset() != null) {
                this.writeUnsignedInteger(this.doc.getCharset().getMibEnum());
            } else {
                this.writeUnsignedInteger(0L);
            }
        }
    }

    public void encode(WbXmlDefinition def) throws IOException {
        if (def.getPublicId() == 1L && !StrtblType.NO.equals((Object)this.type) && def.getXmlPublicId() != null) {
            this.writeUnsignedInteger(0L);
            long idx = this.doc.getStrtbl().addString(this, def.getXmlPublicId());
            this.writeUnsignedInteger(idx);
        } else {
            this.writeUnsignedInteger(def.getPublicId());
        }
    }

    public void encode(WbXmlDocument doc) throws IOException {
        this.encode(doc.getVersion());
        this.encode(doc.getDefinition());
        this.encode(doc.getCharset());
        this.encode(doc.getStrtbl());
        this.reset();
        this.encode(doc.getBody());
    }

    public void encode(WbXmlElement element) throws IOException {
        WbXmlTagDef def = this.getDefinition().locateTag(element.getTag());
        if (def != null) {
            this.writeSwitchPageTag(def.getToken().getPageCode());
            this.write(WbXmlEncoder.processTag(def.getToken().getToken(), !element.isAttributesEmpty(), !element.isContentsEmpty()));
        } else {
            log.log(Level.WARNING, "Using literal TAG in element: {0}", element.getTag());
            this.write(WbXmlEncoder.processLiteralTag(!element.isAttributesEmpty(), !element.isContentsEmpty()));
            long idx = this.getStrtbl().addString(this, element.getTag());
            this.writeUnsignedInteger(idx);
        }
        if (!element.isAttributesEmpty()) {
            for (WbXmlAttribute attr : element.getAttributes()) {
                this.encode(element, attr);
            }
            this.write((byte)1);
        }
        if (!element.isCompacted()) {
            element.compact(this);
        }
        if (!element.isContentsEmpty()) {
            for (WbXmlContent content : element.getContents()) {
                OpaqueContentPlugin plugin = this.getDefinition().locateTagPlugin(element.getTag());
                if (plugin != null && this.doc.getVersion().greaterThan(WbXmlVersion.VERSION_1_0)) {
                    plugin.encode(this, element, content);
                    continue;
                }
                if (plugin != null) {
                    log.log(Level.WARNING, "Opaque not used for element \"{0}\" because version \"{1}\" does not accept tag opaques.", new Object[]{element.getTag(), this.doc.getVersion().getVersion()});
                }
                this.encode(content);
            }
            this.write((byte)1);
        }
    }

    public void encode(WbXmlContent content) throws IOException {
        if (content.getElement() != null) {
            this.encode(content.getElement());
        } else if (content.getString() != null) {
            WbXmlExtensionDef extDef = this.getDefinition().locateExtension(content.getString());
            if (extDef != null) {
                this.write((byte)-128);
                this.writeUnsignedInteger(extDef.getToken());
            } else if (content.isEntity()) {
                this.write((byte)2);
                this.writeUnsignedInteger(content.getEntityNumber());
            } else {
                this.writeString(content.getString());
            }
        } else if (content.getPi() != null) {
            this.write((byte)67);
            this.encode(null, content.getPi());
            this.write((byte)1);
        }
    }

    public void encodeAttributeValue(String value) throws IOException {
        if (WbXmlLiterals.isEntity(value)) {
            this.write((byte)2);
            this.writeUnsignedInteger(WbXmlLiterals.getEntityNumber(value));
        } else {
            WbXmlAttributeValueDef valueAttrDef = this.getDefinition().locateAttributeValue(value);
            if (valueAttrDef != null) {
                this.writeSwitchPageAttribute(valueAttrDef.getToken().getPageCode());
                this.write(valueAttrDef.getToken().getToken());
            } else {
                WbXmlExtensionDef extDef = this.getDefinition().locateExtension(value);
                if (extDef != null) {
                    this.write((byte)-128);
                    this.writeUnsignedInteger(extDef.getToken());
                } else {
                    this.writeString(value);
                }
            }
        }
    }

    public void encode(WbXmlElement element, WbXmlAttribute attr) throws IOException {
        WbXmlAttributeDef def;
        String firstValue = null;
        if (!attr.isValuesEmpty()) {
            firstValue = attr.getValue(0);
        }
        if ((def = this.getDefinition().locateAttribute(attr.getName(), firstValue)) != null) {
            this.writeSwitchPageAttribute(def.getToken().getPageCode());
            this.write(def.getToken().getToken());
        } else {
            log.log(Level.WARNING, "Using literal TAG in attribute: {0}", attr.getName());
            this.write((byte)4);
            long idx = this.getStrtbl().addString(this, attr.getName());
            this.writeUnsignedInteger(idx);
        }
        if (!attr.isCompacted()) {
            attr.compact(this, def);
        }
        boolean first = true;
        for (String v : attr.getValues()) {
            if (first && def != null && def.getValue() != null && (v = v.substring(def.getValue().length())).isEmpty()) {
                first = false;
                continue;
            }
            OpaqueAttributePlugin plugin = null;
            if (def != null) {
                plugin = this.getDefinition().locateAttrPlugin(def.getNameWithPrefix());
            }
            if (plugin != null && this.doc.getVersion().greaterThan(WbXmlVersion.VERSION_1_1)) {
                plugin.encode(this, element, attr, v);
            } else {
                if (plugin != null) {
                    log.log(Level.WARNING, "Opaque not used for attribute \"{0}\" in element \"{1}\" because version \"{2}\" does not accept attribute opaques.", new Object[]{attr.getName(), element.getTag(), this.doc.getVersion().getVersion()});
                }
                this.encodeAttributeValue(v);
            }
            first = false;
        }
    }

    public void encode(WbXmlBody body) throws IOException {
        for (WbXmlAttribute pi : body.getPrePis()) {
            this.write((byte)67);
            this.encode(null, pi);
            this.write((byte)1);
        }
        this.encode(body.getElement());
        for (WbXmlAttribute pi : body.getPostPis()) {
            this.write((byte)67);
            this.encode(null, pi);
            this.write((byte)1);
        }
    }

    public static enum StrtblType {
        NO,
        IF_NEEDED,
        ALWAYS;

    }
}

