/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.document;

import es.rickyepoderi.wbxml.definition.IanaCharset;
import es.rickyepoderi.wbxml.definition.WbXmlDefinition;
import es.rickyepoderi.wbxml.document.WbXmlBody;
import es.rickyepoderi.wbxml.document.WbXmlLiterals;
import es.rickyepoderi.wbxml.document.WbXmlStrtbl;
import es.rickyepoderi.wbxml.document.WbXmlVersion;

public class WbXmlDocument {
    private WbXmlVersion version = null;
    private WbXmlDefinition definition = null;
    private IanaCharset charset = null;
    private WbXmlStrtbl strtbl = null;
    private WbXmlBody body = null;

    public WbXmlDocument() {
        this(WbXmlVersion.VERSION_1_3, null, null, null);
    }

    public WbXmlDocument(WbXmlDefinition definition) {
        this(WbXmlVersion.VERSION_1_3, definition, null, null);
    }

    public WbXmlDocument(WbXmlVersion version) {
        this(version, null, null, null);
    }

    public WbXmlDocument(WbXmlDefinition definition, IanaCharset charset) {
        this(WbXmlVersion.VERSION_1_3, definition, charset, null);
    }

    public WbXmlDocument(WbXmlVersion version, WbXmlDefinition definition) {
        this(version, definition, null, null);
    }

    public WbXmlDocument(WbXmlVersion version, IanaCharset charset) {
        this(version, null, charset, null);
    }

    public WbXmlDocument(WbXmlVersion version, WbXmlDefinition definition, IanaCharset charset) {
        this(version, definition, charset, null);
    }

    public WbXmlDocument(WbXmlVersion version, WbXmlDefinition definition, IanaCharset charset, WbXmlBody body) {
        this.version = version;
        this.definition = definition;
        this.strtbl = new WbXmlStrtbl();
        this.charset = charset;
        this.body = body;
    }

    public WbXmlVersion getVersion() {
        return this.version;
    }

    protected void setVersion(WbXmlVersion version) {
        this.version = version;
    }

    public WbXmlBody getBody() {
        return this.body;
    }

    public WbXmlDocument setBody(WbXmlBody body) {
        this.body = body;
        return this;
    }

    public WbXmlDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(WbXmlDefinition definition) {
        this.definition = definition;
    }

    public IanaCharset getCharset() {
        return this.charset;
    }

    protected void setCharset(IanaCharset charset) {
        this.charset = charset;
    }

    public WbXmlStrtbl getStrtbl() {
        return this.strtbl;
    }

    protected void setStrtbl(WbXmlStrtbl strtbl) {
        this.strtbl = strtbl;
    }

    public String toString(int ident) {
        String spaces = WbXmlLiterals.identString(ident);
        StringBuilder sb = new StringBuilder(spaces);
        sb.append(this.getClass().getSimpleName());
        sb.append(": ");
        sb.append(System.getProperty("line.separator"));
        sb.append(spaces);
        sb.append((Object)this.version);
        sb.append(System.getProperty("line.separator"));
        sb.append(spaces);
        sb.append("Definition: ");
        sb.append(this.definition.getName());
        sb.append(System.getProperty("line.separator"));
        sb.append(spaces);
        sb.append("Charset: ");
        sb.append(this.charset.getName());
        sb.append(System.getProperty("line.separator"));
        sb.append(spaces);
        sb.append(this.strtbl.toString(++ident));
        sb.append(spaces);
        sb.append(this.body.toString(ident));
        return sb.toString();
    }

    public String toString() {
        return this.toString(0);
    }
}

