/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.document;

import es.rickyepoderi.wbxml.definition.WbXmlAttributeDef;
import es.rickyepoderi.wbxml.document.WbXmlEncoder;
import es.rickyepoderi.wbxml.document.WbXmlLiterals;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class WbXmlAttribute {
    protected static final Logger log = Logger.getLogger(WbXmlAttribute.class.getName());
    private String name = null;
    private List<String> values = null;
    private boolean compacted = false;

    protected WbXmlAttribute() {
        this(null, (String[])null);
    }

    public WbXmlAttribute(String name) {
        this(name, (String[])null);
    }

    public WbXmlAttribute(String name, String value) {
        this(name, new String[]{value});
    }

    public WbXmlAttribute(String name, String[] values) {
        this.name = name;
        this.values = new ArrayList<String>();
        if (values != null) {
            this.values.addAll(Arrays.asList(values));
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrefixed() {
        return this.name.indexOf(58) >= 0;
    }

    public String getNamePrefix() {
        int idx = this.name.indexOf(58);
        if (idx >= 0) {
            return this.name.substring(0, idx);
        }
        return null;
    }

    public String getNameWithoutPrefix() {
        int idx = this.name.indexOf(58);
        if (idx >= 0) {
            return this.name.substring(idx + 1);
        }
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public WbXmlAttribute addValue(String value) {
        this.values.add(value);
        return this;
    }

    public WbXmlAttribute addValues(List<String> values) {
        this.values.addAll(values);
        return this;
    }

    public String getValue() {
        if (this.values.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String v : this.values) {
            sb.append(v);
        }
        return sb.toString();
    }

    public String getValue(int i) {
        return this.values.get(i);
    }

    public boolean isValuesEmpty() {
        return this.values.isEmpty();
    }

    public List<String> getValues() {
        return this.values;
    }

    public boolean isCompacted() {
        return this.compacted;
    }

    public void compact(WbXmlEncoder encoder, WbXmlAttributeDef def) {
        if (def == null || encoder.getDefinition().locateAttrPlugin(def.getNameWithPrefix()) == null) {
            int start = 0;
            if (def != null && def.getValue() != null) {
                start = def.getValue().length() - 1;
            }
            boolean first = true;
            ArrayList<String> newValues = new ArrayList<String>();
            for (String v : this.values) {
                if (first) {
                    newValues.addAll(encoder.getDefinition().compactAttributeValue(v, start));
                    first = false;
                    continue;
                }
                newValues.addAll(encoder.getDefinition().compactAttributeValue(v));
            }
            this.values.clear();
            first = true;
            for (String v : newValues) {
                if (first) {
                    this.values.addAll(encoder.getDefinition().compactExtension(v, start));
                    first = false;
                    continue;
                }
                this.values.addAll(encoder.getDefinition().compactExtension(v));
            }
        }
        this.compacted = true;
    }

    public void normalize() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> newValues = new ArrayList<String>();
        for (String v : this.values) {
            if (WbXmlLiterals.isEntity(v)) {
                if (sb.length() > 0) {
                    newValues.add(sb.toString());
                    sb.setLength(0);
                }
                newValues.add(v);
                continue;
            }
            sb.append(v);
        }
        if (sb.length() > 0 || newValues.isEmpty()) {
            newValues.add(sb.toString());
        }
        this.values = newValues;
        this.compacted = false;
    }

    public String toString(int ident) {
        String spaces = WbXmlLiterals.identString(ident);
        StringBuilder sb = new StringBuilder(spaces);
        sb.append(this.getClass().getSimpleName());
        sb.append(": ");
        sb.append(this.name);
        sb.append("=");
        for (String v : this.values) {
            sb.append('\"');
            sb.append(v);
            sb.append('\"');
            sb.append("|");
        }
        String res = sb.toString();
        return res.substring(0, res.length() - 1);
    }

    public String toString() {
        return this.toString(0);
    }
}

