/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.definition;

import es.rickyepoderi.wbxml.definition.WbXmlAttributeDef;
import es.rickyepoderi.wbxml.definition.WbXmlAttributeValueDef;
import es.rickyepoderi.wbxml.definition.WbXmlExtensionDef;
import es.rickyepoderi.wbxml.definition.WbXmlNamespaceDef;
import es.rickyepoderi.wbxml.definition.WbXmlTagDef;
import es.rickyepoderi.wbxml.definition.WbXmlToken;
import es.rickyepoderi.wbxml.document.ExtensionIPlugin;
import es.rickyepoderi.wbxml.document.ExtensionPlugin;
import es.rickyepoderi.wbxml.document.ExtensionTPlugin;
import es.rickyepoderi.wbxml.document.OpaqueAttributePlugin;
import es.rickyepoderi.wbxml.document.OpaqueContentPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class WbXmlDefinition {
    public static final long PUBLIC_ID_UNKNOWN = 1L;
    public static final long PUBLIC_ID_STR_T = 0L;
    private String name = null;
    private long publicId = 0L;
    private String xmlPublicId = null;
    private String xmlUriRef = null;
    private String clazz = null;
    private WbXmlTagDef root = null;
    Map<String, WbXmlNamespaceDef> nsByNamespace = null;
    Map<String, WbXmlNamespaceDef> nsByPrefix = null;
    private Map<WbXmlToken, WbXmlTagDef> tagsByToken = null;
    private Map<String, WbXmlTagDef> tagsByName = null;
    private Map<WbXmlToken, WbXmlAttributeDef> attrsByToken = null;
    private Map<String, TreeSet<WbXmlAttributeDef>> attrsByName = null;
    private Map<WbXmlToken, WbXmlAttributeValueDef> attrValuesByToken = null;
    private TreeSet<WbXmlAttributeValueDef> attrValuesByValue = null;
    private Map<Byte, WbXmlExtensionDef> extsByToken = null;
    private TreeSet<WbXmlExtensionDef> extsByValue = null;
    private Map<WbXmlToken, OpaqueAttributePlugin> opaqueAttrByToken = null;
    private Map<String, OpaqueAttributePlugin> opaqueAttrByName = null;
    private Map<WbXmlToken, OpaqueContentPlugin> opaqueTagByToken = null;
    private Map<String, OpaqueContentPlugin> opaqueTagByName = null;
    private Map<String, WbXmlDefinition> linkedDefinitions = null;
    private ExtensionIPlugin extensionI;
    private ExtensionTPlugin extensionT;
    private ExtensionPlugin extension;

    protected WbXmlDefinition(String name) {
        this.name = name;
        this.nsByNamespace = new HashMap<String, WbXmlNamespaceDef>();
        this.nsByPrefix = new HashMap<String, WbXmlNamespaceDef>();
        this.tagsByToken = new HashMap<WbXmlToken, WbXmlTagDef>();
        this.tagsByName = new HashMap<String, WbXmlTagDef>();
        this.attrsByToken = new HashMap<WbXmlToken, WbXmlAttributeDef>();
        this.attrsByName = new HashMap<String, TreeSet<WbXmlAttributeDef>>();
        this.attrValuesByToken = new HashMap<WbXmlToken, WbXmlAttributeValueDef>();
        this.attrValuesByValue = new TreeSet();
        this.extsByToken = new HashMap<Byte, WbXmlExtensionDef>();
        this.extsByValue = new TreeSet();
        this.opaqueAttrByName = new HashMap<String, OpaqueAttributePlugin>();
        this.opaqueAttrByToken = new HashMap<WbXmlToken, OpaqueAttributePlugin>();
        this.opaqueTagByName = new HashMap<String, OpaqueContentPlugin>();
        this.opaqueTagByToken = new HashMap<WbXmlToken, OpaqueContentPlugin>();
        this.linkedDefinitions = new HashMap<String, WbXmlDefinition>();
    }

    protected WbXmlDefinition(String name, long publicId) {
        this(name);
        this.publicId = publicId;
    }

    protected WbXmlDefinition(String name, long publicId, String xmlPublicId) {
        this(name, publicId);
        this.xmlPublicId = xmlPublicId;
    }

    protected WbXmlDefinition(String name, long publicId, String xmlPublicId, String xmlUriRef, String clazz) {
        this(name, publicId, xmlPublicId);
        this.xmlUriRef = xmlUriRef;
        this.clazz = clazz;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public long getPublicId() {
        return this.publicId;
    }

    protected void setPublicId(long publicId) {
        this.publicId = publicId;
    }

    public String getXmlPublicId() {
        return this.xmlPublicId;
    }

    protected void setXmlPublicId(String xmlPublicId) {
        this.xmlPublicId = xmlPublicId;
    }

    public String getXmlUriRef() {
        return this.xmlUriRef;
    }

    protected void setXmlUriRef(String xmlUriRef) {
        this.xmlUriRef = xmlUriRef;
    }

    protected void setRoot(WbXmlTagDef root) {
        this.root = root;
    }

    protected void setRoot(String root) {
        this.root = this.tagsByName.get(root);
    }

    public WbXmlTagDef getRoot() {
        return this.root;
    }

    public String getRootName() {
        return this.root == null ? null : this.root.getNameWithPrefix();
    }

    public String getClazz() {
        return this.clazz;
    }

    protected void setClazz(String clazz) {
        this.clazz = clazz;
    }

    protected Map<String, WbXmlDefinition> getLinkedDefinitions() {
        return this.linkedDefinitions;
    }

    public Collection<WbXmlDefinition> getLinkedDefs() {
        return this.linkedDefinitions.values();
    }

    public WbXmlDefinition getLinkedDef(String name) {
        return this.linkedDefinitions.get(name);
    }

    public ExtensionIPlugin getExtensionI() {
        return this.extensionI;
    }

    public void setExtensionI(ExtensionIPlugin extensionI) {
        this.extensionI = extensionI;
    }

    public ExtensionTPlugin getExtensionT() {
        return this.extensionT;
    }

    public void setExtensionT(ExtensionTPlugin extensionT) {
        this.extensionT = extensionT;
    }

    public ExtensionPlugin getExtension() {
        return this.extension;
    }

    public void setExtension(ExtensionPlugin extension) {
        this.extension = extension;
    }

    protected void addNamespace(WbXmlNamespaceDef ns) {
        this.nsByNamespace.put(ns.getNamespace(), ns);
        this.nsByPrefix.put(ns.getPrefix(), ns);
    }

    protected void addExtension(WbXmlExtensionDef ext) {
        this.extsByValue.add(ext);
        this.extsByToken.put(ext.getToken(), ext);
    }

    protected void addOpaqueAttr(WbXmlAttributeDef attr, OpaqueAttributePlugin plugin) {
        this.opaqueAttrByName.put(attr.getNameWithPrefix(), plugin);
        this.opaqueAttrByToken.put(attr.getToken(), plugin);
    }

    protected void addOpaqueTag(WbXmlTagDef tag, OpaqueContentPlugin plugin) {
        this.opaqueTagByName.put(tag.getNameWithPrefix(), plugin);
        this.opaqueTagByToken.put(tag.getToken(), plugin);
    }

    protected void addAttr(WbXmlAttributeDef attr) {
        TreeSet<WbXmlAttributeDef> set = this.attrsByName.get(attr.getNameWithPrefix());
        if (set == null) {
            set = new TreeSet();
            this.attrsByName.put(attr.getNameWithPrefix(), set);
        }
        set.add(attr);
        this.attrsByToken.put(attr.getToken(), attr);
    }

    protected void addAttrValue(WbXmlAttributeValueDef attrVal) {
        this.attrValuesByValue.add(attrVal);
        this.attrValuesByToken.put(attrVal.getToken(), attrVal);
    }

    protected void addTag(WbXmlTagDef tag) {
        this.tagsByName.put(tag.getNameWithPrefix(), tag);
        this.tagsByToken.put(tag.getToken(), tag);
    }

    public List<String> compactAttributeValue(String value) {
        return this.compactAttributeValue(value, 0);
    }

    private List<String> matches(String value, String valueToFound, int start, boolean attr) {
        int pos = value.indexOf(valueToFound, start);
        if (pos >= 0) {
            ArrayList<String> result = new ArrayList<String>();
            if (valueToFound.length() < 3 && value.length() != valueToFound.length() - start) {
                result.add(value);
                return result;
            }
            String firstPart = null;
            if (pos > 0) {
                firstPart = value.substring(0, pos);
            }
            String secondPart = value.substring(pos, pos + valueToFound.length());
            String thirdPart = null;
            if (pos + valueToFound.length() < value.length()) {
                thirdPart = value.substring(pos + valueToFound.length());
            }
            if (firstPart != null && !firstPart.isEmpty()) {
                if (attr) {
                    result.addAll(this.compactAttributeValue(firstPart, start));
                } else {
                    result.addAll(this.compactExtension(firstPart, start));
                }
            }
            result.add(secondPart);
            if (thirdPart != null && !thirdPart.isEmpty()) {
                if (attr) {
                    result.addAll(this.compactAttributeValue(thirdPart, 0));
                } else {
                    result.addAll(this.compactExtension(thirdPart, 0));
                }
            }
            return result;
        }
        return null;
    }

    public List<String> compactAttributeValue(String value, int start) {
        ArrayList<String> result = new ArrayList<String>();
        if (start > value.length()) {
            result.add(value);
            return result;
        }
        WbXmlAttributeValueDef valueDef = new WbXmlAttributeValueDef(value.substring(start), 0, 0);
        for (WbXmlAttributeValueDef attrVal : this.attrValuesByValue.tailSet(valueDef)) {
            List<String> found = this.matches(value, attrVal.getValue(), start, true);
            if (found == null) continue;
            return found;
        }
        result.add(value);
        return result;
    }

    public List<String> compactExtension(String value) {
        return this.compactExtension(value, 0);
    }

    public List<String> compactExtension(String value, int start) {
        ArrayList<String> result = new ArrayList<String>();
        if (start > value.length()) {
            result.add(value);
            return result;
        }
        WbXmlExtensionDef extDef = new WbXmlExtensionDef(value.substring(start), 0);
        for (WbXmlExtensionDef ext : this.extsByValue.tailSet(extDef)) {
            List<String> found = this.matches(value, ext.getValue(), start, false);
            if (found == null) continue;
            return found;
        }
        result.add(value);
        return result;
    }

    public Set<WbXmlAttributeDef> locateAttribute(String name) {
        return this.attrsByName.get(name);
    }

    public WbXmlAttributeDef locateAttribute(String name, String value) {
        TreeSet<WbXmlAttributeDef> attrs = this.attrsByName.get(name);
        if (attrs != null) {
            for (WbXmlAttributeDef attr : attrs) {
                if (!name.equals(attr.getNameWithPrefix()) || attr.getValue() != null && !value.startsWith(attr.getValue())) continue;
                return attr;
            }
        }
        return null;
    }

    public WbXmlAttributeDef locateAttribute(byte pageCode, byte token) {
        return this.attrsByToken.get(new WbXmlToken(pageCode, token));
    }

    public WbXmlAttributeValueDef locateAttributeValue(String value) {
        WbXmlAttributeValueDef attrVal = new WbXmlAttributeValueDef(value, 0, 0);
        WbXmlAttributeValueDef res = this.attrValuesByValue.ceiling(attrVal);
        if (res != null && res.getValue().equals(value)) {
            return res;
        }
        return null;
    }

    public WbXmlAttributeValueDef locateAttributeValue(byte pageCode, byte token) {
        return this.attrValuesByToken.get(new WbXmlToken(pageCode, token));
    }

    public WbXmlExtensionDef locateExtension(long ext) {
        return this.extsByToken.get((byte)ext);
    }

    public WbXmlExtensionDef locateExtension(String value) {
        WbXmlExtensionDef ext = new WbXmlExtensionDef(value, 0);
        WbXmlExtensionDef res = this.extsByValue.ceiling(ext);
        if (res != null && res.getValue().equals(value)) {
            return res;
        }
        return null;
    }

    public WbXmlTagDef locateTag(String name) {
        return this.tagsByName.get(name);
    }

    public WbXmlDefinition locateLinkedDefinitionForTag(String name) {
        for (WbXmlDefinition def : this.linkedDefinitions.values()) {
            if (def.locateTag(name) == null) continue;
            return def;
        }
        return null;
    }

    public WbXmlTagDef locateTag(byte pageCode, byte tag) {
        return this.tagsByToken.get(new WbXmlToken(pageCode, tag));
    }

    public OpaqueAttributePlugin locateAttrPlugin(String name) {
        return this.opaqueAttrByName.get(name);
    }

    public OpaqueContentPlugin locateTagPlugin(String tag) {
        return this.opaqueTagByName.get(tag);
    }

    public Collection<WbXmlNamespaceDef> getNamespaces() {
        return this.nsByNamespace.values();
    }

    public String getPrefix(String namespaceURI) {
        WbXmlNamespaceDef ns = this.nsByNamespace.get(namespaceURI);
        if (ns != null) {
            return ns.getPrefix();
        }
        return null;
    }

    public String getPrefixWithLinked(String namespaceURI) {
        String prefix = this.getPrefix(namespaceURI);
        if (prefix != null) {
            return prefix;
        }
        for (WbXmlDefinition def : this.linkedDefinitions.values()) {
            prefix = def.getPrefix(namespaceURI);
            if (prefix == null) continue;
            return prefix;
        }
        return null;
    }

    public String getNamespaceURI(String prefix) {
        WbXmlNamespaceDef ns = this.nsByPrefix.get(prefix);
        if (ns != null) {
            return ns.getNamespace();
        }
        return null;
    }

    public String getNamespaceURIWithLinked(String prefix) {
        String namespaceURI = this.getNamespaceURI(prefix);
        if (namespaceURI != null) {
            return namespaceURI;
        }
        for (WbXmlDefinition def : this.linkedDefinitions.values()) {
            namespaceURI = def.getNamespaceURI(prefix);
            if (namespaceURI == null) continue;
            return namespaceURI;
        }
        return null;
    }

    public WbXmlNamespaceDef getNamespace(String prefix) {
        return this.nsByPrefix.get(prefix);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append(System.getProperty("line.separator"));
        sb.append("name: ");
        sb.append(this.name);
        sb.append(System.getProperty("line.separator"));
        sb.append("publicId: ");
        sb.append(this.publicId);
        sb.append(System.getProperty("line.separator"));
        sb.append("xmlPublicId: ");
        sb.append(this.xmlPublicId);
        sb.append(System.getProperty("line.separator"));
        sb.append("xmlUriRef: ");
        sb.append(this.xmlUriRef);
        sb.append(System.getProperty("line.separator"));
        sb.append("clazz: ");
        sb.append(this.clazz);
        sb.append(System.getProperty("line.separator"));
        sb.append("root: ");
        sb.append(this.root);
        sb.append("namespaces: ");
        sb.append(System.getProperty("line.separator"));
        for (WbXmlNamespaceDef wbXmlNamespaceDef : this.nsByPrefix.values()) {
            sb.append(wbXmlNamespaceDef.getPrefix());
            sb.append(" -> ");
            sb.append(wbXmlNamespaceDef);
        }
        sb.append("tags:");
        sb.append(System.getProperty("line.separator"));
        for (WbXmlTagDef wbXmlTagDef : this.tagsByName.values()) {
            sb.append(wbXmlTagDef);
        }
        sb.append("attributes: ");
        sb.append(System.getProperty("line.separator"));
        for (TreeSet treeSet : this.attrsByName.values()) {
            for (WbXmlAttributeDef attr : treeSet) {
                sb.append(attr);
            }
        }
        sb.append("values:");
        sb.append(System.getProperty("line.separator"));
        for (WbXmlAttributeValueDef wbXmlAttributeValueDef : this.attrValuesByValue) {
            sb.append(wbXmlAttributeValueDef);
        }
        sb.append("extensions: ");
        sb.append(System.getProperty("line.separator"));
        for (WbXmlExtensionDef wbXmlExtensionDef : this.extsByValue) {
            sb.append(wbXmlExtensionDef);
        }
        sb.append("opaque attr plugins: ");
        sb.append(System.getProperty("line.separator"));
        for (WbXmlToken wbXmlToken : this.opaqueAttrByToken.keySet()) {
            sb.append(wbXmlToken);
            sb.append("->");
            sb.append(this.opaqueAttrByToken.get(wbXmlToken).getClass().getName());
            sb.append(System.getProperty("line.separator"));
        }
        sb.append("opaque tag plugins: ");
        sb.append(System.getProperty("line.separator"));
        for (WbXmlToken wbXmlToken : this.opaqueTagByToken.keySet()) {
            sb.append(wbXmlToken);
            sb.append("->");
            sb.append(this.opaqueTagByToken.get(wbXmlToken).getClass().getName());
            sb.append(System.getProperty("line.separator"));
        }
        sb.append("Linked definitions: ");
        sb.append(System.getProperty("line.separator"));
        for (WbXmlDefinition wbXmlDefinition : this.linkedDefinitions.values()) {
            sb.append(wbXmlDefinition.getName());
            sb.append(System.getProperty("line.separator"));
        }
        sb.append("Extension: ");
        sb.append(this.extension);
        sb.append(System.getProperty("line.separator"));
        sb.append("Extension I: ");
        sb.append(this.extensionI);
        sb.append(System.getProperty("line.separator"));
        sb.append("Extension T: ");
        sb.append(this.extensionT);
        sb.append(System.getProperty("line.separator"));
        return sb.toString();
    }
}

