/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.definition;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum IanaCharset {
    UNKNOWN("UNKNOWN", 0L, new String[0]),
    ANSI_X3_4_1968("ANSI_X3.4-1968", 3L, new String[]{"US-ASCII", "iso-ir-6", "ANSI_X3.4-1986", "ISO_646.irv:1991", "ASCII", "ISO646-US", "us", "IBM367", "cp367", "csASCII"}),
    ISO_8859_1_1987("ISO_8859-1:1987", 4L, new String[]{"ISO-8859-1", "iso-ir-100", "ISO_8859-1", "latin1", "l1", "IBM819", "CP819", "csISOLatin1"}),
    ISO_8859_2_1987("ISO_8859-2:1987", 5L, new String[]{"ISO-8859-2", "iso-ir-101", "ISO_8859-2", "latin2", "l2", "csISOLatin2"}),
    ISO_8859_3_1988("ISO_8859-3:1988", 6L, new String[]{"ISO-8859-3", "iso-ir-109", "ISO_8859-3", "latin3", "l3", "csISOLatin3"}),
    ISO_8859_4_1988("ISO_8859-4:1988", 7L, new String[]{"ISO-8859-4", "iso-ir-110", "ISO_8859-4", "latin4", "l4", "csISOLatin4"}),
    ISO_8859_5_1988("ISO_8859-5:1988", 8L, new String[]{"ISO-8859-5", " iso-ir-144", "ISO_8859-5", "cyrillic", "csISOLatinCyrillic"}),
    ISO_8859_6_1987("ISO_8859-6:1987", 9L, new String[]{"ISO-8859-6", "iso-ir-127", "ISO_8859-6", "ECMA-114", "ASMO-708", "arabic", "csISOLatinArabic"}),
    ISO_8859_7_1987("ISO_8859-7:1987", 10L, new String[]{"ISO-8859-7", "iso-ir-126", "ISO_8859-7", "ELOT_928", "ECMA-118", "greek", "greek8", "csISOLatinGreek"}),
    ISO_8859_8_1988("ISO_8859-8:1988", 11L, new String[]{"ISO-8859-8", "iso-ir-138", "ISO_8859-8", "hebrew", "csISOLatinHebrew"}),
    ISO_8859_9_1989("ISO_8859-9:1989", 12L, new String[]{"ISO-8859-9", "iso-ir-148", "ISO_8859-9", "latin5", "l5", "csISOLatin5"}),
    ISO_8859_10("ISO-8859-10", 13L, new String[]{"iso-ir-157", "l6", "ISO_8859-10:1992", "csISOLatin6", "latin6"}),
    Shift_JIS("Shift_JIS", 17L, new String[]{"MS_Kanji", "csShiftJIS"}),
    UTF_8("UTF-8", 106L, new String[0]),
    Big5("Big5", 2026L, new String[]{"csBig5"}),
    ISO_10646_UCS_2("ISO-10646-UCS-2", 1000L, new String[]{"csUnicode"}),
    UTF_16("UTF-16", 1015L, new String[0]);

    protected static final Logger log;
    private String name = null;
    private long mibEnum = 0L;
    private String[] alias;
    private Charset charset;
    private static final Map<String, IanaCharset> charsetAliasMap;
    private static final Map<Long, IanaCharset> charsetMibMap;

    private IanaCharset(String name, long mibEnum, String[] alias) {
        this.name = name;
        this.mibEnum = mibEnum;
        this.alias = alias;
        this.charset = null;
    }

    public String[] getAlias() {
        return this.alias;
    }

    public long getMibEnum() {
        return this.mibEnum;
    }

    public String getName() {
        return this.name;
    }

    public static IanaCharset getIanaCharset(String alias) {
        IanaCharset charset = charsetAliasMap.get(alias.toUpperCase());
        if (charset == null) {
            charset = UNKNOWN;
        }
        return charset;
    }

    public static IanaCharset getIanaCharset(long mib) {
        IanaCharset charset = charsetMibMap.get(mib);
        if (charset == null) {
            charset = UNKNOWN;
        }
        return charset;
    }

    protected static Charset getCharsetName(String name) {
        try {
            return Charset.forName(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Charset getCharset() {
        if (this.charset == null) {
            this.charset = IanaCharset.getCharsetName(this.name);
            if (this.charset == null) {
                for (String a : this.alias) {
                    this.charset = IanaCharset.getCharsetName(a);
                    if (this.charset != null) break;
                }
            }
            if (this.charset == null) {
                if (this.mibEnum != 0L) {
                    log.log(Level.WARNING, "Iana charset '{0}' has no Java equivalence", this.toString());
                }
                this.charset = IanaCharset.getCharsetName("UTF-8");
            }
        }
        return this.charset;
    }

    static {
        log = Logger.getLogger(IanaCharset.class.getName());
        charsetAliasMap = new HashMap<String, IanaCharset>();
        charsetMibMap = new HashMap<Long, IanaCharset>();
        for (IanaCharset c : IanaCharset.values()) {
            charsetMibMap.put(c.getMibEnum(), c);
            charsetAliasMap.put(c.getName().toUpperCase(), c);
            for (String alias : c.alias) {
                charsetAliasMap.put(alias.toUpperCase(), c);
            }
        }
    }
}

