/*
 * Decompiled with CFR 0.152.
 */
package vctextview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Camera;
import android.graphics.Matrix;
import android.os.Handler;
import android.os.Message;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.widget.TextSwitcher;
import android.widget.TextView;
import android.widget.ViewSwitcher;
import gu.china.com.vertical_scroll_textview.R;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import vctextview.Hot;

public class VerticalScrollTextView
extends TextSwitcher
implements ViewSwitcher.ViewFactory {
    private Context context;
    private ScrollAnimation inAnimation;
    private ScrollAnimation outAnimation;
    private ArrayList<Hot> hotList;
    private int startPosition = 0;
    private String content;
    private Timer mTimer;
    long mSwitchTime = 3000L;
    private float tvHeight;
    private float tvSize;
    private int tvColor;
    private String tvHint;
    Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    VerticalScrollTextView.this.getPosition();
                    VerticalScrollTextView.this.next();
                    VerticalScrollTextView.this.startPosition++;
                    VerticalScrollTextView.this.setText(VerticalScrollTextView.this.content);
                    break;
                }
            }
        }
    };

    public VerticalScrollTextView(Context context) {
        this(context, null);
    }

    public VerticalScrollTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.vertical_text);
        if (typedArray != null) {
            this.tvSize = typedArray.getDimension(R.styleable.vertical_text_vTextSize, 12.0f);
            this.tvColor = typedArray.getColor(R.styleable.vertical_text_vTextColor, ContextCompat.getColor((Context)context, (int)R.color.font_main));
            this.tvHeight = typedArray.getDimension(R.styleable.vertical_text_vTextHeight, 120.0f);
            this.tvHint = typedArray.hasValue(R.styleable.vertical_text_vTextHint) ? typedArray.getString(R.styleable.vertical_text_vTextHint) : "";
        }
        typedArray.recycle();
        this.context = context;
        this.init();
    }

    private void init() {
        this.hotList = new ArrayList();
        this.setFactory(this);
        this.inAnimation = this.createAnim(-90.0f, 0.0f, true, true);
        this.outAnimation = this.createAnim(0.0f, 90.0f, false, true);
        this.setInAnimation(this.inAnimation);
        this.setOutAnimation(this.outAnimation);
    }

    private ScrollAnimation createAnim(float start, float end, boolean turnIn, boolean turnUp) {
        ScrollAnimation rotation = new ScrollAnimation(start, end, turnIn, turnUp);
        rotation.setDuration(500L);
        rotation.setFillAfter(false);
        rotation.setInterpolator((Interpolator)new AccelerateInterpolator());
        return rotation;
    }

    public View makeView() {
        TextView textView = new TextView(this.context);
        textView.setGravity(3);
        textView.setPadding(16, 16, 16, 16);
        textView.setTextSize(0, this.tvSize);
        textView.setTextColor(this.tvColor);
        textView.setGravity(16);
        textView.setText((CharSequence)this.tvHint);
        textView.setSingleLine(true);
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setHeight((int)this.tvHeight);
        return textView;
    }

    public void next() {
        if (this.getInAnimation() != this.inAnimation) {
            this.setInAnimation(this.inAnimation);
        }
        if (this.getOutAnimation() != this.outAnimation) {
            this.setOutAnimation(this.outAnimation);
        }
    }

    public void setList(ArrayList<Hot> list) {
        this.hotList.clear();
        this.hotList.addAll(list);
        this.startPosition = 0;
        this.stop();
        this.start();
    }

    private int getPosition() {
        if (this.hotList == null) {
            this.stop();
            this.content = "";
            return -1;
        }
        if (this.startPosition >= this.hotList.size()) {
            this.startPosition = 0;
        }
        this.content = this.startPosition < this.hotList.size() ? this.hotList.get(this.startPosition).getContent() : "";
        return this.startPosition;
    }

    public void start() {
        if (this.hotList == null) {
            return;
        }
        if (this.hotList.size() == 1) {
            this.setText(this.hotList.get(0).getContent());
            return;
        }
        if (this.mTimer == null && this.hotList.size() > 1 && this.mSwitchTime > 0L) {
            this.mTimer = new Timer();
            this.handler.sendEmptyMessage(0);
            this.mTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    VerticalScrollTextView.this.handler.sendEmptyMessage(0);
                }
            }, this.mSwitchTime, this.mSwitchTime);
        }
    }

    public void stop() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }

    class ScrollAnimation
    extends Animation {
        private final float mFromDegrees;
        private final float mToDegrees;
        private float mCenterX;
        private float mCenterY;
        private final boolean mTurnIn;
        private final boolean mTurnUp;
        private Camera mCamera;

        public ScrollAnimation(float fromDegrees, float toDegrees, boolean turnIn, boolean turnUp) {
            this.mFromDegrees = fromDegrees;
            this.mToDegrees = toDegrees;
            this.mTurnIn = turnIn;
            this.mTurnUp = turnUp;
        }

        public void initialize(int width, int height, int parentWidth, int parentHeight) {
            super.initialize(width, height, parentWidth, parentHeight);
            this.mCamera = new Camera();
            this.mCenterY = VerticalScrollTextView.this.getHeight() / 2;
            this.mCenterX = VerticalScrollTextView.this.getWidth() / 2;
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            float fromDegrees = this.mFromDegrees;
            float degrees = fromDegrees + (this.mToDegrees - fromDegrees) * interpolatedTime;
            float centerX = this.mCenterX;
            float centerY = this.mCenterY;
            Camera camera = this.mCamera;
            int derection = this.mTurnUp ? 1 : -1;
            Matrix matrix = t.getMatrix();
            camera.save();
            if (this.mTurnIn) {
                camera.translate(0.0f, (float)derection * this.mCenterY * (interpolatedTime - 1.0f), 0.0f);
            } else {
                camera.translate(0.0f, (float)derection * this.mCenterY * interpolatedTime, 0.0f);
            }
            camera.getMatrix(matrix);
            camera.restore();
            matrix.preTranslate(-centerX, -centerY);
            matrix.postTranslate(centerX, centerY);
        }
    }
}

