/*
 * Decompiled with CFR 0.152.
 */
package com.chimeraiot.android.ble;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import com.chimeraiot.android.ble.BleConfig;

public class BluetoothStateReceiver
extends BroadcastReceiver {
    private static final String TAG = BluetoothStateReceiver.class.getSimpleName();
    private boolean isRegistered = false;

    public void register(Context context) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        this.isRegistered = true;
    }

    public void unregister(Context context) {
        if (this.isRegistered) {
            context.unregisterReceiver((BroadcastReceiver)this);
            this.isRegistered = false;
        }
    }

    public void onReceive(Context context, Intent intent) {
        String action;
        switch (action = intent.getAction()) {
            case "android.bluetooth.adapter.action.STATE_CHANGED": {
                int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 10);
                if (BleConfig.isDebugEnabled()) {
                    boolean enabled = state == 12;
                    Log.d((String)TAG, (String)("bluetooth: " + enabled + " (state " + state + ")"));
                }
                this.onBluetoothStateChanged(state);
                break;
            }
        }
    }

    public void onBluetoothStateChanged(int state) {
    }
}

