/*
 * Decompiled with CFR 0.152.
 */
package com.chimeraiot.android.ble;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.chimeraiot.android.ble.BleConfig;
import com.chimeraiot.android.ble.BleUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class BleScanner
implements Runnable,
BluetoothAdapter.LeScanCallback {
    private static final String TAG = BleScanner.class.getSimpleName();
    public static final long DEFAULT_SCAN_PERIOD = 5000L;
    public static final long PERIOD_SCAN_ONCE = -1L;
    private final BluetoothAdapter bluetoothAdapter;
    private long scanPeriod = 5000L;
    private int scanMode = 2;
    private ScanCallback scanCallback;
    private List<ScanFilter> filter = new ArrayList<ScanFilter>();
    private Thread scanThread;
    private final AtomicBoolean isScanning = new AtomicBoolean(false);
    private final Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    private BleScannerListener listener;

    public BleScanner(BluetoothAdapter adapter, BleScannerListener listener) {
        if (adapter == null) {
            throw new IllegalArgumentException("Adapter should not be null");
        }
        this.listener = listener;
        this.bluetoothAdapter = adapter;
        if (BleUtils.api21()) {
            this.scanCallback = new ScanCallback(){

                @TargetApi(value=21)
                public void onScanResult(int callbackType, ScanResult result) {
                    byte[] bytes;
                    super.onScanResult(callbackType, result);
                    byte[] byArray = bytes = result.getScanRecord() != null ? result.getScanRecord().getBytes() : null;
                    if (BleConfig.isDebugEnabled()) {
                        Log.d((String)TAG, (String)("Scan result: " + result));
                    }
                    BleScanner.this.onLeScan(result.getDevice(), result.getRssi(), bytes);
                }
            };
        }
    }

    public synchronized void setScanPeriod(long scanPeriod) {
        this.scanPeriod = scanPeriod < 0L ? -1L : scanPeriod;
    }

    public void setScanMode(int scanMode) {
        boolean restart = this.isScanning();
        this.scanMode = scanMode;
        if (restart) {
            this.stop();
            this.start(new ScanFilter[0]);
        }
    }

    public boolean isScanning() {
        return this.scanThread != null && this.scanThread.isAlive();
    }

    @TargetApi(value=21)
    public synchronized void start(ScanFilter ... filters) {
        if (this.isScanning()) {
            return;
        }
        this.filter.clear();
        if (filters != null) {
            Collections.addAll(this.filter, filters);
        }
        if (this.scanThread != null) {
            this.scanThread.interrupt();
        }
        this.scanThread = new Thread(this);
        this.scanThread.setName(TAG);
        this.scanThread.start();
    }

    public synchronized void stop() {
        this.isScanning.set(false);
        if (this.scanThread != null) {
            this.scanThread.interrupt();
            this.scanThread = null;
        }
        this.stopScanner();
    }

    private synchronized void startScanner() {
        if (BleUtils.api21()) {
            ScanSettings settings = new ScanSettings.Builder().setScanMode(this.scanMode).build();
            BluetoothLeScanner scanner = this.bluetoothAdapter.getBluetoothLeScanner();
            if (scanner != null) {
                scanner.startScan(this.filter, settings, this.scanCallback);
            }
        } else {
            this.bluetoothAdapter.startLeScan((BluetoothAdapter.LeScanCallback)this);
        }
    }

    private synchronized void stopScanner() {
        if (BleUtils.api21()) {
            BluetoothLeScanner scanner = this.bluetoothAdapter.getBluetoothLeScanner();
            if (scanner != null) {
                scanner.stopScan(this.scanCallback);
            }
        } else {
            this.bluetoothAdapter.stopLeScan((BluetoothAdapter.LeScanCallback)this);
        }
    }

    @Override
    @TargetApi(value=21)
    public void run() {
        try {
            this.isScanning.set(true);
            this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    BleScanner.this.listener.onScanStarted();
                }
            });
            do {
                this.startScanner();
                if (this.scanPeriod > 0L) {
                    Thread.sleep(this.scanPeriod);
                } else {
                    Thread.sleep(5000L);
                }
                this.stopScanner();
                if (this.scanPeriod <= 0L) continue;
                this.mainThreadHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BleScanner.this.listener.onScanRepeat();
                    }
                });
            } while (this.bluetoothAdapter.isEnabled() && this.isScanning.get() && this.scanPeriod > 0L);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.stopScanner();
        }
        this.isScanning.set(false);
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                BleScanner.this.listener.onScanStopped();
            }
        });
    }

    public void onLeScan(final BluetoothDevice device, final int rssi, final byte[] scanRecord) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                BleScanner.this.listener.onLeScan(device, rssi, scanRecord);
            }
        });
    }

    public static interface BleScannerListener
    extends BluetoothAdapter.LeScanCallback {
        public void onScanStarted();

        public void onScanRepeat();

        public void onScanStopped();

        public void onLeScan(BluetoothDevice var1, int var2, byte[] var3);
    }

    public static class BleScannerAdapter
    implements BleScannerListener {
        @Override
        public void onScanStarted() {
        }

        @Override
        public void onScanRepeat() {
        }

        @Override
        public void onScanStopped() {
        }

        @Override
        public void onLeScan(BluetoothDevice device, int i, byte[] bytes) {
        }
    }
}

