/*
 * Decompiled with CFR 0.152.
 */
package com.chimeraiot.android.ble.sensor;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.os.Bundle;
import android.util.Log;
import com.chimeraiot.android.ble.BleConfig;
import com.chimeraiot.android.ble.BleGattExecutor;
import java.util.UUID;

public abstract class Sensor<T> {
    private static final String TAG = Sensor.class.getSimpleName();
    private static final String CHARACTERISTIC_CONFIG = "00002902-0000-1000-8000-00805f9b34fb";
    private T data;

    protected Sensor(T data) {
        this.data = data;
    }

    protected abstract boolean apply(BluetoothGattCharacteristic var1, T var2);

    public abstract String getName();

    public T getData() {
        return this.data;
    }

    public String getCharacteristicName(String uuid) {
        return "Unknown";
    }

    public abstract String getServiceUUID();

    public boolean onCharacteristicChanged(BluetoothGattCharacteristic c) {
        return this.apply(c, this.data);
    }

    public boolean onCharacteristicRead(BluetoothGattCharacteristic c) {
        return this.apply(c, this.data);
    }

    public BleGattExecutor.ServiceAction[] update(String uuid, Bundle data) {
        return new BleGattExecutor.ServiceAction[]{BleGattExecutor.ServiceAction.VOID};
    }

    public BleGattExecutor.ServiceAction read(final String uuid) {
        return new BleGattExecutor.ServiceAction(uuid, BleGattExecutor.ServiceAction.ActionType.READ){

            @Override
            public boolean execute(BluetoothGatt gatt) {
                BluetoothGattCharacteristic characteristic = Sensor.this.getCharacteristic(gatt, uuid);
                if ((characteristic.getProperties() & 2) == 0) {
                    if (BleConfig.isDebugEnabled()) {
                        Log.w((String)TAG, (String)("Characteristic " + uuid + " can not be read"));
                    }
                    return true;
                }
                boolean success = gatt.readCharacteristic(characteristic);
                if (!success && BleConfig.isDebugEnabled()) {
                    Log.w((String)TAG, (String)("Read " + uuid + " FAILED!"));
                }
                return false;
            }
        };
    }

    public BleGattExecutor.ServiceAction write(final String uuid, final byte[] value) {
        return new BleGattExecutor.ServiceAction(uuid, BleGattExecutor.ServiceAction.ActionType.WRITE){

            @Override
            public boolean execute(BluetoothGatt gatt) {
                BluetoothGattCharacteristic characteristic = Sensor.this.getCharacteristic(gatt, uuid);
                if ((characteristic.getProperties() & 8) == 0) {
                    if (BleConfig.isDebugEnabled()) {
                        Log.w((String)TAG, (String)("Characteristic " + uuid + " can not be written"));
                    }
                    return true;
                }
                characteristic.setValue(value);
                boolean success = gatt.writeCharacteristic(characteristic);
                if (!success && BleConfig.isDebugEnabled()) {
                    Log.w((String)TAG, (String)("Write " + uuid + " FAILED!"));
                }
                return false;
            }
        };
    }

    public BleGattExecutor.ServiceAction notify(final String uuid, final boolean start) {
        return new BleGattExecutor.ServiceAction(uuid, BleGattExecutor.ServiceAction.ActionType.NOTIFY){

            @Override
            public boolean execute(BluetoothGatt gatt) {
                UUID ccc = UUID.fromString(Sensor.CHARACTERISTIC_CONFIG);
                BluetoothGattCharacteristic characteristic = Sensor.this.getCharacteristic(gatt, uuid);
                if ((characteristic.getProperties() & 0x10) == 0) {
                    if (BleConfig.isDebugEnabled()) {
                        Log.w((String)TAG, (String)("Characteristic " + uuid + " can not provide notifications"));
                    }
                    return true;
                }
                BluetoothGattDescriptor config = characteristic.getDescriptor(ccc);
                if (config == null) {
                    if (BleConfig.isDebugEnabled()) {
                        Log.w((String)TAG, (String)("Characteristic " + uuid + " does not have notify descriptor"));
                    }
                    return true;
                }
                gatt.setCharacteristicNotification(characteristic, start);
                config.setValue(start ? BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE : BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
                boolean success = gatt.writeDescriptor(config);
                if (!success && BleConfig.isDebugEnabled()) {
                    Log.w((String)TAG, (String)("Notify " + uuid + " FAILED!"));
                }
                return false;
            }
        };
    }

    private BluetoothGattCharacteristic getCharacteristic(BluetoothGatt bluetoothGatt, String uuid) {
        UUID serviceUuid = UUID.fromString(this.getServiceUUID());
        UUID characteristicUuid = UUID.fromString(uuid);
        BluetoothGattService service = bluetoothGatt.getService(serviceUuid);
        return service.getCharacteristic(characteristicUuid);
    }
}

