/*
 * Decompiled with CFR 0.152.
 */
package com.chimeraiot.android.ble;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.ScanFilter;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.chimeraiot.android.ble.BleExecutorListener;
import com.chimeraiot.android.ble.BleGattExecutor;
import com.chimeraiot.android.ble.BluetoothStateReceiver;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class BleUtils {
    public static final int STATUS_BLE_ENABLED = 0;
    public static final int STATUS_BLUETOOTH_NOT_AVAILABLE = 1;
    public static final int STATUS_BLE_NOT_AVAILABLE = 2;
    public static final int STATUS_BLUETOOTH_DISABLED = 3;
    private static final byte[] SCAN_FILTER_SERVICE_UUID_MASK = new byte[]{0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};

    public static boolean api21() {
        return Build.VERSION.SDK_INT >= 21;
    }

    @Nullable
    public static ScanFilter getManufacturerDataFilter(String uuid) {
        if (!BleUtils.api21()) {
            return null;
        }
        byte[] manData = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        System.arraycopy(BleUtils.hexStringToByteArray(uuid.replace("-", "")), 0, manData, 2, 16);
        return new ScanFilter.Builder().setManufacturerData(76, manData, SCAN_FILTER_SERVICE_UUID_MASK).build();
    }

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    private BleUtils() {
    }

    @Nullable
    public static BluetoothAdapter getBluetoothAdapter(Context context) {
        BluetoothManager bluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
        if (bluetoothManager == null) {
            return null;
        }
        return bluetoothManager.getAdapter();
    }

    public static int getBleStatus(Context context) {
        if (!context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            return 2;
        }
        BluetoothAdapter adapter = BleUtils.getBluetoothAdapter(context);
        if (adapter == null) {
            return 1;
        }
        if (!adapter.isEnabled()) {
            return 3;
        }
        return 0;
    }

    public static void setBluetoothEnabled(Context context, boolean enabled) {
        BluetoothAdapter bluetoothAdapter = BleUtils.getBluetoothAdapter(context);
        if (bluetoothAdapter != null) {
            if (enabled) {
                bluetoothAdapter.enable();
            } else {
                bluetoothAdapter.disable();
            }
        }
    }

    public static void restartBluetooth(final Context context) {
        final BluetoothAdapter bluetoothAdapter = BleUtils.getBluetoothAdapter(context);
        if (bluetoothAdapter == null) {
            return;
        }
        boolean isEnabled = bluetoothAdapter.isEnabled();
        if (!isEnabled) {
            bluetoothAdapter.enable();
        } else {
            BluetoothStateReceiver receiver = new BluetoothStateReceiver(){

                @Override
                public void onBluetoothStateChanged(int state) {
                    if (state == 10) {
                        bluetoothAdapter.enable();
                        this.unregister(context);
                    }
                }
            };
            receiver.register(context);
            bluetoothAdapter.disable();
        }
    }

    public static BleGattExecutor createExecutor(final @NonNull BleExecutorListener listener) {
        return new BleGattExecutor(){

            @Override
            public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
                super.onConnectionStateChange(gatt, status, newState);
                listener.onConnectionStateChange(gatt, status, newState);
            }

            @Override
            public void onServicesDiscovered(BluetoothGatt gatt, int status) {
                super.onServicesDiscovered(gatt, status);
                listener.onServicesDiscovered(gatt, status);
            }

            @Override
            public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
                super.onCharacteristicRead(gatt, characteristic, status);
                listener.onCharacteristicRead(gatt, characteristic, status);
            }

            public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
                super.onCharacteristicChanged(gatt, characteristic);
                listener.onCharacteristicChanged(gatt, characteristic);
            }
        };
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BleStatus {
    }
}

