/*
 * Decompiled with CFR 0.152.
 */
package com.chimeraiot.android.ble;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import com.chimeraiot.android.ble.BleManager;
import com.chimeraiot.android.ble.BleServiceListener;

public abstract class BleService
extends Service
implements BleServiceListener {
    private static final String TAG = BleService.class.getSimpleName();
    private final IBinder binder = new LocalBinder();
    private final ServiceConnectionProxy uiThreadProxy = new ServiceConnectionProxy();
    private BleManager bleManager;

    public void onCreate() {
        super.onCreate();
        this.bleManager = this.createBleManager();
        this.bleManager.registerListener(this);
    }

    protected abstract BleManager createBleManager();

    public IBinder onBind(Intent intent) {
        return this.binder;
    }

    public void onDestroy() {
        super.onDestroy();
        this.bleManager.unregisterListener(this);
        this.bleManager.disconnect();
        this.bleManager.close();
    }

    public BleManager getBleManager() {
        return this.bleManager;
    }

    public void setServiceListener(BleServiceListener listener) {
        this.uiThreadProxy.setServiceListener(listener);
    }

    @Override
    public void onConnected(String name, String address) {
        Message msg = this.uiThreadProxy.get(0, name, address);
        this.uiThreadProxy.sendMessage(msg);
    }

    @Override
    public void onConnectionFailed(String name, String address, int status, int state) {
        Message msg = this.uiThreadProxy.get(1, name, address);
        msg.arg1 = status;
        msg.arg2 = state;
        this.uiThreadProxy.sendMessage(msg);
    }

    @Override
    public void onDisconnected(String name, String address) {
        Message msg = this.uiThreadProxy.get(2, name, address);
        this.uiThreadProxy.sendMessage(msg);
    }

    @Override
    public void onServiceDiscovered(String name, String address) {
        Message msg = this.uiThreadProxy.get(3, name, address);
        this.uiThreadProxy.sendMessage(msg);
    }

    @Override
    public void onCharacteristicChanged(String name, String address, String serviceUuid, String characteristicUuid) {
        Message msg = this.uiThreadProxy.get(4, name, address);
        msg.getData().putString("uuid:service", serviceUuid);
        msg.getData().putString("uuid:characteristic", characteristicUuid);
        this.uiThreadProxy.sendMessage(msg);
    }

    private static class ServiceConnectionProxy
    extends Handler {
        static final int MSG_CONNECTED = 0;
        static final int MSG_CONNECTION_FAILED = 1;
        static final int MSG_DISCONNECTED = 2;
        static final int MSG_SERVICE_DISCOVERED = 3;
        static final int MSG_CHARACTERISTIC_CHANGED = 4;
        static final String ARG_NAME = "device:name";
        static final String ARG_ADDRESS = "device:address";
        static final String ARG_SERVICE_UUID = "uuid:service";
        static final String ARG_CHARACTERISTICS_UUID = "uuid:characteristic";
        private BleServiceListener serviceListener;

        ServiceConnectionProxy() {
            super(Looper.getMainLooper());
        }

        public void setServiceListener(BleServiceListener listener) {
            this.serviceListener = listener;
        }

        public Message get(int msgId, String name, String address) {
            Message msg = this.obtainMessage(msgId);
            Bundle data = msg.getData();
            if (data == null) {
                data = new Bundle();
            } else {
                data.clear();
            }
            data.putString(ARG_NAME, name);
            data.putString(ARG_ADDRESS, address);
            msg.setData(data);
            return msg;
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (this.serviceListener == null) {
                return;
            }
            Bundle data = msg.getData();
            String name = data.getString(ARG_NAME);
            String address = data.getString(ARG_ADDRESS);
            switch (msg.what) {
                case 0: {
                    this.serviceListener.onConnected(name, address);
                    break;
                }
                case 1: {
                    this.serviceListener.onConnectionFailed(name, address, msg.arg1, msg.arg2);
                    break;
                }
                case 2: {
                    this.serviceListener.onDisconnected(name, address);
                    break;
                }
                case 3: {
                    this.serviceListener.onServiceDiscovered(name, address);
                    break;
                }
                case 4: {
                    String serviceUuid = msg.getData().getString(ARG_SERVICE_UUID);
                    String characteristicUuid = msg.getData().getString(ARG_CHARACTERISTICS_UUID);
                    this.serviceListener.onCharacteristicChanged(name, address, serviceUuid, characteristicUuid);
                    break;
                }
            }
        }
    }

    public class LocalBinder
    extends Binder {
        public BleService getService() {
            return BleService.this;
        }
    }
}

