/*
 * Decompiled with CFR 0.152.
 */
package com.chimeraiot.android.ble.sensor;

import android.bluetooth.BluetoothGattCharacteristic;

public final class SensorUtils {
    private static final int BITS_IN_BYTE = 8;
    private static final int UNSIGNED_MASK = 255;

    private SensorUtils() {
    }

    public static Integer int16(BluetoothGattCharacteristic c, int offset) {
        Integer lowerByte = c.getIntValue(17, offset);
        if (lowerByte == null) {
            return 0;
        }
        Integer upperByte = c.getIntValue(33, offset + 1);
        if (upperByte == null) {
            return 0;
        }
        return (upperByte << 8) + lowerByte;
    }

    public static Integer uint16(BluetoothGattCharacteristic c, int offset) {
        Integer lowerByte = c.getIntValue(17, offset);
        if (lowerByte == null) {
            return 0;
        }
        Integer upperByte = c.getIntValue(17, offset + 1);
        if (upperByte == null) {
            return 0;
        }
        return (upperByte << 8) + lowerByte;
    }

    public static int uint8(BluetoothGattCharacteristic c, int offset) {
        Integer value = c.getIntValue(17, offset);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public static byte toUint8(int value) {
        return (byte)(value & 0xFF);
    }

    public static byte[] toUint16(int value) {
        return new byte[]{SensorUtils.toUint8(value), SensorUtils.toUint8(value >> 8)};
    }
}

