/*
 * Decompiled with CFR 0.152.
 */
package com.chimeraiot.android.ble;

import android.bluetooth.BluetoothAdapter;
import com.chimeraiot.android.ble.BleScanner;
import java.util.Collection;
import java.util.Collections;

class BleScannerPreLollipop
implements Runnable,
BleScanner {
    private static final String TAG = BleScannerPreLollipop.class.getSimpleName();
    private final BluetoothAdapter bluetoothAdapter;
    private long scanPeriod = 3000L;
    private Thread scanThread;
    private volatile boolean isScanning = false;
    private BleScanner.BleDevicesScannerListener listener;

    public BleScannerPreLollipop(BluetoothAdapter adapter, BleScanner.BleDevicesScannerListener listener) {
        if (adapter == null) {
            throw new IllegalArgumentException("Adapter should not be null");
        }
        this.listener = listener;
        this.bluetoothAdapter = adapter;
    }

    @Override
    public synchronized void setScanPeriod(long scanPeriod) {
        this.scanPeriod = scanPeriod < 0L ? -1L : scanPeriod;
    }

    @Override
    public void setScanMode(int scanMode) {
    }

    @Override
    public boolean isScanning() {
        return this.scanThread != null && this.scanThread.isAlive();
    }

    @Override
    public synchronized void start() {
        this.start(Collections.emptyList());
    }

    @Override
    public synchronized void start(Collection<String> filter) {
        if (this.isScanning()) {
            return;
        }
        if (this.scanThread != null) {
            this.scanThread.interrupt();
        }
        this.scanThread = new Thread(this);
        this.scanThread.setName(TAG);
        this.scanThread.start();
    }

    @Override
    public synchronized void stop() {
        this.isScanning = false;
        if (this.scanThread != null) {
            this.scanThread.interrupt();
            this.scanThread = null;
        }
        this.bluetoothAdapter.stopLeScan((BluetoothAdapter.LeScanCallback)this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BleScannerPreLollipop bleScannerPreLollipop;
        try {
            this.isScanning = true;
            this.listener.onScanStarted();
            do {
                bleScannerPreLollipop = this;
                synchronized (bleScannerPreLollipop) {
                    this.bluetoothAdapter.startLeScan((BluetoothAdapter.LeScanCallback)this.listener);
                }
                if (this.scanPeriod > 0L) {
                    Thread.sleep(this.scanPeriod);
                } else {
                    Thread.sleep(3000L);
                }
                bleScannerPreLollipop = this;
                synchronized (bleScannerPreLollipop) {
                    this.bluetoothAdapter.startLeScan((BluetoothAdapter.LeScanCallback)this.listener);
                }
                if (this.scanPeriod <= 0L) continue;
                this.listener.onScanRepeat();
            } while (this.isScanning && this.scanPeriod > 0L);
        }
        catch (InterruptedException interruptedException) {
            BleScannerPreLollipop bleScannerPreLollipop2 = this;
            synchronized (bleScannerPreLollipop2) {
                this.bluetoothAdapter.startLeScan((BluetoothAdapter.LeScanCallback)this.listener);
            }
        }
        finally {
            bleScannerPreLollipop = this;
            synchronized (bleScannerPreLollipop) {
                this.bluetoothAdapter.startLeScan((BluetoothAdapter.LeScanCallback)this.listener);
            }
        }
        this.listener.onScanStopped();
    }
}

