/*
 * Decompiled with CFR 0.152.
 */
package com.chimeraiot.android.ble;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import com.chimeraiot.android.ble.BleScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@TargetApi(value=21)
public class BleScannerLollipop
extends ScanCallback
implements Runnable,
BleScanner {
    private static final String TAG = BleScannerLollipop.class.getSimpleName();
    private final BluetoothAdapter bluetoothAdapter;
    private long scanPeriod = 3000L;
    private int scanMode = 2;
    private List<ScanFilter> filter = new ArrayList<ScanFilter>();
    private Thread scanThread;
    private volatile boolean isScanning = false;
    private BleScanner.BleDevicesScannerListener listener;

    public BleScannerLollipop(BluetoothAdapter adapter, BleScanner.BleDevicesScannerListener listener) {
        if (adapter == null) {
            throw new IllegalArgumentException("Adapter should not be null");
        }
        this.listener = listener;
        this.bluetoothAdapter = adapter;
    }

    @Override
    public synchronized void setScanPeriod(long scanPeriod) {
        this.scanPeriod = scanPeriod < 0L ? -1L : scanPeriod;
    }

    @Override
    public void setScanMode(int scanMode) {
        this.scanMode = scanMode;
    }

    @Override
    public boolean isScanning() {
        return this.scanThread != null && this.scanThread.isAlive();
    }

    @Override
    public synchronized void start() {
        this.start(Collections.emptyList());
    }

    @Override
    public synchronized void start(Collection<String> filter) {
        if (this.isScanning()) {
            return;
        }
        this.filter.clear();
        for (String name : filter) {
            this.filter.add(new ScanFilter.Builder().setDeviceName(name).build());
        }
        if (this.scanThread != null) {
            this.scanThread.interrupt();
        }
        this.scanThread = new Thread(this);
        this.scanThread.setName(TAG);
        this.scanThread.start();
    }

    @Override
    public synchronized void stop() {
        this.isScanning = false;
        if (this.scanThread != null) {
            this.scanThread.interrupt();
            this.scanThread = null;
        }
        this.stopScanner();
    }

    private synchronized void stopScanner() {
        BluetoothLeScanner scanner = this.bluetoothAdapter.getBluetoothLeScanner();
        if (scanner != null) {
            scanner.stopScan((ScanCallback)this);
        }
    }

    public void onScanResult(int callbackType, ScanResult result) {
        super.onScanResult(callbackType, result);
        byte[] bytes = result.getScanRecord() != null ? result.getScanRecord().getBytes() : null;
        this.listener.onLeScan(result.getDevice(), result.getRssi(), bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetApi(value=21)
    public void run() {
        try {
            this.isScanning = true;
            this.listener.onScanStarted();
            do {
                BleScannerLollipop bleScannerLollipop = this;
                synchronized (bleScannerLollipop) {
                    ScanSettings settings = new ScanSettings.Builder().setScanMode(this.scanMode).build();
                    BluetoothLeScanner scanner = this.bluetoothAdapter.getBluetoothLeScanner();
                    if (scanner != null) {
                        scanner.startScan(this.filter, settings, (ScanCallback)this);
                    }
                }
                if (this.scanPeriod > 0L) {
                    Thread.sleep(this.scanPeriod);
                } else {
                    Thread.sleep(3000L);
                }
                this.stopScanner();
                if (this.scanPeriod <= 0L) continue;
                this.listener.onScanRepeat();
            } while (this.isScanning && this.scanPeriod > 0L);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.stopScanner();
        }
        this.listener.onScanStopped();
    }
}

