/*
 * Decompiled with CFR 0.152.
 */
package com.chimeraiot.android.ble;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.os.Bundle;
import com.chimeraiot.android.ble.BleExecutorListener;
import com.chimeraiot.android.ble.BleGattExecutor;
import com.chimeraiot.android.ble.BleServiceListener;
import com.chimeraiot.android.ble.BleUtils;
import com.chimeraiot.android.ble.sensor.DeviceDef;
import com.chimeraiot.android.ble.sensor.DeviceDefCollection;
import com.chimeraiot.android.ble.sensor.Sensor;
import com.chimeraiot.android.ble.utils.WeakSetUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BleManager
implements BleExecutorListener {
    private static final String TAG = BleManager.class.getSimpleName();
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_READY = 3;
    private final DeviceDefCollection devices;
    private final BleGattExecutor executor = BleUtils.createExecutor(this);
    private BluetoothAdapter adapter;
    private Map<String, BluetoothGatt> gattMap = new HashMap<String, BluetoothGatt>();
    private final Set<String> connectedDevices = new HashSet<String>();
    private int connectionState = 0;
    private final Set<WeakReference<BleServiceListener>> serviceListeners = WeakSetUtils.newWeakSet();

    public BleManager(DeviceDefCollection devices) {
        this.devices = devices;
    }

    public DeviceDefCollection getDeviceDefCollection() {
        return this.devices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(BleServiceListener listener) {
        Set<WeakReference<BleServiceListener>> set = this.serviceListeners;
        synchronized (set) {
            WeakSetUtils.add(this.serviceListeners, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(BleServiceListener listener) {
        Set<WeakReference<BleServiceListener>> set = this.serviceListeners;
        synchronized (set) {
            WeakSetUtils.remove(this.serviceListeners, listener);
        }
    }

    public List<BluetoothDevice> getConnectedDevices() {
        ArrayList<BluetoothDevice> result = new ArrayList<BluetoothDevice>(this.gattMap.size());
        for (BluetoothGatt gatt : this.gattMap.values()) {
            result.add(gatt.getDevice());
        }
        return result;
    }

    public int getConnectionState() {
        return this.connectionState;
    }

    public boolean isReady() {
        return this.connectionState == 3;
    }

    public boolean initialize(Context context) {
        if (this.adapter == null) {
            this.adapter = BleUtils.getBluetoothAdapter(context);
        }
        return this.adapter != null && this.adapter.isEnabled();
    }

    public boolean connect(Context context, String address) {
        if (this.adapter == null || address == null) {
            return false;
        }
        if (this.connectedDevices.contains(address) && this.gattMap.containsKey(address)) {
            if (this.gattMap.get(address).connect()) {
                this.connectionState = 1;
                return true;
            }
            return false;
        }
        BluetoothDevice device = this.adapter.getRemoteDevice(address);
        BluetoothGatt gatt = device.connectGatt(context, false, (BluetoothGattCallback)this.executor);
        this.gattMap.put(address, gatt);
        this.connectedDevices.add(address);
        this.connectionState = 1;
        return true;
    }

    public void disconnect() {
        this.connectedDevices.clear();
        for (BluetoothGatt gatt : this.gattMap.values()) {
            if (gatt == null) continue;
            gatt.disconnect();
        }
    }

    public void close() {
        this.connectedDevices.clear();
        for (BluetoothGatt gatt : this.gattMap.values()) {
            if (gatt == null) continue;
            gatt.close();
        }
        this.gattMap.clear();
    }

    public List<BluetoothGattService> getSupportedGattServices(String address) {
        if (!this.gattMap.containsKey(address)) {
            return null;
        }
        return this.gattMap.get(address).getServices();
    }

    public void update(String address, Sensor<?> sensor, String uuid, Bundle data) {
        if (sensor == null) {
            return;
        }
        if (!this.gattMap.containsKey(address)) {
            return;
        }
        this.executor.update(sensor, uuid, data);
        if (this.isReady()) {
            this.executor.execute(this.gattMap.get(address));
        }
    }

    public void listen(String address, Sensor<?> sensor, String uuid) {
        if (sensor == null) {
            return;
        }
        if (!this.gattMap.containsKey(address)) {
            return;
        }
        this.executor.notify(sensor, uuid, true);
        if (this.isReady()) {
            this.executor.execute(this.gattMap.get(address));
        }
    }

    public void read(String address, Sensor<?> sensor, String uuid) {
        if (sensor == null) {
            return;
        }
        if (!this.gattMap.containsKey(address)) {
            return;
        }
        this.executor.read(sensor, uuid);
        if (this.isReady()) {
            this.executor.execute(this.gattMap.get(address));
        }
    }

    @Override
    public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
        if (status != 0) {
            return;
        }
        String name = gatt.getDevice().getName();
        String address = gatt.getDevice().getAddress();
        Set<WeakReference<BleServiceListener>> listeners = this.cloneListeners();
        switch (newState) {
            case 2: {
                this.connectionState = 2;
                boolean discoveryResult = gatt.discoverServices();
                for (WeakReference<BleServiceListener> r : listeners) {
                    BleServiceListener listener = (BleServiceListener)r.get();
                    if (listener == null) continue;
                    listener.onConnected(name, address);
                }
                break;
            }
            case 0: {
                this.connectionState = 0;
                for (WeakReference<BleServiceListener> r : listeners) {
                    BleServiceListener listener = (BleServiceListener)r.get();
                    if (listener == null) continue;
                    listener.onDisconnected(name, address);
                }
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    @Override
    public void onServicesDiscovered(BluetoothGatt gatt, int status) {
        if (status == 0) {
            this.connectionState = 3;
            String name = gatt.getDevice().getName();
            String address = gatt.getDevice().getAddress();
            Set<WeakReference<BleServiceListener>> listeners = this.cloneListeners();
            for (WeakReference<BleServiceListener> r : listeners) {
                BleServiceListener listener = (BleServiceListener)r.get();
                if (listener == null) continue;
                listener.onServiceDiscovered(name, address);
            }
        }
    }

    private static String readableProperties(int properties) {
        StringBuilder builder = new StringBuilder();
        if ((properties & 2) != 0) {
            builder.append("READ");
        }
        if ((properties & 8) != 0) {
            if (builder.length() > 0) {
                builder.append(" | ");
            }
            builder.append("WRITE");
        }
        if ((properties & 0x10) != 0) {
            if (builder.length() > 0) {
                builder.append(" | ");
            }
            builder.append("NOTIFY");
        }
        return builder.toString();
    }

    @Override
    public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
        String address;
        if (status != 0) {
            return;
        }
        String name = gatt.getDevice().getName();
        DeviceDef deviceDef = this.devices.get(name, address = gatt.getDevice().getAddress());
        if (deviceDef == null) {
            return;
        }
        Sensor sensor = deviceDef.getSensor(characteristic.getService().getUuid().toString());
        if (sensor != null && !sensor.onCharacteristicRead(characteristic)) {
            return;
        }
        this.notifyUpdate(name, address, characteristic);
    }

    @Override
    public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
        String address;
        String name = gatt.getDevice().getName();
        DeviceDef deviceDef = this.devices.get(name, address = gatt.getDevice().getAddress());
        if (deviceDef == null) {
            return;
        }
        Sensor sensor = deviceDef.getSensor(characteristic.getService().getUuid().toString());
        if (sensor != null && !sensor.onCharacteristicChanged(characteristic)) {
            return;
        }
        this.notifyUpdate(name, address, characteristic);
    }

    private void notifyUpdate(String name, String address, BluetoothGattCharacteristic characteristic) {
        String serviceUuid = characteristic.getService().getUuid().toString();
        String characteristicUuid = characteristic.getUuid().toString();
        Set<WeakReference<BleServiceListener>> listeners = this.cloneListeners();
        for (WeakReference<BleServiceListener> r : listeners) {
            BleServiceListener listener = (BleServiceListener)r.get();
            if (listener == null) continue;
            listener.onCharacteristicChanged(name, address, serviceUuid, characteristicUuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<WeakReference<BleServiceListener>> cloneListeners() {
        Set<WeakReference<BleServiceListener>> set = this.serviceListeners;
        synchronized (set) {
            return new HashSet<WeakReference<BleServiceListener>>(this.serviceListeners);
        }
    }
}

