/*
 * Decompiled with CFR 0.152.
 */
package com.chimeraiot.android.ble;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.os.Bundle;
import com.chimeraiot.android.ble.sensor.Sensor;
import java.util.LinkedList;

public class BleGattExecutor
extends BluetoothGattCallback {
    private static final String TAG = BleGattExecutor.class.getSimpleName();
    private final LinkedList<ServiceAction> queue = new LinkedList();
    private volatile ServiceAction currentAction;

    public void read(Sensor sensor, String uuid) {
        this.add(sensor.read(uuid));
    }

    public void update(Sensor sensor, String uuid, Bundle bundle) {
        for (ServiceAction action : sensor.update(uuid, bundle)) {
            this.add(action);
        }
    }

    public void notify(Sensor sensor, String uuid, boolean start) {
        this.add(sensor.notify(uuid, start));
    }

    public synchronized void execute(BluetoothGatt gatt) {
        if (this.currentAction != null) {
            return;
        }
        while (!this.queue.isEmpty()) {
            ServiceAction action;
            this.currentAction = action = this.queue.pop();
            if (!action.execute(gatt)) break;
            this.currentAction = null;
        }
    }

    public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
        super.onDescriptorWrite(gatt, descriptor, status);
        if (this.waitForWrite()) {
            return;
        }
        this.checkAndRetry(status);
        this.execute(gatt);
    }

    public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
        super.onCharacteristicWrite(gatt, characteristic, status);
        this.checkAndRetry(status);
        this.execute(gatt);
    }

    public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
        super.onCharacteristicRead(gatt, characteristic, status);
        if (this.waitForWrite()) {
            return;
        }
        this.checkAndRetry(status);
        this.execute(gatt);
    }

    public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
        super.onConnectionStateChange(gatt, status, newState);
        if (newState == 0) {
            this.checkAndRetry(257);
        }
    }

    public void onServicesDiscovered(BluetoothGatt gatt, int status) {
        super.onServicesDiscovered(gatt, status);
        this.execute(gatt);
    }

    private synchronized void add(ServiceAction action) {
        if (!action.equals(this.currentAction) && !this.queue.contains(action)) {
            this.queue.add(action);
        }
    }

    private synchronized void checkAndRetry(int status) {
        if (this.currentAction == null) {
            return;
        }
        if (status != 0) {
            this.queue.addFirst(this.currentAction);
        }
        this.currentAction = null;
    }

    private synchronized boolean waitForWrite() {
        return this.currentAction != null && this.currentAction.getType() == ServiceAction.ActionType.WRITE;
    }

    public static abstract class ServiceAction {
        public static final ServiceAction VOID = new ServiceAction("", ActionType.NONE){

            @Override
            public boolean execute(BluetoothGatt gatt) {
                return true;
            }
        };
        private final String uuid;
        private final ActionType type;

        public ServiceAction(String uuid, ActionType type) {
            this.type = type;
            this.uuid = uuid;
        }

        public ActionType getType() {
            return this.type;
        }

        public String getUuid() {
            return this.uuid;
        }

        public abstract boolean execute(BluetoothGatt var1);

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!o.getClass().equals(this.getClass())) {
                return false;
            }
            ServiceAction v = (ServiceAction)o;
            return v.uuid.equals(this.uuid) && v.type == this.type;
        }

        public int hashCode() {
            return this.uuid.hashCode();
        }

        public String toString() {
            return this.uuid + "   " + this.type.name();
        }

        public static enum ActionType {
            NONE,
            READ,
            NOTIFY,
            WRITE;

        }
    }
}

