/*
 * Decompiled with CFR 0.152.
 */
package com.chimeraiot.android.ble.sensor;

import com.chimeraiot.android.ble.sensor.DeviceDef;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public abstract class DeviceDefCollection {
    private final Set<String> supportedDevices = new HashSet<String>();
    private final HashMap<String, DeviceDef> devicesMap = new HashMap();

    public void register(String name) {
        this.supportedDevices.add(name);
    }

    public Set<String> getSupportedDevices() {
        return Collections.unmodifiableSet(this.supportedDevices);
    }

    public boolean isSupported(String name) {
        return this.supportedDevices.contains(name);
    }

    public DeviceDef get(String name, String address) {
        if (!this.devicesMap.containsKey(address)) {
            DeviceDef deviceDef = this.create(name, address);
            if (deviceDef == null) {
                return null;
            }
            this.devicesMap.put(address, deviceDef);
            return deviceDef;
        }
        return this.devicesMap.get(address);
    }

    public abstract DeviceDef create(String var1, String var2);
}

