/*
 * Decompiled with CFR 0.152.
 */
package com.chimeraiot.android.ble;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import com.chimeraiot.android.ble.BleManager;
import com.chimeraiot.android.ble.BleService;
import com.chimeraiot.android.ble.BleServiceListener;

public class BleServiceBindingActivity
extends Activity
implements BleServiceListener,
ServiceConnection {
    private static final String TAG = BleServiceBindingActivity.class.getSimpleName();
    public static final String EXTRAS_DEVICE_NAME = TAG + ":DEVICE_NAME";
    public static final String EXTRAS_DEVICE_ADDRESS = TAG + ":DEVICE_ADDRESS";
    private String deviceName;
    private String deviceAddress;
    private BleService bleService;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        this.deviceName = intent.getStringExtra(EXTRAS_DEVICE_NAME);
        this.deviceAddress = intent.getStringExtra(EXTRAS_DEVICE_ADDRESS);
    }

    protected void onStart() {
        super.onStart();
        Class<? extends BleService> serviceClass = this.getServiceClass();
        if (serviceClass == null) {
            throw new NullPointerException("Please specify service class");
        }
        Intent gattServiceIntent = new Intent((Context)this, serviceClass);
        this.bindService(gattServiceIntent, this, 1);
    }

    protected void onStop() {
        super.onStop();
        this.getBleManager().disconnect();
        this.getBleManager().close();
        this.unbindService(this);
    }

    public Class<? extends BleService> getServiceClass() {
        return null;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getDeviceAddress() {
        return this.deviceAddress;
    }

    public BleManager getBleManager() {
        return this.bleService.getBleManager();
    }

    @Override
    public void onConnected(String name, String address) {
    }

    @Override
    public void onDisconnected(String name, String address) {
    }

    @Override
    public void onServiceDiscovered(String name, String address) {
    }

    @Override
    public void onCharacteristicChanged(String name, String address, String serviceUuid, String characteristicUuid) {
    }

    public void onServiceConnected(ComponentName name, IBinder service) {
        this.bleService = ((BleService.LocalBinder)service).getService();
        this.bleService.setServiceListener(this);
        if (!this.getBleManager().initialize(this.getBaseContext())) {
            this.finish();
            return;
        }
        this.getBleManager().connect(this.getBaseContext(), this.deviceAddress);
    }

    public void onServiceDisconnected(ComponentName name) {
        this.bleService = null;
    }

    protected boolean isServiceConnected() {
        return this.bleService != null;
    }
}

