/*
 * Decompiled with CFR 0.152.
 */
package com.chimeraiot.android.ble;

import android.bluetooth.BluetoothAdapter;
import android.os.Build;
import com.chimeraiot.android.ble.BleScanner;
import com.chimeraiot.android.ble.BleScannerLollipop;
import com.chimeraiot.android.ble.BleScannerPreLollipop;
import java.util.Collection;

public class BleScanCompat
implements BleScanner {
    private final BleScanner impl;

    public BleScanCompat(BluetoothAdapter adapter, BleScanner.BleDevicesScannerListener listener) {
        if (adapter == null) {
            throw new IllegalArgumentException("Adapter should not be null");
        }
        this.impl = Build.VERSION.SDK_INT >= 21 ? new BleScannerLollipop(adapter, listener) : new BleScannerPreLollipop(adapter, listener);
    }

    @Override
    public void setScanPeriod(long scanPeriod) {
        this.impl.setScanPeriod(scanPeriod);
    }

    @Override
    public boolean isScanning() {
        return this.impl.isScanning();
    }

    @Override
    public void start() {
        this.impl.start();
    }

    @Override
    public void start(Collection<String> filter) {
        this.impl.start(filter);
    }

    @Override
    public void stop() {
        this.impl.stop();
    }
}

