/*
 * Copyright (c) 2015 Chimera IoT
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.chimeraiot.android.ble;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;

import java.util.Collection;

/** BLE device scanner. */
public interface BleScanner {

    void setScanPeriod(long scanPeriod);

    boolean isScanning();

    void start();

    void start(Collection<String> filter);

    void stop();

    /** BLE devices scanner listener. */
    interface BleDevicesScannerListener extends BluetoothAdapter.LeScanCallback {
        /** Notifies that scan process started.
         * <br/><strong>Executed on not-UI thread.</strong> */
        void onScanStarted();
        /** Notifies that scan started next iteration.
         * <br/><strong>Executed on not-UI thread.</strong> */
        void onScanRepeat();
        /** Notifies that scan process stopped.
         * <br/><strong>Executed on not-UI thread.</strong> */
        void onScanStopped();

        /** Notifies that device has been found.
         * <br/><strong>Executed on not-UI thread.</strong> */
        @Override
        void onLeScan(BluetoothDevice device, int i, byte[] bytes);
    }

}
