/*
 * Copyright (c) 2015 Chimera IoT
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.chimeraiot.android.ble;

import android.bluetooth.BluetoothAdapter;
import android.os.Build;

import java.util.Collection;

/**  */
public class BleScanCompat implements BleScanner {
    /** Compat implementation. */
    private final BleScanner impl;

    public BleScanCompat(BluetoothAdapter adapter, BleDevicesScannerListener listener) {
        if (adapter == null) {
            throw new IllegalArgumentException("Adapter should not be null");
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            impl = new BleScannerLollipop(adapter, listener);
        } else {
            impl = new BleScannerPreLollipop(adapter, listener);
        }
    }

    @Override
    public void setScanPeriod(final long scanPeriod) {
        impl.setScanPeriod(scanPeriod);
    }

    @Override
    public boolean isScanning() {
        return impl.isScanning();
    }

    @Override
    public void start() {
        impl.start();
    }

    @Override
    public void start(final Collection<String> filter) {
        impl.start(filter);
    }

    @Override
    public void stop() {
        impl.stop();
    }

}
