/*
 * Decompiled with CFR 0.152.
 */
package com.childcare.common;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import com.childcare.common.R;

public class CouponView
extends FrameLayout {
    private Paint mPaint;
    private float mRadius;
    private float mPercent;
    private int mTriangleCount;
    private float mOffset;
    private int mAccentColor;
    private int mDecentColor;
    private int mContentColor;

    public CouponView(Context context) {
        this(context, null);
    }

    public CouponView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CouponView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CouponView, 0, 0);
        this.mAccentColor = a.getColor(R.styleable.CouponView_couponAccentColor, ContextCompat.getColor((Context)context, (int)R.color.orange));
        this.mDecentColor = a.getColor(R.styleable.CouponView_couponDecentColor, ContextCompat.getColor((Context)context, (int)R.color.grey));
        this.mContentColor = a.getColor(R.styleable.CouponView_couponContentColor, ContextCompat.getColor((Context)context, (int)R.color.white));
        this.mRadius = a.getDimension(R.styleable.CouponView_couponRadius, 16.0f);
        this.mPercent = a.getFloat(R.styleable.CouponView_couponPercent, 0.7f);
        a.recycle();
        this.mPaint = new Paint(1);
        this.setBackgroundColor(0);
    }

    private void setDecentPaint() {
        this.mPaint.setColor(this.mDecentColor);
    }

    private void setAccentPaint() {
        this.mPaint.setColor(this.mAccentColor);
    }

    private void setContentPaint() {
        this.mPaint.setColor(this.mContentColor);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mTriangleCount = (int)(((float)h - 2.0f * this.mRadius) / this.mRadius);
        this.mOffset = ((float)h - 2.0f * this.mRadius) % this.mRadius / (float)this.mTriangleCount;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float x = this.mPercent * (float)this.getWidth();
        this.drawRoundRectLeft(canvas, x);
        this.drawRoundRectRight(canvas, x);
        this.drawCircles(canvas, x);
        this.drawTriangles(canvas, x);
    }

    private void drawTriangles(Canvas canvas, float x) {
        this.setAccentPaint();
        for (int i = 0; i < this.mTriangleCount; ++i) {
            canvas.drawPath(this.calculateTriangle(x, this.mRadius + (float)i * (this.mRadius + this.mOffset)), this.mPaint);
        }
    }

    private Path calculateTriangle(float firstPointX, float startPointY) {
        Path path = new Path();
        path.moveTo(firstPointX, startPointY);
        path.lineTo(firstPointX, startPointY + this.mRadius);
        path.lineTo(firstPointX - this.mRadius / 2.0f, startPointY + this.mRadius / 2.0f);
        path.close();
        return path;
    }

    private void drawRoundRectRight(Canvas canvas, float x) {
        this.setAccentPaint();
        canvas.drawRoundRect(new RectF(x, 0.0f, (float)this.getWidth(), (float)this.getHeight()), this.mRadius, this.mRadius, this.mPaint);
    }

    private void drawRoundRectLeft(Canvas canvas, float x) {
        this.setContentPaint();
        canvas.drawRoundRect(new RectF(0.0f, 0.0f, x, (float)this.getHeight()), this.mRadius, this.mRadius, this.mPaint);
    }

    private void drawCircles(Canvas canvas, float x) {
        this.setDecentPaint();
        canvas.drawCircle(x, 0.0f, this.mRadius, this.mPaint);
        canvas.drawCircle(x, (float)this.getHeight(), this.mRadius, this.mPaint);
    }

    public void setAccentColor(int accentColor) {
        this.mAccentColor = accentColor;
        this.invalidate();
    }
}

