/*
 * Decompiled with CFR 0.152.
 */
package com.chibde.visualizer;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.chibde.BaseVisualizer;

public class CircleBarVisualizer
extends BaseVisualizer {
    private float[] points;
    private Paint circlePaint;
    private int radius;

    public CircleBarVisualizer(Context context) {
        super(context);
    }

    public CircleBarVisualizer(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CircleBarVisualizer(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init() {
        this.paint.setStyle(Paint.Style.STROKE);
        this.circlePaint = new Paint();
        this.radius = -1;
    }

    protected void onDraw(Canvas canvas) {
        if (this.radius == -1) {
            this.radius = this.getHeight() < this.getWidth() ? this.getHeight() : this.getWidth();
            this.radius = (int)((double)this.radius * 0.65 / 2.0);
            double circumference = Math.PI * 2 * (double)this.radius;
            this.paint.setStrokeWidth((float)(circumference / 120.0));
            this.circlePaint.setStyle(Paint.Style.STROKE);
            this.circlePaint.setStrokeWidth(4.0f);
        }
        this.circlePaint.setColor(this.color);
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), (float)this.radius, this.circlePaint);
        if (this.bytes != null) {
            if (this.points == null || this.points.length < this.bytes.length * 4) {
                this.points = new float[this.bytes.length * 4];
            }
            double angle = 0.0;
            int i = 0;
            while (i < 120) {
                int x = (int)Math.ceil((double)i * 8.5);
                int t = (byte)(-Math.abs(this.bytes[x]) + 128) * (canvas.getHeight() / 4) / 128;
                this.points[i * 4] = (float)((double)(this.getWidth() / 2) + (double)this.radius * Math.cos(Math.toRadians(angle)));
                this.points[i * 4 + 1] = (float)((double)(this.getHeight() / 2) + (double)this.radius * Math.sin(Math.toRadians(angle)));
                this.points[i * 4 + 2] = (float)((double)(this.getWidth() / 2) + (double)(this.radius + t) * Math.cos(Math.toRadians(angle)));
                this.points[i * 4 + 3] = (float)((double)(this.getHeight() / 2) + (double)(this.radius + t) * Math.sin(Math.toRadians(angle)));
                ++i;
                angle += 3.0;
            }
            canvas.drawLines(this.points, this.paint);
        }
        super.onDraw(canvas);
    }
}

