/*
 * Decompiled with CFR 0.152.
 */
package com.chibde.visualizer;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.chibde.BaseVisualizer;

public class BarVisualizer
extends BaseVisualizer {
    private float density = 50.0f;
    private int gap;

    public BarVisualizer(Context context) {
        super(context);
    }

    public BarVisualizer(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public BarVisualizer(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init() {
        this.density = 50.0f;
        this.gap = 4;
        this.paint.setStyle(Paint.Style.FILL);
    }

    public void setDensity(float density) {
        this.density = density;
        if (density > 256.0f) {
            this.density = 256.0f;
        } else if (density < 10.0f) {
            this.density = 10.0f;
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.bytes != null) {
            float barWidth = (float)this.getWidth() / this.density;
            float div = (float)this.bytes.length / this.density;
            this.paint.setStrokeWidth(barWidth - (float)this.gap);
            int i = 0;
            while ((float)i < this.density) {
                int x = (int)Math.ceil((float)i * div);
                int top = canvas.getHeight() + (byte)(Math.abs(this.bytes[x]) + 128) * canvas.getHeight() / 128;
                canvas.drawLine((float)i * barWidth, (float)this.getHeight(), (float)i * barWidth, (float)top, this.paint);
                ++i;
            }
            super.onDraw(canvas);
        }
    }
}

