/*
 * Decompiled with CFR 0.152.
 */
package com.chesire.lintrules.xml.detectors;

import com.android.SdkConstants;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.XmlContext;
import com.chesire.lintrules.xml.issues.UnexpectedAttribute;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\u0012\u001a\u00020\b*\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/chesire/lintrules/xml/detectors/UnexpectedAttributeDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkConstraintLayout", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "getApplicableElements", "", "", "kotlin.jvm.PlatformType", "visitElement", "report", "Lcom/chesire/lintrules/xml/issues/UnexpectedAttribute;", "node", "Lorg/w3c/dom/Node;", "lintrules-xml"})
public final class UnexpectedAttributeDetector
extends LayoutDetector {
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkParameterIsNotNull((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.LAYOUT;
    }

    @NotNull
    public List<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)SdkConstants.CONSTRAINT_LAYOUT.newName());
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String string = element.getNodeName();
        if (Intrinsics.areEqual((Object)string, (Object)SdkConstants.CONSTRAINT_LAYOUT.newName())) {
            this.checkConstraintLayout(context, element);
        }
    }

    private final void checkConstraintLayout(XmlContext context, Element element) {
        if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "orientation")) {
            Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "orientation");
            Intrinsics.checkExpressionValueIsNotNull((Object)attr, (String)"element.getAttributeNode\u2026ID_URI, ATTR_ORIENTATION)");
            this.report(UnexpectedAttribute.INSTANCE, context, attr);
        }
    }

    private final void report(@NotNull UnexpectedAttribute $this$report, XmlContext context, Node node) {
        Context.report$default((Context)context, (Issue)$this$report.getIssue(), (Location)context.getNameLocation(node), (String)$this$report.getMessage(), null, (int)8, null);
    }
}

