/*
 * Decompiled with CFR 0.152.
 */
package com.chesire.lintrules.xml.detectors;

import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.XmlContext;
import com.chesire.lintrules.xml.issues.ColorCasing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\f*\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0011\u001a\u00020\f*\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/chesire/lintrules/xml/detectors/ColorCasingDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "colorRegex", "Lkotlin/text/Regex;", "getApplicableElements", "", "", "shouldReportOn", "", "value", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "report", "Lcom/chesire/lintrules/xml/issues/ColorCasing;", "attr", "Lorg/w3c/dom/Attr;", "node", "Lorg/w3c/dom/Node;", "lintrules-xml"})
public final class ColorCasingDetector
extends ResourceXmlDetector {
    private final Regex colorRegex = new Regex("#[a-fA-F\\d]{3,8}");

    @NotNull
    public Collection<String> getApplicableElements() {
        List list = ResourceXmlDetector.ALL;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ALL");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (Intrinsics.areEqual((Object)element.getNodeName(), (Object)"color")) {
            String string = element.getTextContent();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.textContent");
            if (this.shouldReportOn(string)) {
                this.report(ColorCasing.INSTANCE, context, element);
            }
        } else {
            NamedNodeMap namedNodeMap = element.getAttributes();
            Intrinsics.checkExpressionValueIsNotNull((Object)namedNodeMap, (String)"element.attributes");
            NamedNodeMap $this$forEach$iv = namedNodeMap;
            boolean $i$f$forEach = false;
            ArrayList<Node> copy$iv = new ArrayList<Node>($this$forEach$iv.getLength());
            int n = 0;
            int n2 = $this$forEach$iv.getLength();
            while (n < n2) {
                void i$iv;
                copy$iv.add($this$forEach$iv.item((int)i$iv));
                ++i$iv;
            }
            Iterable $this$forEach$iv$iv = copy$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                Node it$iv = (Node)element$iv$iv;
                boolean bl = false;
                Node node = it$iv;
                boolean bl2 = false;
                String string = node.getNodeValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.nodeValue");
                if (!this.shouldReportOn(string)) continue;
                Node node2 = node;
                if (node2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Attr");
                }
                this.report(ColorCasing.INSTANCE, context, (Attr)node2);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldReportOn(String value) {
        CharSequence charSequence = value;
        Regex regex = this.colorRegex;
        boolean bl = false;
        if (!regex.matches(charSequence)) return false;
        CharSequence $this$any$iv = value;
        boolean $i$f$any = false;
        CharSequence charSequence2 = $this$any$iv;
        int n = 0;
        while (n < charSequence2.length()) {
            char element$iv;
            char it = element$iv = charSequence2.charAt(n);
            boolean bl2 = false;
            char c = it;
            boolean bl3 = false;
            if (Character.isLowerCase(c)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private final void report(@NotNull ColorCasing $this$report, XmlContext context, Node node) {
        Context.report$default((Context)context, (Issue)$this$report.getIssue(), (Location)context.getLocation(node), (String)$this$report.getMessage(), null, (int)8, null);
    }

    private final void report(@NotNull ColorCasing $this$report, XmlContext context, Attr attr) {
        Context.report$default((Context)context, (Issue)$this$report.getIssue(), (Location)context.getValueLocation(attr), (String)$this$report.getMessage(), null, (int)8, null);
    }
}

