/*
 * Decompiled with CFR 0.152.
 */
package com.android.rangeview;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.graphics.drawable.DrawableCompat;
import com.android.rangeview.R;
import com.android.rangeview.ViewHelper;
import java.util.ArrayList;
import java.util.List;

public class SplitRangeView
extends View {
    private final int prefferedTextHeight;
    RectF boxRect = new RectF();
    int handleSize;
    int thumbPadding;
    float top;
    float bottom;
    float currentX;
    private TimeLineChangeListener timeLineChangeListener;
    private Drawable handleDrawable;
    private Drawable handleRightDrawable;
    private Drawable borderDrawable;
    private final int leftGravity;
    private int rightGravity;
    private List<Span> rangeSpans = new ArrayList<Span>();
    private Span activeSpan;
    private Paint spanTextPaint;
    private GestureDetector gestureDetector;
    private Rect tempRect = new Rect();
    private int textPad = 40;
    private int minimumSize = 10;

    public void setInfoPadding(int textPad) {
        this.textPad = textPad;
    }

    public void setMinimumSize(int minimumSize) {
        this.minimumSize = minimumSize;
    }

    public static int dpToPx(Context context, float dp) {
        float density = context.getResources().getDisplayMetrics().density;
        return (int)(dp * density + 0.5f);
    }

    public SplitRangeView(Context context) {
        this(context, null);
    }

    public SplitRangeView(Context context, AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public SplitRangeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent e) {
                return SplitRangeView.this.singleTapConfirmed(e);
            }
        });
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.RangeSeekBarView, 0, 0);
        this.handleSize = (int)typedArray.getDimension(R.styleable.RangeSeekBarView_thumb_size, (float)SplitRangeView.dpToPx(context, 20.0f));
        this.thumbPadding = typedArray.getDimensionPixelSize(R.styleable.RangeSeekBarView_thumb_padding, 0);
        this.leftGravity = typedArray.getInt(R.styleable.RangeSeekBarView_thumbGravity, 17);
        this.rightGravity = ViewHelper.revertGravity(this.leftGravity);
        int id = typedArray.getResourceId(R.styleable.RangeSeekBarView_thumbSrc, -1);
        if (id != -1) {
            this.handleDrawable = AppCompatResources.getDrawable((Context)this.getContext(), (int)id);
        }
        if (this.handleDrawable != null) {
            if (Build.VERSION.SDK_INT >= 23 && this.handleDrawable.getConstantState() != null) {
                this.handleRightDrawable = this.handleDrawable.getConstantState().newDrawable();
                this.handleRightDrawable.setLayoutDirection(1);
                this.handleRightDrawable.setAutoMirrored(true);
            } else {
                this.handleRightDrawable = this.handleDrawable;
            }
            if (typedArray.hasValue(R.styleable.RangeSeekBarView_srcTint)) {
                ColorStateList tint = typedArray.getColorStateList(R.styleable.RangeSeekBarView_srcTint);
                this.handleDrawable = this.handleDrawable.mutate();
                DrawableCompat.setTintList((Drawable)this.handleDrawable, (ColorStateList)tint);
                this.handleRightDrawable = this.handleRightDrawable.mutate();
                DrawableCompat.setTintList((Drawable)this.handleRightDrawable, (ColorStateList)tint);
            }
        }
        if ((id = typedArray.getResourceId(R.styleable.RangeSeekBarView_background, R.drawable.background)) != -1) {
            this.borderDrawable = AppCompatResources.getDrawable((Context)this.getContext(), (int)id);
        }
        typedArray.recycle();
        this.spanTextPaint = new Paint(1);
        this.spanTextPaint.setTextSize((float)SplitRangeView.dpToPx(this.getContext(), 12.0f));
        this.spanTextPaint.setColor(-1);
        this.spanTextPaint.getTextBounds("A", 0, 1, this.tempRect);
        this.prefferedTextHeight = this.tempRect.height();
    }

    public void setTextColor(int color) {
        this.spanTextPaint.setColor(color);
    }

    public void setTextSize(float size) {
        this.spanTextPaint.setTextSize(size);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) != 0x40000000) {
            int height = this.handleSize + this.getPaddingBottom() + this.getPaddingTop();
            this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), height);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.isEnabled()) {
            return false;
        }
        this.gestureDetector.onTouchEvent(ev);
        switch (ev.getActionMasked()) {
            case 0: {
                this.currentX = ev.getX();
                this.activeSpan = this.findBarUnder(this.currentX);
                return true;
            }
            case 2: {
                float newX = ev.getX(0);
                float dx = newX - this.currentX;
                this.currentX = newX;
                Log.d((String)"trim", (String)("X " + newX + " dx = " + dx));
                int dxInt = (int)dx;
                boolean hasUpdate = false;
                if (this.activeSpan == null) break;
                if (this.activeSpan.handlesShowing) {
                    hasUpdate = true;
                    if (this.activeSpan.leftDragging) {
                        this.handleLeftMovement(this.activeSpan, dxInt);
                    } else if (this.activeSpan.rightDragging) {
                        this.handleRightMovement(this.activeSpan, dxInt);
                    } else if (this.activeSpan.translateDragging) {
                        int amount = this.computeActualDistance(this.activeSpan, dxInt);
                        if (amount != 0) {
                            this.activeSpan.move(amount);
                        } else {
                            hasUpdate = false;
                        }
                    } else {
                        float rightDiff;
                        float leftDiff = Math.abs(newX - (float)this.activeSpan.offset);
                        if (leftDiff < (rightDiff = Math.abs(newX - (float)this.activeSpan.end())) && leftDiff <= (float)this.handleSize) {
                            this.handleLeftMovement(this.activeSpan, dxInt);
                        } else if (rightDiff < leftDiff && rightDiff <= (float)this.handleSize) {
                            this.handleRightMovement(this.activeSpan, dxInt);
                        } else {
                            int amount = this.computeActualDistance(this.activeSpan, dxInt);
                            if (amount != 0) {
                                this.activeSpan.translateDragging = true;
                                this.activeSpan.move(amount);
                            } else {
                                hasUpdate = false;
                            }
                        }
                    }
                }
                if (!hasUpdate) break;
                this.invalidate();
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 1: 
            case 3: {
                if (this.activeSpan != null && this.timeLineChangeListener != null) {
                    this.timeLineChangeListener.onRangeChanged(this.activeSpan.tag, (float)this.activeSpan.offset * 1.0f / (float)this.getWidth(), (float)this.activeSpan.end() * 1.0f / (float)this.getWidth());
                }
                if (this.activeSpan == null) break;
                this.activeSpan.translateDragging = false;
                this.activeSpan.rightDragging = false;
                this.activeSpan.leftDragging = false;
                this.activeSpan = null;
            }
        }
        return super.onTouchEvent(ev);
    }

    private void handleLeftMovement(Span span, int dx) {
        if (dx < 0) {
            int newDx = this.computeActualDistance(span, dx);
            if (newDx != 0) {
                span.shrinkLeft(newDx);
            }
        } else {
            span.shrinkLeft(Math.min(dx, span.length - this.minimumSize));
        }
        span.leftDragging = true;
    }

    private void handleRightMovement(Span span, int dx) {
        if (dx > 0) {
            int newDx = this.computeActualDistance(span, dx);
            if (newDx != 0) {
                span.length += newDx;
            }
        } else {
            span.length = Math.max(span.length + dx, this.minimumSize);
        }
        span.rightDragging = true;
    }

    private int computeActualDistance(Span target, int dx) {
        boolean canMove;
        boolean bl = canMove = dx < 0 && target.offset + dx > 0 || dx > 0 && target.end() + dx < this.getWidth();
        if (!canMove) {
            return 0;
        }
        for (Span child : this.rangeSpans) {
            if (child == target) continue;
            if (dx > 0) {
                if (child.offset > target.offset) {
                    canMove = child.offset >= target.end() + dx;
                }
            } else if (child.end() <= target.offset) {
                boolean bl2 = canMove = child.end() <= target.offset + dx;
            }
            if (canMove) continue;
            return dx > 0 ? child.offset - target.end() : child.end() - target.offset;
        }
        return dx;
    }

    private Span findBarUnder(float x) {
        for (Span range : this.rangeSpans) {
            if (!((float)range.offset - (float)this.handleSize / 2.0f < x) || !(x < (float)range.end() + (float)this.handleSize / 2.0f)) continue;
            return range;
        }
        return null;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.top = this.getPaddingTop();
        this.bottom = h - this.getPaddingBottom();
    }

    public void addSpan(int offset, int length, String info, Object obj) {
        Span newSpan = new Span(offset, length, info, obj);
        for (Span range : this.rangeSpans) {
            if (!this.overlap(newSpan, range)) continue;
            Log.d((String)"SplitRangeView", (String)"Cannot have overlapping bars");
            return;
        }
        this.rangeSpans.add(newSpan);
    }

    public void addSpan(int offset, int length, String info) {
        this.addSpan(offset, length, info, null);
    }

    public void addSpan(int offset, int length) {
        this.addSpan(offset, length, null, null);
    }

    public void removeSpan(Object tag) {
        int i;
        for (i = 0; i < this.rangeSpans.size() && this.rangeSpans.get((int)i).tag != tag; ++i) {
        }
        if (i < this.rangeSpans.size()) {
            this.rangeSpans.remove(i);
            this.invalidate();
        }
    }

    public void updateSpan(Object tag, String newInfo) {
        for (Span span : this.rangeSpans) {
            if (span.tag != tag) continue;
            span.info = newInfo;
            this.invalidate();
            return;
        }
    }

    public void updateSpan(Object tag, boolean selected) {
        for (Span span : this.rangeSpans) {
            if (span.tag != tag) continue;
            span.handlesShowing = selected;
            this.invalidate();
            return;
        }
    }

    private boolean overlap(Span target, Span source) {
        return target.offset <= source.end() && source.offset <= target.end();
    }

    protected void onDraw(Canvas canvas) {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            Span selectedSpan = null;
            for (Span range : this.rangeSpans) {
                String txt;
                this.boxRect.set((float)range.offset, this.top, (float)range.end(), this.bottom);
                if (this.borderDrawable != null) {
                    this.borderDrawable.setBounds((int)this.boxRect.left, (int)this.boxRect.top, (int)this.boxRect.right, (int)this.boxRect.bottom);
                    if (range.handlesShowing) {
                        this.borderDrawable.setState(SELECTED_STATE_SET);
                    } else {
                        this.borderDrawable.setState(EMPTY_STATE_SET);
                    }
                    this.borderDrawable.draw(canvas);
                }
                if (!TextUtils.isEmpty((CharSequence)(txt = range.info))) {
                    int leftPad = (this.leftGravity & 7) == 5 ? this.handleSize + this.thumbPadding : this.textPad;
                    this.drawInfo(canvas, range, leftPad);
                }
                if (!range.handlesShowing) continue;
                selectedSpan = range;
            }
            if (selectedSpan != null && this.handleDrawable != null) {
                Rect leftBounds = this.bound(selectedSpan.offset, this.leftGravity);
                Rect rightBounds = this.bound(selectedSpan.end(), this.rightGravity);
                if (leftBounds.right < rightBounds.left) {
                    this.handleDrawable.setBounds(leftBounds);
                    this.handleDrawable.draw(canvas);
                    this.handleRightDrawable.setBounds(rightBounds);
                    this.handleRightDrawable.draw(canvas);
                }
            }
        }
    }

    private void drawInfo(Canvas canvas, Span span, int leftPadding) {
        String txt = span.info;
        this.spanTextPaint.getTextBounds(txt, 0, span.info.length(), this.tempRect);
        if (this.boxRect.width() - (float)(2 * this.textPad) < (float)this.tempRect.width()) {
            int newEnd = (int)((float)txt.length() * (this.boxRect.width() - (float)(2 * this.textPad)) / (float)this.tempRect.width());
            txt = newEnd <= 0 ? "" : (newEnd < txt.length() ? txt.substring(0, newEnd) : txt);
        }
        canvas.drawText(txt, this.boxRect.left + (float)leftPadding, this.boxRect.bottom - (this.boxRect.height() - (float)this.prefferedTextHeight) / 2.0f, this.spanTextPaint);
    }

    private Rect bound(int anchor, int gravity) {
        int height = this.handleSize;
        Rect rect = new Rect();
        switch (gravity & 0x70) {
            case 16: {
                rect.top = (this.getHeight() - height) / 2;
                rect.bottom = (this.getHeight() + height) / 2;
                break;
            }
            case 80: {
                rect.top = this.getHeight() - height;
                rect.bottom = this.getHeight();
                break;
            }
            default: {
                rect.top = 0;
                rect.bottom = height;
            }
        }
        switch (gravity & 7) {
            case 1: {
                rect.left = anchor - this.handleSize / 2;
                break;
            }
            case 5: {
                rect.left = anchor + this.thumbPadding;
                break;
            }
            default: {
                rect.left = anchor - this.handleSize - this.thumbPadding;
            }
        }
        rect.right = rect.left + this.handleSize;
        return rect;
    }

    public void addIndicatorChangeListener(TimeLineChangeListener timeLineChangeListener) {
        this.timeLineChangeListener = timeLineChangeListener;
    }

    private boolean singleTapConfirmed(MotionEvent e) {
        float x = e.getX();
        Span spanToSelect = null;
        Span spanToDeselect = null;
        for (Span range : this.rangeSpans) {
            if ((float)range.offset < x && x < (float)range.end()) {
                range.handlesShowing = true;
                spanToSelect = range;
                continue;
            }
            if (!range.handlesShowing) continue;
            range.handlesShowing = false;
            spanToDeselect = range;
        }
        if (spanToSelect != null) {
            this.notifySelectionChange(spanToSelect.tag, true);
        } else if (spanToDeselect != null) {
            this.notifySelectionChange(spanToDeselect.tag, false);
        }
        this.invalidate();
        return false;
    }

    private void notifySelectionChange(Object tag, boolean val) {
        if (this.timeLineChangeListener != null) {
            this.timeLineChangeListener.onSelectionChange(tag, val);
        }
    }

    static class Span {
        int offset;
        int length;
        String info;
        Object tag;
        boolean handlesShowing;
        boolean leftDragging;
        boolean rightDragging;
        boolean translateDragging;

        public Span(int offset, int length, String info, Object tag) {
            this.offset = offset;
            this.length = length;
            this.info = info;
            this.tag = tag;
        }

        public int end() {
            return this.offset + this.length;
        }

        void shrinkLeft(int dx) {
            int oldOffset = this.offset;
            this.offset += dx;
            this.length -= this.offset - oldOffset;
        }

        public void move(int dx) {
            this.offset += dx;
        }
    }

    public static interface TimeLineChangeListener {
        public void onRangeChanged(Object var1, float var2, float var3);

        public void onSelectionChange(Object var1, boolean var2);
    }
}

