/*
 * Decompiled with CFR 0.152.
 */
package com.android.rangeview;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.graphics.ColorUtils;
import androidx.core.graphics.drawable.DrawableCompat;
import com.android.rangeview.R;
import com.android.rangeview.ViewHelper;

public class RangeSeekBarView
extends View {
    Paint negativePaint = new Paint(1);
    PointF arrowPos = new PointF();
    RectF boxRect = new RectF();
    int handleSize;
    int thumbPadding;
    boolean showTrace;
    float x1;
    float x2;
    float top;
    float bottom;
    float right;
    float left;
    float currentX;
    private Handle leftHandle = new Handle();
    private Handle rightHandle = new Handle();
    private Handle moveHandle = new Handle();
    private Handle positionHandle = new Handle();
    private int pointerId;
    private TimeLineChangeListener timeLineChangeListener;
    private long maxValue;
    private Drawable handleDrawable;
    private Drawable handleRightDrawable;
    private Drawable borderDrawable;
    private final int leftGravity;
    private int rightGravity;

    public static int dpToPx(Context context, float dp) {
        float density = context.getResources().getDisplayMetrics().density;
        return (int)(dp * density + 0.5f);
    }

    public RangeSeekBarView(Context context) {
        this(context, null);
    }

    public RangeSeekBarView(Context context, AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public RangeSeekBarView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.RangeSeekBarView, 0, 0);
        this.handleSize = (int)typedArray.getDimension(R.styleable.RangeSeekBarView_thumb_size, (float)RangeSeekBarView.dpToPx(context, 20.0f));
        this.thumbPadding = typedArray.getDimensionPixelSize(R.styleable.RangeSeekBarView_thumb_padding, 0);
        this.showTrace = typedArray.getBoolean(R.styleable.RangeSeekBarView_show_trace, true);
        this.leftGravity = typedArray.getInt(R.styleable.RangeSeekBarView_thumbGravity, 17);
        this.rightGravity = ViewHelper.revertGravity(this.leftGravity);
        int id = typedArray.getResourceId(R.styleable.RangeSeekBarView_thumbSrc, -1);
        if (id != -1) {
            this.handleDrawable = AppCompatResources.getDrawable((Context)this.getContext(), (int)id);
        }
        if (this.handleDrawable != null) {
            if (Build.VERSION.SDK_INT >= 23 && this.handleDrawable.getConstantState() != null) {
                this.handleRightDrawable = this.handleDrawable.getConstantState().newDrawable();
                this.handleRightDrawable.setLayoutDirection(1);
                this.handleRightDrawable.setAutoMirrored(true);
            } else {
                this.handleRightDrawable = this.handleDrawable;
            }
            if (typedArray.hasValue(R.styleable.RangeSeekBarView_srcTint)) {
                ColorStateList tint = typedArray.getColorStateList(R.styleable.RangeSeekBarView_srcTint);
                this.handleDrawable = this.handleDrawable.mutate();
                DrawableCompat.setTintList((Drawable)this.handleDrawable, (ColorStateList)tint);
                this.handleRightDrawable = this.handleRightDrawable.mutate();
                DrawableCompat.setTintList((Drawable)this.handleRightDrawable, (ColorStateList)tint);
            }
        }
        if ((id = typedArray.getResourceId(R.styleable.RangeSeekBarView_background, R.drawable.background)) != -1) {
            this.borderDrawable = AppCompatResources.getDrawable((Context)this.getContext(), (int)id);
        }
        if (this.showTrace) {
            int color = ViewHelper.getDefiningColor(this.borderDrawable);
            int negativeColor = color != -1 ? ColorUtils.setAlphaComponent((int)color, (int)128) : Color.parseColor((String)"#80000000");
            this.negativePaint.setColor(negativeColor);
        }
        typedArray.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) != 0x40000000) {
            int height = this.handleSize + this.getPaddingBottom() + this.getPaddingTop();
            this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), height);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.isEnabled()) {
            return false;
        }
        switch (ev.getActionMasked()) {
            case 0: {
                this.currentX = ev.getX();
                this.pointerId = ev.getPointerId(0);
                return true;
            }
            case 2: {
                float newX = ev.getX(0);
                float dx = newX - this.currentX;
                this.currentX = newX;
                Log.d((String)"trim", (String)("X " + newX + " dx = " + dx));
                boolean hasUpdate = true;
                if (this.leftHandle.active) {
                    this.x1 = Math.max(this.left, Math.min(this.x1 + dx, this.x2 - (float)this.handleSize));
                    Log.d((String)"trim", (String)("left - " + newX));
                } else if (this.rightHandle.active) {
                    this.x2 = Math.max(Math.min(this.x2 + dx, this.right), this.x1 + (float)this.handleSize);
                } else if (this.moveHandle.active) {
                    this.moveScene(dx);
                } else if (Math.abs(newX - this.leftHandle.pos) <= (float)this.handleSize) {
                    this.x1 += dx;
                    this.leftHandle.pointerId = this.pointerId;
                    this.leftHandle.active = true;
                } else if (Math.abs(newX - this.rightHandle.pos) <= (float)this.handleSize) {
                    this.x2 += dx;
                    this.rightHandle.pointerId = this.pointerId;
                    this.rightHandle.active = true;
                } else if (newX > this.x1 && newX < this.x2) {
                    this.moveScene(dx);
                    this.moveHandle.active = true;
                } else {
                    hasUpdate = false;
                }
                if (!hasUpdate) break;
                if (this.timeLineChangeListener != null) {
                    this.timeLineChangeListener.onRangeMove(this.convertToStart(), this.convertToEnd());
                }
                this.invalidate();
                break;
            }
            case 1: 
            case 3: {
                if (this.timeLineChangeListener != null && (this.moveHandle.active || this.leftHandle.active || this.rightHandle.active)) {
                    long duration = this.convertToEnd();
                    this.timeLineChangeListener.onRangeChanged(this.convertToStart(), duration);
                }
                this.leftHandle.active = false;
                this.rightHandle.active = false;
                this.moveHandle.active = false;
            }
        }
        return super.onTouchEvent(ev);
    }

    private long convertToStart() {
        return (long)((float)this.maxValue * (this.x1 - this.left) / this.width());
    }

    private long convertToEnd() {
        return (long)((float)this.maxValue * ((this.x2 - (float)this.handleSize - this.left) / this.width()));
    }

    private void moveScene(float dx) {
        float prevDiff = this.x2 - this.x1;
        if (this.x1 + dx < this.left) {
            this.x1 = this.left;
            this.x2 = this.left + prevDiff;
        } else if (this.x2 + dx > this.right) {
            this.x2 = this.right;
            this.x1 = this.x2 - prevDiff;
        } else {
            this.x1 += dx;
            this.x2 += dx;
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.x1 = this.left = (float)this.getPaddingLeft();
        this.x2 = this.right = (float)(w - this.getPaddingRight());
        this.top = this.getPaddingTop();
        this.bottom = h - this.getPaddingBottom();
    }

    public void setDuration(long duration) {
        this.maxValue = duration;
    }

    public void resetState(long start, long duration, boolean animate) {
        float right;
        if (this.getWidth() == 0 || this.maxValue == 0L) {
            return;
        }
        float left = start == 0L ? this.left : this.left + this.width() * (float)start / (float)this.maxValue;
        float f = right = duration == -1L ? this.right : this.right - (this.width() - this.width() * (float)duration / (float)this.maxValue);
        if (animate) {
            ValueAnimator leftAnim = ValueAnimator.ofFloat((float[])new float[]{this.x1, left});
            leftAnim.addUpdateListener(animation -> {
                this.x1 = ((Float)animation.getAnimatedValue()).floatValue();
                this.invalidate();
            });
            ValueAnimator rightAnim = ValueAnimator.ofFloat((float[])new float[]{this.x2, right});
            rightAnim.addUpdateListener(animation -> {
                this.x2 = ((Float)animation.getAnimatedValue()).floatValue();
                this.invalidate();
            });
            AnimatorSet set = new AnimatorSet();
            set.play((Animator)leftAnim).with((Animator)rightAnim);
            set.start();
        } else {
            this.x1 = left;
            this.x2 = right;
            this.invalidate();
        }
    }

    private float width() {
        return this.right - this.left - (float)this.handleSize;
    }

    void drawTrace1(Canvas canvas) {
        int borderHeight = this.borderDrawable.getIntrinsicHeight() > 0 ? this.borderDrawable.getIntrinsicHeight() : (int)this.boxRect.height();
        int top = (this.getHeight() - borderHeight) / 2;
        int bottom = top + borderHeight;
        boolean extra1 = false;
        boolean extra2 = false;
        canvas.drawRect(this.left, (float)top, this.x1 + (float)extra1, (float)bottom, this.negativePaint);
        canvas.drawRect(this.x2 - (float)extra2, (float)top, this.right, (float)bottom, this.negativePaint);
    }

    void drawTrace2(Canvas canvas) {
        if (this.x1 > this.left || this.right > this.x2) {
            this.borderDrawable.setBounds((int)this.left, (int)this.top, (int)this.right, (int)this.bottom);
            this.borderDrawable.setAlpha(90);
            this.borderDrawable.draw(canvas);
            this.borderDrawable.setAlpha(255);
        }
    }

    protected void drawTrace(Canvas canvas) {
        this.drawTrace2(canvas);
    }

    protected void onDraw(Canvas canvas) {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            this.boxRect.set(this.x1, this.top, this.x2, this.bottom);
            if (this.borderDrawable != null) {
                if (this.showTrace) {
                    this.drawTrace(canvas);
                }
                this.borderDrawable.setBounds((int)this.boxRect.left, (int)this.boxRect.top, (int)this.boxRect.right, (int)this.boxRect.bottom);
                this.borderDrawable.draw(canvas);
            }
            if (this.handleDrawable != null) {
                this.handleDrawable.setBounds(this.bound((int)this.x1, this.leftGravity));
                this.handleDrawable.draw(canvas);
                this.leftHandle.pos = this.handleDrawable.getBounds().left + this.handleSize / 2;
            } else {
                this.leftHandle.pos = this.x1;
            }
            if (this.handleRightDrawable != null) {
                this.handleRightDrawable.setBounds(this.bound((int)this.x2, this.rightGravity));
                this.handleRightDrawable.draw(canvas);
                this.rightHandle.pos = this.handleRightDrawable.getBounds().left + this.handleSize / 2;
            } else {
                this.rightHandle.pos = this.x2;
            }
        }
    }

    private Rect bound(int anchor, int gravity) {
        Rect rect = new Rect();
        switch (gravity & 0x70) {
            case 16: {
                rect.top = (this.getHeight() - this.handleSize) / 2;
                rect.bottom = (this.getHeight() + this.handleSize) / 2;
                break;
            }
            case 80: {
                rect.top = this.getHeight() - this.handleSize;
                rect.bottom = this.getHeight();
                break;
            }
            default: {
                rect.top = 0;
                rect.bottom = this.handleSize;
            }
        }
        switch (gravity & 7) {
            case 1: {
                rect.left = anchor - this.handleSize / 2;
                break;
            }
            case 5: {
                rect.left = anchor + this.thumbPadding;
                break;
            }
            default: {
                rect.left = anchor - this.handleSize - this.thumbPadding;
            }
        }
        rect.right = rect.left + this.handleSize;
        return rect;
    }

    public void setRange() {
        float diff = this.x2 / 3.0f;
        this.x1 += diff;
        this.arrowPos.x += diff;
        this.x2 -= diff;
        this.invalidate();
    }

    public void addIndicatorChangeListener(TimeLineChangeListener timeLineChangeListener) {
        this.timeLineChangeListener = timeLineChangeListener;
    }

    public static interface TimeLineChangeListener {
        public void onRangeChanged(long var1, long var3);

        public void onRangeMove(long var1, long var3);
    }

    class Handle {
        int pointerId;
        boolean active;
        float pos;

        Handle() {
        }
    }
}

