/*
 * Decompiled with CFR 0.152.
 */
package com.cheekiat.indicatorsteplib;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.cheekiat.indicatorsteplib.DotOnClickListener;
import com.cheekiat.indicatorsteplib.R;
import java.util.ArrayList;
import java.util.List;

public class StepProgress
extends LinearLayout {
    Context mContext;
    List<String> storeData = new ArrayList<String>();
    int dotDefaultSize;
    float dotSelectedSize;
    int itemMargins;
    int mode;
    int barHeight;
    int textSize;
    private Integer selectedTextColor;
    private Integer unselectTextColor;
    private Integer selectedColor;
    private Integer unselectColor;
    DotOnClickListener onClickListener;
    float unselectSize;

    public StepProgress(Context context) {
        super(context);
        this.initView(context);
    }

    public void setDotsOnClickListener(DotOnClickListener onClickListener) {
        this.onClickListener = onClickListener;
    }

    public StepProgress(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    public StepProgress(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initView(Context context, AttributeSet attrs) {
        int checkItemMargins;
        this.mContext = context;
        int storeSelectedSize = 0;
        if (attrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.StepUi, 0, 0);
            try {
                this.mode = a.getInteger(R.styleable.StepUi_indicator_mode, 0);
                this.barHeight = a.getInteger(R.styleable.StepUi_barHeight, 20);
                this.selectedTextColor = a.getColor(R.styleable.StepUi_selectedTextColor, -1);
                this.unselectTextColor = a.getColor(R.styleable.StepUi_unselectTextColor, -16777216);
                this.selectedColor = a.getColor(R.styleable.StepUi_selectedColor, Color.parseColor((String)"#F3AD33"));
                this.unselectColor = a.getColor(R.styleable.StepUi_unselectColor, Color.parseColor((String)"#D6D6D6"));
                this.itemMargins = a.getDimensionPixelSize(R.styleable.StepUi_itemMargins, 15);
                this.dotDefaultSize = a.getDimensionPixelSize(R.styleable.StepUi_dotDefaultSize, 60);
                storeSelectedSize = a.getDimensionPixelSize(R.styleable.StepUi_dotSelectedSize, 90);
                this.textSize = a.getDimensionPixelSize(R.styleable.StepUi_textSize, 10);
            }
            finally {
                a.recycle();
            }
        }
        if (this.mode == 1 && this.barHeight > this.dotDefaultSize) {
            this.barHeight = this.dotDefaultSize;
        }
        if ((checkItemMargins = (storeSelectedSize - this.dotDefaultSize) / 2) > this.itemMargins) {
            this.itemMargins = checkItemMargins;
        }
        this.dotSelectedSize = (float)(1.0 / (double)this.dotDefaultSize) * (float)storeSelectedSize;
        this.unselectSize = (float)(1.0 / (double)this.dotDefaultSize) * (float)this.dotDefaultSize;
    }

    private void initView(Context context) {
        this.mContext = context;
        this.initView(context, null);
    }

    public void selected(int position) {
        if (this.mode == 0) {
            for (int j = 0; j < this.getChildCount(); ++j) {
                View mView = this.getChildAt(j);
                if (position == j) {
                    mView.setBackgroundResource(R.drawable.selected);
                    mView.animate().scaleX(this.dotSelectedSize);
                    mView.animate().scaleY(this.dotSelectedSize);
                    this.changeColor(mView.getBackground(), this.selectedColor);
                } else {
                    mView.setBackgroundResource(R.drawable.unselect);
                    mView.animate().scaleX(this.unselectSize);
                    mView.animate().scaleY(this.unselectSize);
                    this.changeColor(mView.getBackground(), this.unselectColor);
                }
                mView.invalidate();
            }
        } else {
            LinearLayout v = (LinearLayout)this.findViewById(R.id.linear_layout);
            View pv = this.findViewById(R.id.progress_bar);
            for (int j = 0; j < v.getChildCount(); ++j) {
                TextView mView = (TextView)v.getChildAt(j);
                if (position + 1 > j) {
                    mView.setBackgroundResource(R.drawable.selected);
                    mView.setTextColor(this.selectedTextColor.intValue());
                    this.changeColor(mView.getBackground(), this.selectedColor);
                } else {
                    mView.setBackgroundResource(R.drawable.unselect);
                    mView.setTextColor(this.unselectTextColor.intValue());
                    this.changeColor(mView.getBackground(), this.unselectColor);
                }
                if (position == j) {
                    mView.animate().scaleX(this.dotSelectedSize);
                    mView.animate().scaleY(this.dotSelectedSize);
                    continue;
                }
                mView.animate().scaleX(this.unselectSize);
                mView.animate().scaleY(this.unselectSize);
            }
            int sum = v.getChildCount();
            int vw = v.getWidth() - this.dotDefaultSize - this.itemMargins * 2;
            if (--sum > 0) {
                this.animationViewSize(pv, position * (vw / sum));
            }
        }
    }

    public void addDot() {
        this.removeAllViews();
        this.storeData.add(null);
        this.initData(this.storeData);
    }

    public void addDot(String data) {
        this.removeAllViews();
        this.storeData.add(data);
        this.initData(this.storeData);
    }

    private void initData(List<String> storeData) {
        if (this.mode == 0) {
            LinearLayout.LayoutParams mParams = new LinearLayout.LayoutParams(-2, -2);
            int i = 0;
            while (i < storeData.size()) {
                TextView text = new TextView(this.mContext);
                if (storeData.get(i) != null) {
                    text.setText((CharSequence)storeData.get(i));
                }
                text.setBackgroundResource(R.drawable.unselect);
                mParams.setMargins(this.itemMargins, this.itemMargins, this.itemMargins, this.itemMargins);
                text.setLayoutParams((ViewGroup.LayoutParams)mParams);
                text.setGravity(17);
                text.setWidth(this.dotDefaultSize);
                text.setHeight(this.dotDefaultSize);
                text.setTextSize((float)this.textSize);
                final int finalI = i++;
                text.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (StepProgress.this.onClickListener != null) {
                            StepProgress.this.onClickListener.onClick(finalI);
                        }
                    }
                });
                this.addView((View)text);
            }
            this.selected(0);
        } else {
            LinearLayout.LayoutParams mParams = new LinearLayout.LayoutParams(-2, -2);
            RelativeLayout.LayoutParams maViewParams = new RelativeLayout.LayoutParams(-2, -2);
            RelativeLayout relativeLayout = new RelativeLayout(this.getContext());
            LinearLayout linearLayout = new LinearLayout(this.getContext());
            linearLayout.setOrientation(0);
            linearLayout.setId(R.id.linear_layout);
            maViewParams.addRule(13, 1);
            linearLayout.setLayoutParams((ViewGroup.LayoutParams)maViewParams);
            RelativeLayout.LayoutParams mViewParams = new RelativeLayout.LayoutParams(-1, this.barHeight);
            View defaultBarView = new View(this.getContext());
            defaultBarView.setBackgroundColor(this.unselectColor.intValue());
            mViewParams.addRule(19, R.id.linear_layout);
            mViewParams.addRule(15, 1);
            mViewParams.setMargins(this.itemMargins + this.dotDefaultSize / 2, 0, this.itemMargins + this.dotDefaultSize / 2, 0);
            defaultBarView.setLayoutParams((ViewGroup.LayoutParams)mViewParams);
            relativeLayout.addView(defaultBarView);
            RelativeLayout.LayoutParams selectedBarViewParams = new RelativeLayout.LayoutParams(0, this.barHeight);
            View selectedBarView = new View(this.getContext());
            selectedBarView.setBackgroundColor(this.selectedColor.intValue());
            selectedBarView.setId(R.id.progress_bar);
            selectedBarViewParams.addRule(9, 1);
            selectedBarViewParams.addRule(15, 1);
            selectedBarViewParams.setMargins(this.itemMargins + this.dotDefaultSize / 2, 0, this.itemMargins + this.dotDefaultSize / 2, 0);
            selectedBarView.setLayoutParams((ViewGroup.LayoutParams)selectedBarViewParams);
            relativeLayout.addView(selectedBarView);
            int i = 0;
            while (i < storeData.size()) {
                TextView text = new TextView(this.mContext);
                if (storeData.get(i) != null) {
                    text.setText((CharSequence)storeData.get(i));
                }
                text.setBackgroundResource(R.drawable.unselect);
                mParams.setMargins(this.itemMargins, this.itemMargins, this.itemMargins, this.itemMargins);
                text.setLayoutParams((ViewGroup.LayoutParams)mParams);
                text.setGravity(17);
                text.setTextSize((float)this.textSize);
                text.setWidth(this.dotDefaultSize);
                text.setHeight(this.dotDefaultSize);
                final int finalI = i++;
                text.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (StepProgress.this.onClickListener != null) {
                            StepProgress.this.onClickListener.onClick(finalI);
                        }
                    }
                });
                linearLayout.addView((View)text);
            }
            relativeLayout.addView((View)linearLayout);
            this.addView((View)relativeLayout);
            this.selected(0);
        }
    }

    void animationViewSize(final View view, int width) {
        ValueAnimator anim = ValueAnimator.ofInt((int[])new int[]{view.getMeasuredWidth(), width});
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int val = (Integer)valueAnimator.getAnimatedValue();
                ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                layoutParams.width = val;
                view.setLayoutParams(layoutParams);
            }
        });
        anim.setDuration(300L);
        anim.start();
    }

    void changeColor(Drawable background, Integer color) {
        if (background instanceof ShapeDrawable) {
            ((ShapeDrawable)background.mutate()).getPaint().setColor(color.intValue());
        } else if (background instanceof GradientDrawable) {
            ((GradientDrawable)background.mutate()).setColor(color.intValue());
        } else if (background instanceof ColorDrawable) {
            ((ColorDrawable)background.mutate()).setColor(color.intValue());
        }
    }
}

