/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.httpClient;

import com.cx.restclient.common.UrlUtils;
import com.cx.restclient.dto.LoginSettings;
import com.cx.restclient.dto.ProxyConfig;
import com.cx.restclient.dto.TokenLoginResponse;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.exception.CxTokenExpiredException;
import com.cx.restclient.osa.dto.ClientType;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.win.WindowsCredentialsProvider;
import org.apache.http.impl.auth.win.WindowsNTLMSchemeFactory;
import org.apache.http.impl.auth.win.WindowsNegotiateSchemeFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;

public class CxHttpClient {
    private static String HTTP_HOST = System.getProperty("http.proxyHost");
    private static String HTTP_PORT = System.getProperty("http.proxyPort");
    private static String HTTP_USERNAME = System.getProperty("http.proxyUser");
    private static String HTTP_PASSWORD = System.getProperty("http.proxyPassword");
    private static String HTTPS_HOST = System.getProperty("https.proxyHost");
    private static String HTTPS_PORT = System.getProperty("https.proxyPort");
    private static String HTTPS_USERNAME = System.getProperty("https.proxyUser");
    private static String HTTPS_PASSWORD = System.getProperty("https.proxyPassword");
    private static final String LOGIN_FAILED_MSG = "Fail to login with windows authentication: ";
    private static HttpClient apacheClient;
    private Logger log;
    private TokenLoginResponse token;
    private String rootUri;
    private final String refreshToken;
    private String cxOrigin;
    private Boolean useSSo;
    private LoginSettings lastLoginSettings;
    private String teamPath;
    private CookieStore cookieStore = new BasicCookieStore();
    private HttpClientBuilder cb = HttpClients.custom();
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public CxHttpClient(String rootUri, String origin, boolean disableSSLValidation, boolean isSSO, String refreshToken, @Nullable ProxyConfig proxyConfig, Logger log) throws CxClientException {
        this.log = log;
        this.rootUri = rootUri;
        this.refreshToken = refreshToken;
        this.cxOrigin = origin;
        this.useSSo = isSSO;
        this.cb.setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build());
        this.setSSLTls("TLSv1.2", log);
        if (disableSSLValidation) {
            try {
                this.cb.setSSLSocketFactory((LayeredConnectionSocketFactory)CxHttpClient.getTrustAllSSLSocketFactory());
                this.cb.setConnectionManager((HttpClientConnectionManager)CxHttpClient.getHttpConnectionManager(true));
            }
            catch (CxClientException e) {
                log.warn("Failed to disable certificate verification: " + e.getMessage());
            }
        } else {
            this.cb.setConnectionManager((HttpClientConnectionManager)CxHttpClient.getHttpConnectionManager(false));
        }
        this.cb.setConnectionManagerShared(true);
        CxHttpClient.setCustomProxy(this.cb, proxyConfig, log);
        if (this.useSSo.booleanValue()) {
            this.cb.setDefaultCredentialsProvider((CredentialsProvider)new WindowsCredentialsProvider((CredentialsProvider)new SystemDefaultCredentialsProvider()));
            this.cb.setDefaultCookieStore(this.cookieStore);
        } else {
            this.cb.setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy());
        }
        this.cb.setDefaultAuthSchemeRegistry(CxHttpClient.getAuthSchemeProviderRegistry());
        this.cb.useSystemProperties();
        apacheClient = this.cb.build();
    }

    private static void setCustomProxy(HttpClientBuilder cb, ProxyConfig proxyConfig, Logger logi) {
        if (proxyConfig == null || StringUtils.isEmpty((CharSequence)proxyConfig.getHost()) || proxyConfig.getPort() == 0) {
            return;
        }
        String scheme = proxyConfig.isUseHttps() ? "https" : "http";
        HttpHost proxy = new HttpHost(proxyConfig.getHost(), proxyConfig.getPort(), scheme);
        if (StringUtils.isNotEmpty((CharSequence)proxyConfig.getUsername()) && StringUtils.isNotEmpty((CharSequence)proxyConfig.getPassword())) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyConfig.getUsername(), proxyConfig.getPassword());
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(proxy), (Credentials)credentials);
            cb.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        logi.info("Setting proxy for Checkmarx http client");
        cb.setProxy(proxy);
        cb.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(proxy));
        cb.setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
    }

    private static SSLConnectionSocketFactory getTrustAllSSLSocketFactory() throws CxClientException {
        SSLContext sslContext;
        TrustAllStrategy acceptingTrustStrategy = new TrustAllStrategy();
        try {
            sslContext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)acceptingTrustStrategy).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new CxClientException("Fail to set trust all certificate, 'SSLConnectionSocketFactory'", e);
        }
        return new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
    }

    private static PoolingHttpClientConnectionManager getHttpConnectionManager(boolean disableSSLValidation) throws CxClientException {
        SSLConnectionSocketFactory factory = disableSSLValidation ? CxHttpClient.getTrustAllSSLSocketFactory() : new SSLConnectionSocketFactory(SSLContexts.createDefault());
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)factory).register("http", (Object)new PlainConnectionSocketFactory()).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connManager.setMaxTotal(50);
        connManager.setDefaultMaxPerRoute(5);
        return connManager;
    }

    private static Registry<AuthSchemeProvider> getAuthSchemeProviderRegistry() {
        return RegistryBuilder.create().register("Digest", (Object)new DigestSchemeFactory()).register("Basic", (Object)new BasicSchemeFactory()).register("NTLM", (Object)new WindowsNTLMSchemeFactory(null)).register("Negotiate", (Object)new WindowsNegotiateSchemeFactory(null)).build();
    }

    public void login(LoginSettings settings) throws IOException, CxClientException {
        this.lastLoginSettings = settings;
        if (!settings.getSessionCookies().isEmpty()) {
            this.setSessionCookies(settings.getSessionCookies());
            return;
        }
        if (settings.getRefreshToken() != null) {
            this.token = this.getAccessTokenFromRefreshToken(settings);
        } else if (this.useSSo.booleanValue()) {
            if (settings.getVersion().equals("lower than 9.0")) {
                this.ssoLegacyLogin();
            } else {
                this.token = this.ssoLogin();
            }
        } else {
            this.token = this.generateToken(settings);
        }
    }

    public ArrayList<Cookie> ssoLegacyLogin() throws CxClientException {
        HttpResponse loginResponse = null;
        try {
            HttpUriRequest request = RequestBuilder.post().setUri(this.rootUri + "auth/ssologin").setConfig(RequestConfig.DEFAULT).setEntity((HttpEntity)new StringEntity("", StandardCharsets.UTF_8)).build();
            loginResponse = apacheClient.execute(request);
        }
        catch (IOException e) {
            try {
                this.log.error(LOGIN_FAILED_MSG + e.getMessage());
                throw new CxClientException(LOGIN_FAILED_MSG + e.getMessage());
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(loginResponse);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)loginResponse);
        this.setSessionCookies(this.cookieStore.getCookies());
        return new ArrayList<Cookie>(this.cookieStore.getCookies());
    }

    private void setSessionCookies(List<Cookie> cookies) {
        String cxCookie = null;
        String csrfToken = null;
        for (Cookie cookie : cookies) {
            if (cookie.getName().equals("CXCSRFToken")) {
                csrfToken = cookie.getValue();
            }
            if (!cookie.getName().equals("cxCookie")) continue;
            cxCookie = cookie.getValue();
        }
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        headers.add(new BasicHeader("CXCSRFToken", csrfToken));
        headers.add(new BasicHeader("cookie", String.format("CXCSRFToken=%s; cxCookie=%s", csrfToken, cxCookie)));
        apacheClient = this.cb.setDefaultHeaders(headers).build();
    }

    private TokenLoginResponse ssoLogin() throws CxClientException {
        HttpResponse response = null;
        String BASE_URL = "/auth/identity/";
        RequestConfig requestConfig = RequestConfig.custom().setRedirectsEnabled(false).setAuthenticationEnabled(true).setCookieSpec("standard").build();
        try {
            HttpUriRequest request = RequestBuilder.post().setUri(this.rootUri + "auth/identity/externalLogin").setConfig(requestConfig).setHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString()).setEntity((HttpEntity)this.generateSSOEntity()).build();
            response = apacheClient.execute(request);
            String cookies = this.retrieveCookies();
            String redirectURL = response.getHeaders("Location")[0].getValue();
            request = RequestBuilder.get().setUri(this.rootUri + "/auth/identity/" + redirectURL).setConfig(requestConfig).setHeader("Cookie", cookies).setHeader("Upgrade-Insecure-Requests", "1").build();
            response = apacheClient.execute(request);
            cookies = this.retrieveCookies();
            redirectURL = response.getHeaders("Location")[0].getValue();
            redirectURL = this.rootUri + redirectURL.replace("/CxRestAPI/", "");
            request = RequestBuilder.get().setUri(redirectURL).setConfig(requestConfig).setHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString()).setHeader("Cookie", cookies).build();
            response = apacheClient.execute(request);
            return this.extractToken(response);
        }
        catch (IOException e) {
            this.log.error(LOGIN_FAILED_MSG + e.getMessage());
            throw new CxClientException(LOGIN_FAILED_MSG + e.getMessage());
        }
    }

    private TokenLoginResponse extractToken(HttpResponse response) {
        String redirectURL = response.getHeaders("Location")[0].getValue();
        if (!redirectURL.contains("access_token")) {
            throw new CxClientException("Failed retrieving access token from server");
        }
        return (TokenLoginResponse)new Gson().fromJson(this.urlToJson(redirectURL), TokenLoginResponse.class);
    }

    private String urlToJson(String url) {
        url = url.replaceAll("=", "\":\"");
        url = url.replaceAll("&", "\",\"");
        return "{\"" + url + "\"}";
    }

    private String retrieveCookies() {
        List cookieList = this.cookieStore.getCookies();
        StringBuilder builder = new StringBuilder();
        cookieList.forEach(cookie -> builder.append(cookie.getName()).append("=").append(cookie.getValue()).append(";"));
        return builder.toString();
    }

    public TokenLoginResponse generateToken(LoginSettings settings) throws IOException, CxClientException {
        UrlEncodedFormEntity requestEntity = this.generateUrlEncodedFormEntity(settings);
        String fullUrl = UrlUtils.parseURLToString(settings.getAccessControlBaseUrl(), "identity/connect/token");
        HttpPost post = new HttpPost(fullUrl);
        try {
            return this.request((HttpRequestBase)post, ContentType.APPLICATION_FORM_URLENCODED.toString(), (HttpEntity)requestEntity, TokenLoginResponse.class, 200, "authenticate", false, false);
        }
        catch (CxClientException e) {
            if (!e.getMessage().contains("invalid_scope")) {
                throw new CxClientException(String.format("Failed to generate access token, failure error was: %s", e.getMessage()), e);
            }
            ClientType.RESOURCE_OWNER.setScopes("sast_rest_api");
            settings.setClientTypeForPasswordAuth(ClientType.RESOURCE_OWNER);
            requestEntity = this.generateUrlEncodedFormEntity(settings);
            return this.request((HttpRequestBase)post, ContentType.APPLICATION_FORM_URLENCODED.toString(), (HttpEntity)requestEntity, TokenLoginResponse.class, 200, "authenticate", false, false);
        }
    }

    private TokenLoginResponse getAccessTokenFromRefreshToken(LoginSettings settings) throws IOException, CxClientException {
        UrlEncodedFormEntity requestEntity = this.generateTokenFromRefreshEntity(settings);
        String fullUrl = UrlUtils.parseURLToString(settings.getAccessControlBaseUrl(), "identity/connect/token");
        HttpPost post = new HttpPost(fullUrl);
        try {
            return this.request((HttpRequestBase)post, ContentType.APPLICATION_FORM_URLENCODED.toString(), (HttpEntity)requestEntity, TokenLoginResponse.class, 200, "authenticate", false, false);
        }
        catch (CxClientException e) {
            throw new CxClientException(String.format("Failed to generate access token from refresh token failure error was: %s", e.getMessage()), e);
        }
    }

    public void revokeToken(String token) throws IOException, CxClientException {
        UrlEncodedFormEntity requestEntity = this.generateRevocationEntity(ClientType.CLI, token);
        HttpPost post = new HttpPost(this.rootUri + "auth/identity/connect/revocation");
        try {
            this.request((HttpRequestBase)post, ContentType.APPLICATION_FORM_URLENCODED.toString(), (HttpEntity)requestEntity, String.class, 200, "revocation", false, false);
        }
        catch (CxClientException e) {
            throw new CxClientException(String.format("Token revocation failure error was: %s", e.getMessage()), e);
        }
    }

    private UrlEncodedFormEntity generateRevocationEntity(ClientType clientType, String token) throws UnsupportedEncodingException {
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("token_type_hint", "refresh_token"));
        parameters.add(new BasicNameValuePair("token", token));
        parameters.add(new BasicNameValuePair("client_id", clientType.getClientId()));
        parameters.add(new BasicNameValuePair("client_secret", clientType.getClientSecret()));
        return new UrlEncodedFormEntity(parameters, "utf-8");
    }

    private UrlEncodedFormEntity generateUrlEncodedFormEntity(LoginSettings settings) throws UnsupportedEncodingException {
        ClientType clientType = settings.getClientTypeForPasswordAuth();
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("username", settings.getUsername()));
        parameters.add(new BasicNameValuePair("password", settings.getPassword()));
        parameters.add(new BasicNameValuePair("grant_type", "password"));
        parameters.add(new BasicNameValuePair("scope", clientType.getScopes()));
        parameters.add(new BasicNameValuePair("client_id", clientType.getClientId()));
        parameters.add(new BasicNameValuePair("client_secret", clientType.getClientSecret()));
        if (!StringUtils.isEmpty((CharSequence)settings.getTenant())) {
            String authContext = String.format("Tenant:%s", settings.getTenant());
            parameters.add(new BasicNameValuePair("acr_values", authContext));
        }
        return new UrlEncodedFormEntity(parameters, "utf-8");
    }

    private UrlEncodedFormEntity generateTokenFromRefreshEntity(LoginSettings settings) throws UnsupportedEncodingException {
        ClientType clientType = settings.getClientTypeForRefreshToken();
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("grant_type", "refresh_token"));
        parameters.add(new BasicNameValuePair("client_id", clientType.getClientId()));
        parameters.add(new BasicNameValuePair("client_secret", clientType.getClientSecret()));
        parameters.add(new BasicNameValuePair("refresh_token", settings.getRefreshToken()));
        return new UrlEncodedFormEntity(parameters, StandardCharsets.UTF_8.name());
    }

    public <T> T getRequest(String relPath, String contentType, Class<T> responseType, int expectStatus, String failedMsg, boolean isCollection) throws IOException, CxClientException {
        return this.getRequest(this.rootUri, relPath, "application/json", contentType, responseType, expectStatus, failedMsg, isCollection);
    }

    public <T> T getRequest(String rootURL, String relPath, String acceptHeader, String contentType, Class<T> responseType, int expectStatus, String failedMsg, boolean isCollection) throws IOException, CxClientException {
        HttpGet get = new HttpGet(rootURL + relPath);
        get.addHeader("Accept", acceptHeader);
        return this.request((HttpRequestBase)get, contentType, null, responseType, expectStatus, "get " + failedMsg, isCollection, true);
    }

    public <T> T postRequest(String relPath, String contentType, HttpEntity entity, Class<T> responseType, int expectStatus, String failedMsg) throws IOException, CxClientException {
        HttpPost post = new HttpPost(this.rootUri + relPath);
        return this.request((HttpRequestBase)post, contentType, entity, responseType, expectStatus, failedMsg, false, true);
    }

    public <T> T putRequest(String relPath, String contentType, HttpEntity entity, Class<T> responseType, int expectStatus, String failedMsg) throws IOException, CxClientException {
        HttpPut put = new HttpPut(this.rootUri + relPath);
        return this.request((HttpRequestBase)put, contentType, entity, responseType, expectStatus, failedMsg, false, true);
    }

    public void patchRequest(String relPath, String contentType, HttpEntity entity, int expectStatus, String failedMsg) throws IOException, CxClientException {
        HttpPatch patch = new HttpPatch(this.rootUri + relPath);
        this.request((HttpRequestBase)patch, contentType, entity, null, expectStatus, failedMsg, false, true);
    }

    public void setTeamPathHeader(String teamPath) {
        this.teamPath = teamPath;
    }

    public void addCustomHeader(String name, String value) {
        this.log.debug(String.format("Adding a custom header: %s: %s", name, value));
        this.customHeaders.put(name, value);
    }

    /*
     * Exception decompiling
     */
    private <T> T request(HttpRequestBase httpMethod, String contentType, HttpEntity entity, Class<T> responseType, int expectStatus, String failedMsg, boolean isCollection, boolean retry) throws IOException, CxClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void close() {
        HttpClientUtils.closeQuietly((HttpClient)apacheClient);
    }

    private void setSSLTls(String protocol, Logger log) {
        try {
            SSLContext sslContext = SSLContext.getInstance(protocol);
            sslContext.init(null, null, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.warn("Failed to set SSL TLS : " + e.getMessage());
        }
    }

    private StringEntity generateSSOEntity() throws CxClientException {
        String clientId = "cxsast_client";
        String redirectUri = "%2Fcxwebclient%2FauthCallback.html%3F";
        String responseType = "id_token%20token";
        String nonce = "9313f0902ba64e50bc564f5137f35a52";
        String isPrompt = "true";
        String scopes = "sast_api openid sast-permissions access-control-permissions access_control_api management_and_orchestration_api".replace(" ", "%20");
        String providerId = "2";
        String redirectUrl = MessageFormat.format("/CxRestAPI/auth/identity/connect/authorize/callback?client_id={0}&redirect_uri={1}%2Fcxwebclient%2FauthCallback.html%3F&response_type={2}&scope={3}&nonce={4}&prompt={5}", "cxsast_client", this.rootUri, "id_token%20token", scopes, "9313f0902ba64e50bc564f5137f35a52", "true");
        try {
            ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
            urlParameters.add(new BasicNameValuePair("redirectUrl", redirectUrl));
            urlParameters.add(new BasicNameValuePair("providerid", "2"));
            return new UrlEncodedFormEntity(urlParameters, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new CxClientException(e.getMessage());
        }
    }

    public void setToken(TokenLoginResponse token) {
        this.token = token;
    }

    private void logTokenError(HttpRequestBase httpMethod, int statusCode, CxTokenExpiredException ex) {
        String message = String.format("Received status code %d for URL: %s with the message: %s", statusCode, httpMethod.getURI(), ex.getMessage());
        this.log.warn(message);
        this.log.info("Possible reason: access token has expired. Trying to request a new token...");
    }
}

