/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.ast;

import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.osa.dto.ClientType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientTypeResolver {
    private static final Logger log = LoggerFactory.getLogger(ClientTypeResolver.class);
    private static final String WELL_KNOWN_CONFIG_PATH = "identity/.well-known/openid-configuration";
    private static final String SCOPES_JSON_PROP = "scopes_supported";
    private static final Set<String> scopesForCloudAuth = new HashSet<String>(Arrays.asList("sca_api", "offline_access"));
    private static final Set<String> scopesForOnPremAuth = new HashSet<String>(Arrays.asList("sast_rest_api", "cxarm_api"));
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public ClientType determineClientType(String accessControlServerBaseUrl) {
        String fullUrl = ClientTypeResolver.getFullUrl(accessControlServerBaseUrl);
        JsonNode response = this.getConfigResponse(fullUrl);
        Set<String> supportedScopes = ClientTypeResolver.getSupportedScopes(response);
        Set<String> scopesToUse = this.getScopesForAuth(supportedScopes);
        String clientSecret = scopesToUse.equals(scopesForOnPremAuth) ? ClientType.RESOURCE_OWNER.getClientSecret() : "";
        String scopesForRequest = String.join((CharSequence)" ", scopesToUse);
        return new ClientType(ClientType.RESOURCE_OWNER.getClientId(), scopesForRequest, clientSecret);
    }

    private Set<String> getScopesForAuth(Set<String> supportedScopes) {
        Set<String> result;
        if (supportedScopes.containsAll(scopesForCloudAuth)) {
            result = scopesForCloudAuth;
        } else if (supportedScopes.containsAll(scopesForOnPremAuth)) {
            result = scopesForOnPremAuth;
        } else {
            String message = String.format("Access control server doesn't support the necessary scopes (either %s or %s). It only supports the following scopes: %s.", scopesForCloudAuth, scopesForOnPremAuth, supportedScopes);
            throw new CxClientException(message);
        }
        log.debug(String.format("Using scopes: %s", result));
        return result;
    }

    /*
     * Exception decompiling
     */
    private JsonNode getConfigResponse(String fullUrl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Set<String> getSupportedScopes(JsonNode response) {
        Set result = null;
        if (response != null) {
            TypeReference<Set<String>> typeRef = new TypeReference<Set<String>>(){};
            result = (Set)objectMapper.convertValue((Object)response.get(SCOPES_JSON_PROP), (TypeReference)typeRef);
        }
        return Optional.ofNullable(result).orElse(new HashSet());
    }

    private static String getFullUrl(String baseUrl) {
        String result = StringUtils.appendIfMissing((String)baseUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + WELL_KNOWN_CONFIG_PATH;
        log.debug(String.format("Using OpenID configuration URL: %s", result));
        return result;
    }
}

