/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient;

import com.cx.restclient.common.Scanner;
import com.cx.restclient.common.ShragaUtils;
import com.cx.restclient.common.Waiter;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.cxArm.dto.CxProviders;
import com.cx.restclient.cxArm.utils.CxARMUtils;
import com.cx.restclient.dto.Results;
import com.cx.restclient.dto.Status;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.httpClient.CxHttpClient;
import com.cx.restclient.httpClient.utils.HttpClientHelper;
import com.cx.restclient.osa.dto.CVE;
import com.cx.restclient.osa.dto.CreateOSAScanRequest;
import com.cx.restclient.osa.dto.CreateOSAScanResponse;
import com.cx.restclient.osa.dto.Library;
import com.cx.restclient.osa.dto.OSAResults;
import com.cx.restclient.osa.dto.OSAScanStatus;
import com.cx.restclient.osa.dto.OSAScanStatusEnum;
import com.cx.restclient.osa.dto.OSASummaryResults;
import com.cx.restclient.osa.utils.OSAUtils;
import com.cx.restclient.sast.utils.LegacyClient;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.whitesource.fs.ComponentScan;

public class CxOSAClient
extends LegacyClient
implements Scanner {
    private Waiter<OSAScanStatus> osaWaiter;
    private String scanId;
    private OSAResults osaResults = new OSAResults();

    public OSAScanStatus getStatus(String id) throws IOException {
        return this.getOSAScanStatus(id);
    }

    public CxOSAClient(CxScanConfig config, Logger log) throws MalformedURLException {
        super(config, log);
        int interval = config.getOsaProgressInterval() != null ? config.getOsaProgressInterval() : 20;
        int retry = config.getConnectionRetries() != null ? config.getConnectionRetries() : 3;
        this.osaWaiter = new Waiter<OSAScanStatus>("CxOSA scan", interval, retry){

            @Override
            public OSAScanStatus getStatus(String id) throws IOException {
                return CxOSAClient.this.getOSAScanStatus(id);
            }

            @Override
            public void printProgress(OSAScanStatus scanStatus) {
                CxOSAClient.this.printOSAProgress(scanStatus, this.getStartTimeSec());
            }

            @Override
            public OSAScanStatus resolveStatus(OSAScanStatus scanStatus) {
                return CxOSAClient.this.resolveOSAStatus(scanStatus);
            }
        };
    }

    @Override
    public Results initiateScan() {
        this.osaResults = new OSAResults();
        this.ensureProjectIdSpecified();
        this.log.info("----------------------------------- Create CxOSA Scan:------------------------------------");
        this.log.info("Creating OSA scan");
        String osaDependenciesJson = this.config.getOsaDependenciesJson();
        if (osaDependenciesJson == null) {
            try {
                osaDependenciesJson = this.resolveOSADependencies();
            }
            catch (Exception e) {
                throw new CxClientException("Failed to resolve dependencies for OSA scan: " + e.getMessage(), e);
            }
        }
        try {
            this.scanId = this.sendOSAScan(osaDependenciesJson, this.projectId);
        }
        catch (IOException e) {
            this.scanId = null;
            throw new CxClientException("Error sending OSA scan request.", e);
        }
        this.osaResults.setOsaProjectSummaryLink(this.config.getUrl(), this.projectId);
        this.osaResults.setOsaScanId(this.scanId);
        return this.osaResults;
    }

    public void setOsaFSAProperties(Properties fsaConfig) {
        this.config.setOsaFsaConfig(fsaConfig);
    }

    private String resolveOSADependencies() throws JsonProcessingException {
        this.log.info("Scanning for CxOSA compatible files");
        Properties scannerProperties = this.config.getOsaFsaConfig();
        if (scannerProperties == null) {
            scannerProperties = OSAUtils.generateOSAScanConfiguration(this.config.getOsaFolderExclusions(), this.config.getOsaFilterPattern(), this.config.getOsaArchiveIncludePatterns(), this.config.getEffectiveSourceDirForDependencyScan(), this.config.getOsaRunInstall(), this.config.getOsaScanDepth(), this.log);
        }
        ObjectMapper mapper = new ObjectMapper();
        this.log.info("Scanner properties: " + mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)scannerProperties.toString()));
        ComponentScan componentScan = new ComponentScan(scannerProperties);
        String osaDependenciesJson = componentScan.scan();
        OSAUtils.writeToOsaListToFile(OSAUtils.getWorkDirectory(this.config.getReportsDir(), this.config.getOsaGenerateJsonReport()), osaDependenciesJson, this.log);
        return osaDependenciesJson;
    }

    @Override
    public CxHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public Results waitForScanResults() {
        this.ensureProjectIdSpecified();
        if (this.scanId == null) {
            throw new CxClientException("Scan was not created.");
        }
        this.log.info("-------------------------------------Get CxOSA Results:-----------------------------------");
        this.log.info("Waiting for OSA scan to finish");
        OSAScanStatus osaScanStatus = this.osaWaiter.waitForTaskToFinish(this.scanId, this.config.getOsaScanTimeoutInMinutes(), this.log);
        this.log.info("OSA scan finished successfully. Retrieving OSA scan results");
        this.log.info("Creating OSA reports");
        try {
            this.osaResults = this.retrieveOSAResults(this.scanId, osaScanStatus, this.projectId);
        }
        catch (IOException e) {
            throw new CxClientException("Failed to retrieve OSA results.", e);
        }
        if (this.config.getEnablePolicyViolations()) {
            this.resolveOSAViolation(this.osaResults, this.projectId);
        }
        OSAUtils.printOSAResultsToConsole(this.osaResults, this.config.getEnablePolicyViolations(), this.log);
        if (this.config.getReportsDir() != null) {
            OSAUtils.writeJsonToFile("CxOSASummary", this.osaResults.getResults(), this.config.getReportsDir(), this.config.getOsaGenerateJsonReport(), this.log);
            OSAUtils.writeJsonToFile("CxOSALibraries", this.osaResults.getOsaLibraries(), this.config.getReportsDir(), this.config.getOsaGenerateJsonReport(), this.log);
            OSAUtils.writeJsonToFile("CxOSAVulnerabilities", this.osaResults.getOsaVulnerabilities(), this.config.getReportsDir(), this.config.getOsaGenerateJsonReport(), this.log);
        }
        return this.osaResults;
    }

    private OSAResults retrieveOSAResults(String scanId, OSAScanStatus osaScanStatus, long projectId) throws IOException {
        OSASummaryResults osaSummaryResults = this.getOSAScanSummaryResults(scanId);
        List<Library> osaLibraries = this.getOSALibraries(scanId);
        List<CVE> osaVulnerabilities = this.getOSAVulnerabilities(scanId);
        OSAResults results = new OSAResults();
        results.setOsaScanId(scanId);
        results.setResults(osaSummaryResults, osaLibraries, osaVulnerabilities, osaScanStatus, this.config.getUrl(), projectId);
        return results;
    }

    private void resolveOSAViolation(OSAResults osaResults, long projectId) {
        try {
            CxARMUtils.getProjectViolatedPolicies(this.httpClient, this.config.getCxARMUrl(), projectId, CxProviders.OPEN_SOURCE.value()).forEach(osaResults::addPolicy);
        }
        catch (Exception ex) {
            throw new CxClientException("CxARM is not available. Policy violations for OSA cannot be calculated: " + ex.getMessage());
        }
    }

    @Override
    public Results getLatestScanResults() {
        this.osaResults = new OSAResults();
        this.ensureProjectIdSpecified();
        this.log.info("----------------------------------Get CxOSA Last Results:--------------------------------");
        OSAResults osaResults = null;
        try {
            List<OSAScanStatus> scanList = this.getOSALastOSAStatus(this.projectId);
            for (OSAScanStatus s : scanList) {
                if (!Status.SUCCEEDED.value().equals(s.getState().getName())) continue;
                osaResults = this.retrieveOSAResults(s.getId(), s, this.projectId);
                break;
            }
        }
        catch (IOException e) {
            throw new CxClientException("Error getting last scan results.");
        }
        return osaResults;
    }

    private String sendOSAScan(String osaDependenciesJson, long projectId) throws IOException {
        this.log.info("Sending OSA scan request");
        CreateOSAScanResponse osaScan = this.sendOSARequest(projectId, osaDependenciesJson);
        String summaryLink = OSAUtils.composeProjectOSASummaryLink(this.config.getUrl(), projectId);
        this.log.info("OSA scan created successfully. Link to project state: " + summaryLink);
        return osaScan.getScanId();
    }

    private CreateOSAScanResponse sendOSARequest(long projectId, String osaDependenciesJson) throws IOException {
        CreateOSAScanRequest req = new CreateOSAScanRequest(projectId, osaDependenciesJson);
        StringEntity entity = new StringEntity(HttpClientHelper.convertToJson(req), StandardCharsets.UTF_8);
        return this.httpClient.postRequest("osa/inventory", "application/json;v=1.0", (HttpEntity)entity, CreateOSAScanResponse.class, 201, "create OSA scan");
    }

    private OSASummaryResults getOSAScanSummaryResults(String scanId) throws IOException {
        String relativePath = "osa/reports?scanId=" + scanId;
        return this.httpClient.getRequest(relativePath, "application/json;v=1.0", OSASummaryResults.class, 200, "OSA scan summary results", false);
    }

    private List<OSAScanStatus> getOSALastOSAStatus(long projectId) throws IOException {
        return (List)((Object)this.httpClient.getRequest("osa/scans?projectId=" + projectId, "application/json;v=1.0", OSAScanStatus.class, 200, " last OSA scan ID", true));
    }

    private List<Library> getOSALibraries(String scanId) throws IOException {
        String relPath = "/osa/libraries?scanId=" + scanId + "&itemsPerPage=" + 1000000L;
        return (List)((Object)this.httpClient.getRequest(relPath, "application/json;v=1.0", Library.class, 200, "OSA libraries", true));
    }

    private List<CVE> getOSAVulnerabilities(String scanId) throws IOException {
        String relPath = "/osa/vulnerabilities?scanId=" + scanId + "&itemsPerPage=" + 1000000L;
        return (List)((Object)this.httpClient.getRequest(relPath, "application/json;v=1.0", CVE.class, 200, "OSA vulnerabilities", true));
    }

    private OSAScanStatus getOSAScanStatus(String scanId) throws IOException {
        String relPath = "osa/scans/{scanId}".replace("{scanId}", scanId);
        OSAScanStatus scanStatus = this.httpClient.getRequest(relPath, "application/json;v=1.0", OSAScanStatus.class, 200, "OSA scan status", false);
        int stateId = scanStatus.getState().getId();
        if (OSAScanStatusEnum.SUCCEEDED.getNum() == stateId) {
            scanStatus.setBaseStatus(Status.SUCCEEDED);
        } else if (OSAScanStatusEnum.IN_PROGRESS.getNum() == stateId || OSAScanStatusEnum.NOT_STARTED.getNum() == stateId) {
            scanStatus.setBaseStatus(Status.IN_PROGRESS);
        } else {
            scanStatus.setBaseStatus(Status.FAILED);
        }
        return scanStatus;
    }

    private void printOSAProgress(OSAScanStatus scanStatus, long startTime) {
        String timestamp = ShragaUtils.getTimestampSince(startTime);
        this.log.info("Waiting for OSA scan results. Elapsed time: " + timestamp + ". Status: " + scanStatus.getState().getName());
    }

    private OSAScanStatus resolveOSAStatus(OSAScanStatus scanStatus) {
        if (scanStatus == null) {
            throw new CxClientException("OSA scan cannot be completed.");
        }
        if (Status.FAILED == scanStatus.getBaseStatus()) {
            String failedMsg = scanStatus.getState() == null ? "" : "status [" + scanStatus.getState().getName() + "]. Reason: " + scanStatus.getState().getFailureReason();
            throw new CxClientException("OSA scan cannot be completed. " + failedMsg);
        }
        if (Status.SUCCEEDED == scanStatus.getBaseStatus()) {
            this.log.info("OSA scan finished.");
        }
        return scanStatus;
    }

    private void ensureProjectIdSpecified() {
        if (this.projectId == 0L) {
            throw new CxClientException("projectId must be set before executing this method.");
        }
    }
}

